/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.support.Parameter;

public class MetadataReportConfig
extends AbstractConfig {
    private static final long serialVersionUID = 55233L;
    private static final String PREFIX_TAG = StringUtils.camelToSplitName(MetadataReportConfig.class.getSimpleName().substring(0, MetadataReportConfig.class.getSimpleName().length() - 6), "-");
    private String address;
    private String username;
    private String password;
    private Integer timeout;
    private String group;
    private Map<String, String> parameters;
    private Integer retryTimes;
    private Integer retryPeriod;
    private Boolean cycleReport;
    private Boolean syncReport;
    private Boolean cluster;

    public MetadataReportConfig() {
    }

    public MetadataReportConfig(String address) {
        this.setAddress(address);
    }

    @Parameter(excluded=true)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Parameter(key="retry-times")
    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    @Parameter(key="retry-period")
    public Integer getRetryPeriod() {
        return this.retryPeriod;
    }

    public void setRetryPeriod(Integer retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    @Parameter(key="cycle-report")
    public Boolean getCycleReport() {
        return this.cycleReport;
    }

    public void setCycleReport(Boolean cycleReport) {
        this.cycleReport = cycleReport;
    }

    @Parameter(key="sync-report")
    public Boolean getSyncReport() {
        return this.syncReport;
    }

    public void setSyncReport(Boolean syncReport) {
        this.syncReport = syncReport;
    }

    @Override
    @Parameter(excluded=true)
    public String getPrefix() {
        return StringUtils.isNotEmpty(this.prefix) ? this.prefix : "dubbo." + PREFIX_TAG;
    }

    @Override
    @Parameter(excluded=true)
    public boolean isValid() {
        return StringUtils.isNotEmpty(this.address);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean getCluster() {
        return this.cluster;
    }

    public void setCluster(Boolean cluster) {
        this.cluster = cluster;
    }
}

