/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.compiler.support.AdaptiveCompiler;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.support.Parameter;

public class ApplicationConfig
extends AbstractConfig {
    private static final long serialVersionUID = 5508512956753757169L;
    private String name;
    private String version;
    private String owner;
    private String organization;
    private String architecture;
    private String environment;
    private String compiler;
    private String logger;
    private List<RegistryConfig> registries;
    private String registryIds;
    private MonitorConfig monitor;
    private Boolean isDefault;
    private String dumpDirectory;
    private Boolean qosEnable;
    private Integer qosPort;
    private Boolean qosAcceptForeignIp;
    private Map<String, String> parameters;
    private String shutwait;

    public ApplicationConfig() {
    }

    public ApplicationConfig(String name) {
        this.setName(name);
    }

    @Parameter(key="application", required=true, useKeyAsProperty=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        ApplicationConfig.checkName("name", name);
        this.name = name;
        if (StringUtils.isEmpty(this.id)) {
            this.id = name;
        }
    }

    @Parameter(key="application.version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        ApplicationConfig.checkMultiName("owner", owner);
        this.owner = owner;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        ApplicationConfig.checkName("organization", organization);
        this.organization = organization;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        ApplicationConfig.checkName("architecture", architecture);
        this.architecture = architecture;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        ApplicationConfig.checkName("environment", environment);
        if (!(environment == null || "develop".equals(environment) || "test".equals(environment) || "product".equals(environment))) {
            throw new IllegalStateException(String.format("Unsupported environment: %s, only support %s/%s/%s, default is %s.", environment, "develop", "test", "product", "product"));
        }
        this.environment = environment;
    }

    public RegistryConfig getRegistry() {
        return CollectionUtils.isEmpty(this.registries) ? null : this.registries.get(0);
    }

    public void setRegistry(RegistryConfig registry) {
        ArrayList<RegistryConfig> registries = new ArrayList<RegistryConfig>(1);
        registries.add(registry);
        this.registries = registries;
    }

    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<? extends RegistryConfig> registries) {
        this.registries = registries;
    }

    @Parameter(excluded=true)
    public String getRegistryIds() {
        return this.registryIds;
    }

    public void setRegistryIds(String registryIds) {
        this.registryIds = registryIds;
    }

    public MonitorConfig getMonitor() {
        return this.monitor;
    }

    public void setMonitor(String monitor) {
        this.monitor = new MonitorConfig(monitor);
    }

    public void setMonitor(MonitorConfig monitor) {
        this.monitor = monitor;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
        AdaptiveCompiler.setDefaultCompiler(compiler);
    }

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
        LoggerFactory.setLoggerAdapter(logger);
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Parameter(key="dump.directory")
    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public void setDumpDirectory(String dumpDirectory) {
        this.dumpDirectory = dumpDirectory;
    }

    @Parameter(key="qos.enable")
    public Boolean getQosEnable() {
        return this.qosEnable;
    }

    public void setQosEnable(Boolean qosEnable) {
        this.qosEnable = qosEnable;
    }

    @Parameter(key="qos.port")
    public Integer getQosPort() {
        return this.qosPort;
    }

    public void setQosPort(Integer qosPort) {
        this.qosPort = qosPort;
    }

    @Parameter(key="qos.accept.foreign.ip")
    public Boolean getQosAcceptForeignIp() {
        return this.qosAcceptForeignIp;
    }

    public void setQosAcceptForeignIp(Boolean qosAcceptForeignIp) {
        this.qosAcceptForeignIp = qosAcceptForeignIp;
    }

    @Parameter(key="qos-enable", excluded=true)
    public Boolean getQosEnableCompatible() {
        return this.getQosEnable();
    }

    public void setQosEnableCompatible(Boolean qosEnable) {
        this.setQosEnable(qosEnable);
    }

    @Parameter(key="qos-port", excluded=true)
    public Integer getQosPortCompatible() {
        return this.getQosPort();
    }

    public void setQosPortCompatible(Integer qosPort) {
        this.setQosPort(qosPort);
    }

    @Parameter(key="qos-accept-foreign-ip", excluded=true)
    public Boolean getQosAcceptForeignIpCompatible() {
        return this.getQosAcceptForeignIp();
    }

    public void setQosAcceptForeignIpCompatible(Boolean qosAcceptForeignIp) {
        this.setQosAcceptForeignIp(qosAcceptForeignIp);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        ApplicationConfig.checkParameterName(parameters);
        this.parameters = parameters;
    }

    public String getShutwait() {
        return this.shutwait;
    }

    public void setShutwait(String shutwait) {
        System.setProperty("dubbo.service.shutdown.wait", shutwait);
        this.shutwait = shutwait;
    }

    @Override
    @Parameter(excluded=true)
    public boolean isValid() {
        return !StringUtils.isEmpty(this.name);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.appendEnvironmentProperties();
    }

    private void appendEnvironmentProperties() {
        String rawKeys;
        String rawLabels = ConfigurationUtils.getProperty("dubbo.labels");
        if (StringUtils.isNotEmpty(rawLabels)) {
            String[] labelPairs;
            for (String pair : labelPairs = CommonConstants.SEMICOLON_SPLIT_PATTERN.split(rawLabels)) {
                String[] label = CommonConstants.EQUAL_SPLIT_PATTERN.split(pair);
                if (label.length != 2) continue;
                this.updateParameters(this.parameters, label[0], label[1]);
            }
        }
        if (StringUtils.isNotEmpty(rawKeys = ConfigurationUtils.getProperty("dubbo.env.keys"))) {
            String[] keys;
            for (String key : keys = CommonConstants.COMMA_SPLIT_PATTERN.split(rawKeys)) {
                String value = ConfigurationUtils.getProperty(key);
                if (value == null) continue;
                this.updateParameters(this.parameters, key, value);
            }
        }
    }

    private void updateParameters(Map<String, String> map, String key, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, value);
    }
}

