/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.protobuf.support;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.protobuf.support.ProtobufUtils;

public class GenericProtobufObjectInput
implements ObjectInput {
    private final BufferedReader reader;

    public GenericProtobufObjectInput(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    @Override
    public boolean readBool() throws IOException {
        return this.read(Boolean.TYPE);
    }

    @Override
    public byte readByte() throws IOException {
        return this.read(Byte.TYPE);
    }

    @Override
    public short readShort() throws IOException {
        return this.read(Short.TYPE);
    }

    @Override
    public int readInt() throws IOException {
        return this.read(Integer.TYPE);
    }

    @Override
    public long readLong() throws IOException {
        return this.read(Long.TYPE);
    }

    @Override
    public float readFloat() throws IOException {
        return this.read(Float.TYPE).floatValue();
    }

    @Override
    public double readDouble() throws IOException {
        return this.read(Double.TYPE);
    }

    @Override
    public String readUTF() throws IOException {
        return this.read(String.class);
    }

    @Override
    public byte[] readBytes() throws IOException {
        return this.readLine().getBytes();
    }

    @Override
    public Object readObject() throws IOException {
        return this.read(String.class);
    }

    @Override
    public <T> T readObject(Class<T> cls) throws IOException {
        return this.read(cls);
    }

    @Override
    public <T> T readObject(Class<T> cls, Type type) throws IOException {
        return this.readObject(cls);
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null || line.trim().length() == 0) {
            throw new EOFException();
        }
        return line;
    }

    private <T> T read(Class<T> cls) throws IOException {
        if (!ProtobufUtils.isSupported(cls)) {
            throw new IllegalArgumentException("This serialization only support google protobuf entity, the class is :" + cls.getName());
        }
        String json = this.readLine();
        return ProtobufUtils.deserialize(json, cls);
    }
}

