/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public abstract class AbstractProtocol
implements Protocol {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, Exporter<?>> exporterMap = new ConcurrentHashMap();
    protected final Set<Invoker<?>> invokers = new ConcurrentHashSet();

    protected static String serviceKey(URL url) {
        int port = url.getParameter("bind.port", url.getPort());
        return AbstractProtocol.serviceKey(port, url.getPath(), url.getParameter("version"), url.getParameter("group"));
    }

    protected static String serviceKey(int port, String serviceName, String serviceVersion, String serviceGroup) {
        return ProtocolUtils.serviceKey(port, serviceName, serviceVersion, serviceGroup);
    }

    @Override
    public void destroy() {
        for (Invoker<?> invoker : this.invokers) {
            if (invoker == null) continue;
            this.invokers.remove(invoker);
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Destroy reference: " + invoker.getUrl());
                }
                invoker.destroy();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
        for (String key : new ArrayList<String>(this.exporterMap.keySet())) {
            Exporter<?> exporter = this.exporterMap.remove(key);
            if (exporter == null) continue;
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Unexport service: " + exporter.getInvoker().getUrl());
                }
                exporter.unexport();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
    }
}

