/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.lang.reflect.Field;
import org.apache.dubbo.rpc.AbstractResult;

public class RpcResult
extends AbstractResult {
    private static final long serialVersionUID = -6925924956850004727L;

    public RpcResult() {
    }

    public RpcResult(Object result) {
        this.result = result;
    }

    public RpcResult(Throwable exception) {
        this.exception = exception;
    }

    @Override
    public Object recreate() throws Throwable {
        if (this.exception != null) {
            try {
                Class<?> clazz = this.exception.getClass();
                while (!clazz.getName().equals(Throwable.class.getName())) {
                    clazz = clazz.getSuperclass();
                }
                Field stackTraceField = clazz.getDeclaredField("stackTrace");
                stackTraceField.setAccessible(true);
                Object stackTrace = stackTraceField.get(this.exception);
                if (stackTrace == null) {
                    this.exception.setStackTrace(new StackTraceElement[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw this.exception;
        }
        return this.result;
    }

    @Override
    @Deprecated
    public Object getResult() {
        return this.getValue();
    }

    @Deprecated
    public void setResult(Object result) {
        this.setValue(result);
    }

    @Override
    public Object getValue() {
        return this.result;
    }

    public void setValue(Object value) {
        this.result = value;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable e) {
        this.exception = e;
    }

    @Override
    public boolean hasException() {
        return this.exception != null;
    }

    public String toString() {
        return "RpcResult [result=" + this.result + ", exception=" + this.exception + "]";
    }
}

