/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Level;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerAdapter;
import org.apache.dubbo.common.logger.jcl.JclLoggerAdapter;
import org.apache.dubbo.common.logger.jdk.JdkLoggerAdapter;
import org.apache.dubbo.common.logger.log4j.Log4jLoggerAdapter;
import org.apache.dubbo.common.logger.log4j2.Log4j2LoggerAdapter;
import org.apache.dubbo.common.logger.slf4j.Slf4jLoggerAdapter;
import org.apache.dubbo.common.logger.support.FailsafeLogger;

public class LoggerFactory {
    private static final ConcurrentMap<String, FailsafeLogger> LOGGERS = new ConcurrentHashMap<String, FailsafeLogger>();
    private static volatile LoggerAdapter LOGGER_ADAPTER;

    private LoggerFactory() {
    }

    public static void setLoggerAdapter(String loggerAdapter) {
        if (loggerAdapter != null && loggerAdapter.length() > 0) {
            LoggerFactory.setLoggerAdapter(ExtensionLoader.getExtensionLoader(LoggerAdapter.class).getExtension(loggerAdapter));
        }
    }

    public static void setLoggerAdapter(LoggerAdapter loggerAdapter) {
        if (loggerAdapter != null) {
            Logger logger = loggerAdapter.getLogger(LoggerFactory.class.getName());
            logger.info("using logger: " + loggerAdapter.getClass().getName());
            LOGGER_ADAPTER = loggerAdapter;
            for (Map.Entry entry : LOGGERS.entrySet()) {
                ((FailsafeLogger)entry.getValue()).setLogger(LOGGER_ADAPTER.getLogger((String)entry.getKey()));
            }
        }
    }

    public static Logger getLogger(Class<?> key) {
        FailsafeLogger logger = (FailsafeLogger)LOGGERS.get(key.getName());
        if (logger == null) {
            LOGGERS.putIfAbsent(key.getName(), new FailsafeLogger(LOGGER_ADAPTER.getLogger(key)));
            logger = (FailsafeLogger)LOGGERS.get(key.getName());
        }
        return logger;
    }

    public static Logger getLogger(String key) {
        FailsafeLogger logger = (FailsafeLogger)LOGGERS.get(key);
        if (logger == null) {
            LOGGERS.putIfAbsent(key, new FailsafeLogger(LOGGER_ADAPTER.getLogger(key)));
            logger = (FailsafeLogger)LOGGERS.get(key);
        }
        return logger;
    }

    public static Level getLevel() {
        return LOGGER_ADAPTER.getLevel();
    }

    public static void setLevel(Level level) {
        LOGGER_ADAPTER.setLevel(level);
    }

    public static File getFile() {
        return LOGGER_ADAPTER.getFile();
    }

    static {
        String logger = System.getProperty("dubbo.application.logger");
        if ("slf4j".equals(logger)) {
            LoggerFactory.setLoggerAdapter(new Slf4jLoggerAdapter());
        } else if ("jcl".equals(logger)) {
            LoggerFactory.setLoggerAdapter(new JclLoggerAdapter());
        } else if ("log4j".equals(logger)) {
            LoggerFactory.setLoggerAdapter(new Log4jLoggerAdapter());
        } else if ("jdk".equals(logger)) {
            LoggerFactory.setLoggerAdapter(new JdkLoggerAdapter());
        } else if ("log4j2".equals(logger)) {
            LoggerFactory.setLoggerAdapter(new Log4j2LoggerAdapter());
        } else {
            try {
                LoggerFactory.setLoggerAdapter(new Log4jLoggerAdapter());
            }
            catch (Throwable e1) {
                try {
                    LoggerFactory.setLoggerAdapter(new Slf4jLoggerAdapter());
                }
                catch (Throwable e2) {
                    try {
                        LoggerFactory.setLoggerAdapter(new Log4j2LoggerAdapter());
                    }
                    catch (Throwable e3) {
                        try {
                            LoggerFactory.setLoggerAdapter(new JclLoggerAdapter());
                        }
                        catch (Throwable e4) {
                            LoggerFactory.setLoggerAdapter(new JdkLoggerAdapter());
                        }
                    }
                }
            }
        }
    }
}

