/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.config.Environment;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;

public class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);

    public static int getServerShutdownTimeout() {
        int timeout = 10000;
        Configuration configuration = Environment.getInstance().getConfiguration();
        String value = configuration.getString("dubbo.service.shutdown.wait");
        if (value != null && value.length() > 0) {
            try {
                timeout = Integer.parseInt(value);
            }
            catch (Exception exception) {}
        } else {
            value = configuration.getString("dubbo.service.shutdown.wait.seconds");
            if (value != null && value.length() > 0) {
                try {
                    timeout = Integer.parseInt(value) * 1000;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return timeout;
    }

    public static String getProperty(String property) {
        return ConfigurationUtils.getProperty(property, null);
    }

    public static String getProperty(String property, String defaultValue) {
        return Environment.getInstance().getConfiguration().getString(property, defaultValue);
    }

    public static Map<String, String> parseProperties(String content) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isEmpty(content)) {
            logger.warn("You specified the config centre, but there's not even one single config item in it.");
        } else {
            Properties properties = new Properties();
            properties.load(new StringReader(content));
            properties.stringPropertyNames().forEach(k -> map.put((String)k, properties.getProperty((String)k)));
        }
        return map;
    }
}

