/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.decorators.SingleReplyRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindResponse;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindRequestDecorator
extends SingleReplyRequestDecorator<BindRequest, BindResponse>
implements BindRequest {
    private int bindRequestLength;
    private int saslMechanismLength;
    private int saslCredentialsLength;

    public BindRequestDecorator(LdapApiService codec, BindRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setBindRequestLength(int bindRequestLength) {
        this.bindRequestLength = bindRequestLength;
    }

    public int getBindRequestLength() {
        return this.bindRequestLength;
    }

    public void setSaslCredentialsLength(int saslCredentialsLength) {
        this.saslCredentialsLength = saslCredentialsLength;
    }

    public int getSaslCredentialsLength() {
        return this.saslCredentialsLength;
    }

    public void setSaslMechanismLength(int saslMechanismLength) {
        this.saslMechanismLength = saslMechanismLength;
    }

    public int getSaslMechanismLength() {
        return this.saslMechanismLength;
    }

    public BindRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public BindRequest addControl(Control control) throws MessageException {
        return (BindRequest)super.addControl(control);
    }

    public BindRequest addAllControls(Control[] controls) throws MessageException {
        return (BindRequest)super.addAllControls(controls);
    }

    public BindRequest removeControl(Control control) throws MessageException {
        return (BindRequest)super.removeControl(control);
    }

    public boolean isSimple() {
        return ((BindRequest)this.getDecorated()).isSimple();
    }

    public boolean getSimple() {
        return ((BindRequest)this.getDecorated()).getSimple();
    }

    public BindRequest setSimple(boolean isSimple) {
        ((BindRequest)this.getDecorated()).setSimple(isSimple);
        return this;
    }

    public byte[] getCredentials() {
        return ((BindRequest)this.getDecorated()).getCredentials();
    }

    public BindRequest setCredentials(String credentials) {
        ((BindRequest)this.getDecorated()).setCredentials(credentials);
        return this;
    }

    public BindRequest setCredentials(byte[] credentials) {
        ((BindRequest)this.getDecorated()).setCredentials(credentials);
        return this;
    }

    public String getName() {
        return ((BindRequest)this.getDecorated()).getName();
    }

    public BindRequest setName(String name) {
        ((BindRequest)this.getDecorated()).setName(name);
        return this;
    }

    public Dn getDn() {
        return ((BindRequest)this.getDecorated()).getDn();
    }

    public BindRequest setDn(Dn dn) {
        ((BindRequest)this.getDecorated()).setDn(dn);
        return this;
    }

    public boolean isVersion3() {
        return ((BindRequest)this.getDecorated()).isVersion3();
    }

    public boolean getVersion3() {
        return ((BindRequest)this.getDecorated()).getVersion3();
    }

    public BindRequest setVersion3(boolean isVersion3) {
        ((BindRequest)this.getDecorated()).setVersion3(isVersion3);
        return this;
    }

    public String getSaslMechanism() {
        return ((BindRequest)this.getDecorated()).getSaslMechanism();
    }

    public BindRequest setSaslMechanism(String saslMechanism) {
        ((BindRequest)this.getDecorated()).setSaslMechanism(saslMechanism);
        return this;
    }

    @Override
    public int computeLength() {
        int bindRequestLength = 3;
        Dn dn = this.getDn();
        if (!Dn.isNullOrEmpty((Dn)dn)) {
            bindRequestLength += 1 + TLV.getNbBytes((int)Dn.getNbBytes((Dn)dn)) + Dn.getNbBytes((Dn)dn);
        } else {
            String name = this.getName();
            if (Strings.isEmpty((String)name)) {
                name = "";
            }
            bindRequestLength += 1 + TLV.getNbBytes((int)name.getBytes().length) + name.getBytes().length;
        }
        byte[] credentials = this.getCredentials();
        if (this.isSimple()) {
            bindRequestLength = credentials != null ? (bindRequestLength += 1 + TLV.getNbBytes((int)credentials.length) + credentials.length) : (bindRequestLength += 2);
        } else {
            byte[] mechanismBytes = Strings.getBytesUtf8((String)this.getSaslMechanism());
            int saslMechanismLength = 1 + TLV.getNbBytes((int)mechanismBytes.length) + mechanismBytes.length;
            int saslCredentialsLength = 0;
            if (credentials != null) {
                saslCredentialsLength = 1 + TLV.getNbBytes((int)credentials.length) + credentials.length;
            }
            int saslLength = 1 + TLV.getNbBytes((int)(saslMechanismLength + saslCredentialsLength)) + saslMechanismLength + saslCredentialsLength;
            bindRequestLength += saslLength;
            this.setSaslMechanismLength(saslMechanismLength);
            this.setSaslCredentialsLength(saslCredentialsLength);
        }
        this.setBindRequestLength(bindRequestLength);
        return 1 + TLV.getNbBytes((int)bindRequestLength) + bindRequestLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)96);
            buffer.put(TLV.getBytes((int)this.getBindRequestLength()));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]));
        }
        Value.encode((ByteBuffer)buffer, (int)3);
        Dn dn = this.getDn();
        if (!Dn.isNullOrEmpty((Dn)dn)) {
            Value.encode((ByteBuffer)buffer, (byte[])Dn.getBytes((Dn)dn));
        } else {
            String name = this.getName();
            if (Strings.isEmpty((String)name)) {
                name = "";
            }
            Value.encode((ByteBuffer)buffer, (byte[])name.getBytes());
        }
        byte[] credentials = this.getCredentials();
        if (this.isSimple()) {
            try {
                buffer.put((byte)-128);
                if (credentials != null) {
                    buffer.put(TLV.getBytes((int)credentials.length));
                    if (credentials.length == 0) return buffer;
                    buffer.put(credentials);
                    return buffer;
                }
                buffer.put((byte)0);
                return buffer;
            }
            catch (BufferOverflowException boe) {
                String msg = I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]);
                throw new EncoderException(msg);
            }
        }
        try {
            buffer.put((byte)-93);
            byte[] mechanismBytes = Strings.getBytesUtf8((String)this.getSaslMechanism());
            buffer.put(TLV.getBytes((int)(this.getSaslMechanismLength() + this.getSaslCredentialsLength())));
            Value.encode((ByteBuffer)buffer, (byte[])mechanismBytes);
            if (credentials == null) return buffer;
            Value.encode((ByteBuffer)buffer, (byte[])credentials);
            return buffer;
        }
        catch (BufferOverflowException boe) {
            String msg = I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]);
            throw new EncoderException(msg);
        }
    }
}

