/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.decorators.RequestDecorator;
import org.apache.directory.shared.ldap.model.exception.MessageException;
import org.apache.directory.shared.ldap.model.message.AbandonRequest;
import org.apache.directory.shared.ldap.model.message.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbandonRequestDecorator
extends RequestDecorator<AbandonRequest>
implements AbandonRequest {
    public AbandonRequestDecorator(LdapApiService codec, AbandonRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public int getAbandoned() {
        return ((AbandonRequest)this.getDecorated()).getAbandoned();
    }

    public AbandonRequest setAbandoned(int requestId) {
        ((AbandonRequest)this.getDecorated()).setAbandoned(requestId);
        return this;
    }

    public AbandonRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public AbandonRequest addControl(Control control) throws MessageException {
        return (AbandonRequest)super.addControl(control);
    }

    public AbandonRequest addAllControls(Control[] controls) throws MessageException {
        return (AbandonRequest)super.addAllControls(controls);
    }

    public AbandonRequest removeControl(Control control) throws MessageException {
        return (AbandonRequest)super.removeControl(control);
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)80);
            buffer.put((byte)Value.getNbBytes((int)this.getAbandoned()));
            buffer.put(Value.getBytes((int)this.getAbandoned()));
        }
        catch (BufferOverflowException boe) {
            String msg = I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]);
            throw new EncoderException(msg);
        }
        return buffer;
    }

    @Override
    public int computeLength() {
        int length = 2 + Value.getNbBytes((int)this.getAbandoned());
        return length;
    }
}

