/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.search.persistentSearch;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.search.persistentSearch.PersistentSearchContainer;
import org.apache.directory.shared.ldap.codec.controls.search.persistentSearch.PersistentSearchStates;
import org.apache.directory.shared.ldap.model.message.controls.PersistentSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistentSearchGrammar
extends AbstractGrammar<PersistentSearchContainer> {
    static final Logger LOG = LoggerFactory.getLogger(PersistentSearchGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<?> instance = new PersistentSearchGrammar();

    private PersistentSearchGrammar() {
        this.setName(PersistentSearchGrammar.class.getName());
        this.transitions = new GrammarTransition[PersistentSearchStates.LAST_PSEARCH_STATE.ordinal()][256];
        this.transitions[PersistentSearchStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)PersistentSearchStates.START_STATE, (Enum)PersistentSearchStates.PSEARCH_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[PersistentSearchStates.PSEARCH_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)PersistentSearchStates.PSEARCH_SEQUENCE_STATE, (Enum)PersistentSearchStates.CHANGE_TYPES_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<PersistentSearchContainer>("Set PSearchControl changeTypes"){

            public void action(PersistentSearchContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    int changeTypes = IntegerDecoder.parse((Value)value, (int)PersistentSearch.CHANGE_TYPES_MIN, (int)PersistentSearch.CHANGE_TYPES_MAX);
                    if (IS_DEBUG) {
                        LOG.debug("changeTypes = " + changeTypes);
                    }
                    container.getPersistentSearchDecorator().setChangeTypes(changeTypes);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04051, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[PersistentSearchStates.CHANGE_TYPES_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)PersistentSearchStates.CHANGE_TYPES_STATE, (Enum)PersistentSearchStates.CHANGES_ONLY_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<PersistentSearchContainer>("Set PSearchControl changesOnly"){

            public void action(PersistentSearchContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    boolean changesOnly = BooleanDecoder.parse((Value)value);
                    if (IS_DEBUG) {
                        LOG.debug("changesOnly = " + changesOnly);
                    }
                    container.getPersistentSearchDecorator().setChangesOnly(changesOnly);
                }
                catch (BooleanDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04052, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[PersistentSearchStates.CHANGES_ONLY_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)PersistentSearchStates.CHANGES_ONLY_STATE, (Enum)PersistentSearchStates.RETURN_ECS_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<PersistentSearchContainer>("Set PSearchControl returnECs"){

            public void action(PersistentSearchContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    boolean returnECs = BooleanDecoder.parse((Value)value);
                    if (IS_DEBUG) {
                        LOG.debug("returnECs = " + returnECs);
                    }
                    container.getPersistentSearchDecorator().setReturnECs(returnECs);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04053, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

