/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.search.entryChange;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.LongDecoder;
import org.apache.directory.shared.asn1.ber.tlv.LongDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.search.entryChange.EntryChangeContainer;
import org.apache.directory.shared.ldap.codec.controls.search.entryChange.EntryChangeStates;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.controls.ChangeType;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntryChangeGrammar
extends AbstractGrammar<EntryChangeContainer> {
    static final Logger LOG = LoggerFactory.getLogger(EntryChangeGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar<?> instance = new EntryChangeGrammar();

    private EntryChangeGrammar() {
        this.setName(EntryChangeGrammar.class.getName());
        this.transitions = new GrammarTransition[EntryChangeStates.LAST_EC_STATE.ordinal()][256];
        this.transitions[EntryChangeStates.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)EntryChangeStates.START_STATE, (Enum)EntryChangeStates.EC_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[EntryChangeStates.EC_SEQUENCE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)EntryChangeStates.EC_SEQUENCE_STATE, (Enum)EntryChangeStates.CHANGE_TYPE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new GrammarAction<EntryChangeContainer>("Set EntryChangeControl changeType"){

            public void action(EntryChangeContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    int change = IntegerDecoder.parse((Value)value, (int)1, (int)8);
                    switch (ChangeType.getChangeType((int)change)) {
                        case ADD: 
                        case DELETE: 
                        case MODDN: 
                        case MODIFY: {
                            ChangeType changeType = ChangeType.getChangeType((int)change);
                            if (IS_DEBUG) {
                                LOG.debug("changeType = " + changeType);
                            }
                            container.getEntryChangeDecorator().setChangeType(changeType);
                            break;
                        }
                        default: {
                            String msg = I18n.err((I18n)I18n.ERR_04044, (Object[])new Object[0]);
                            LOG.error(msg);
                            throw new DecoderException(msg);
                        }
                    }
                    container.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04044, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
                catch (IllegalArgumentException e) {
                    throw new DecoderException(e.getLocalizedMessage());
                }
            }
        });
        this.transitions[EntryChangeStates.CHANGE_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)EntryChangeStates.CHANGE_TYPE_STATE, (Enum)EntryChangeStates.PREVIOUS_DN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<EntryChangeContainer>("Set EntryChangeControl previousDN"){

            public void action(EntryChangeContainer container) throws DecoderException {
                Dn previousDn;
                ChangeType changeType = container.getEntryChangeDecorator().getChangeType();
                if (changeType != ChangeType.MODDN) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04045, (Object[])new Object[0]));
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04046, (Object[])new Object[0]));
                }
                Value value = container.getCurrentTLV().getValue();
                try {
                    previousDn = new Dn(new String[]{Strings.utf8ToString((byte[])value.getData())});
                }
                catch (LdapInvalidDnException ine) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04047, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())}));
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04048, (Object[])new Object[0]));
                }
                if (IS_DEBUG) {
                    LOG.debug("previousDN = " + previousDn);
                }
                container.getEntryChangeDecorator().setPreviousDn(previousDn);
                container.setGrammarEndAllowed(true);
            }
        });
        GrammarAction<EntryChangeContainer> setChangeNumberAction = new GrammarAction<EntryChangeContainer>("Set EntryChangeControl changeNumber"){

            public void action(EntryChangeContainer container) throws DecoderException {
                Value value = container.getCurrentTLV().getValue();
                try {
                    long changeNumber = LongDecoder.parse((Value)value);
                    if (IS_DEBUG) {
                        LOG.debug("changeNumber = " + changeNumber);
                    }
                    container.getEntryChangeDecorator().setChangeNumber(changeNumber);
                    container.setGrammarEndAllowed(true);
                }
                catch (LongDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04049, (Object[])new Object[0]);
                    LOG.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        };
        this.transitions[EntryChangeStates.PREVIOUS_DN_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)EntryChangeStates.PREVIOUS_DN_STATE, (Enum)EntryChangeStates.CHANGE_NUMBER_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)setChangeNumberAction);
        this.transitions[EntryChangeStates.CHANGE_TYPE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)EntryChangeStates.CHANGE_TYPE_STATE, (Enum)EntryChangeStates.CHANGE_NUMBER_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)setChangeNumberAction);
    }

    public static Grammar<?> getInstance() {
        return instance;
    }
}

