/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchResultDoneImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreSearchRequestBaseObject
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestBaseObject.class);

    public StoreSearchRequestBaseObject() {
        super("Store SearchRequest object Name");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        SearchRequest searchRequest = (SearchRequest)searchRequestDecorator.getDecorated();
        TLV tlv = container.getCurrentTLV();
        Dn baseObject = null;
        if (tlv.getLength() != 0) {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString((byte[])dnBytes);
            try {
                baseObject = new Dn(new String[]{dnStr});
            }
            catch (LdapInvalidDnException ine) {
                String msg = "Invalid root Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                SearchResultDoneImpl response = new SearchResultDoneImpl(searchRequest.getMessageId());
                throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
            }
        } else {
            baseObject = Dn.EMPTY_DN;
        }
        searchRequest.setBase(baseObject);
        LOG.debug("Searching with root Dn : {}", (Object)baseObject);
    }
}

