/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.ldapResult;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.MessageDecorator;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreErrorMessage
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreErrorMessage.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreErrorMessage() {
        super("Store error message");
    }

    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        String errorMessage = null;
        errorMessage = tlv.getLength() == 0 ? "" : Strings.utf8ToString((byte[])tlv.getValue().getData());
        ResultResponse response = (ResultResponse)container.getMessage();
        LdapResult ldapResult = response.getLdapResult();
        ldapResult.setDiagnosticMessage(errorMessage);
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("The error message is : " + errorMessage);
        }
    }
}

