/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.delRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.DeleteRequestDecorator;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.shared.ldap.model.message.DeleteResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitDelRequest
extends GrammarAction<LdapMessageContainer<DeleteRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitDelRequest.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitDelRequest() {
        super("Delete Request initialization");
    }

    public void action(LdapMessageContainer<DeleteRequestDecorator> container) throws DecoderException {
        DeleteRequestImpl internaldelRequest = new DeleteRequestImpl();
        internaldelRequest.setMessageId(container.getMessageId());
        DeleteRequestDecorator delRequest = new DeleteRequestDecorator(container.getLdapCodecService(), (DeleteRequest)internaldelRequest);
        container.setMessage(delRequest);
        TLV tlv = container.getCurrentTLV();
        Dn entry = null;
        if (tlv.getLength() == 0) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04073, (Object[])new Object[0]));
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString((byte[])dnBytes);
        try {
            entry = new Dn(new String[]{dnStr});
        }
        catch (LdapInvalidDnException ine) {
            String msg = I18n.err((I18n)I18n.ERR_04074, (Object[])new Object[]{dnStr, Strings.dumpBytes((byte[])dnBytes), ine.getLocalizedMessage()});
            LOG.error(msg);
            DeleteResponseImpl response = new DeleteResponseImpl(delRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
        }
        delRequest.setName(entry);
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Deleting Dn {}", (Object)entry);
        }
    }
}

