/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.bindRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.BindRequestDecorator;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitBindRequest
extends GrammarAction<LdapMessageContainer<BindRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitBindRequest.class);

    public InitBindRequest() {
        super("Init BindRequest");
    }

    public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
        BindRequestImpl internalBindRequest = new BindRequestImpl();
        internalBindRequest.setMessageId(container.getMessageId());
        BindRequestDecorator bindRequest = new BindRequestDecorator(container.getLdapCodecService(), (BindRequest)internalBindRequest);
        container.setMessage(bindRequest);
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04077, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
    }
}

