/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.addRequest;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.AddRequestDecorator;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddRequestImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitAddRequest
extends GrammarAction<LdapMessageContainer<AddRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAddRequest.class);

    public InitAddRequest() {
        super("Init AddRequest");
    }

    public void action(LdapMessageContainer<AddRequestDecorator> container) throws DecoderException {
        int messageId = container.getMessageId();
        AddRequestImpl internalAddRequest = new AddRequestImpl();
        internalAddRequest.setMessageId(messageId);
        AddRequestDecorator addRequest = new AddRequestDecorator(container.getLdapCodecService(), (AddRequest)internalAddRequest);
        container.setMessage(addRequest);
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_04084, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
    }
}

