/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;

public class LdapJndiProperties {
    private static final String SASL_AUTHID = "java.naming.security.sasl.authorizationId";
    private Dn providerDn;
    private Dn bindDn;
    private String saslAuthId;
    private AuthenticationLevel level;
    private String saslMechanism;
    private byte[] credentials;

    public static AuthenticationLevel getAuthenticationLevel(Hashtable env) throws NamingException {
        AuthenticationLevel level;
        Object credobj = env.get("java.naming.security.credentials");
        Object authentication = env.get("java.naming.security.authentication");
        if (authentication == null) {
            level = credobj == null ? AuthenticationLevel.NONE : AuthenticationLevel.SIMPLE;
        } else {
            if (!(authentication instanceof String)) {
                throw new ConfigurationException(I18n.err((I18n)I18n.ERR_483, (Object[])new Object[]{authentication.getClass(), "java.naming.security.authentication"}));
            }
            level = AuthenticationLevel.NONE.toString().equals(authentication) ? AuthenticationLevel.NONE : (AuthenticationLevel.SIMPLE.toString().equals(authentication) ? AuthenticationLevel.SIMPLE : AuthenticationLevel.STRONG);
        }
        return level;
    }

    public static LdapJndiProperties getLdapJndiProperties(Hashtable env) throws NamingException {
        if (env == null) {
            throw new ConfigurationException("environment cannot be null");
        }
        LdapJndiProperties props = new LdapJndiProperties();
        Object principal = env.get("java.naming.security.principal");
        Object credobj = env.get("java.naming.security.credentials");
        Object authentication = env.get("java.naming.security.authentication");
        if (!env.containsKey("java.naming.provider.url")) {
            String msg = I18n.err((I18n)I18n.ERR_484, (Object[])new Object[]{"java.naming.provider.url"});
            throw new ConfigurationException(msg);
        }
        String url = (String)env.get("java.naming.provider.url");
        if (url == null) {
            String msg = I18n.err((I18n)I18n.ERR_485, (Object[])new Object[]{"java.naming.provider.url"});
            throw new ConfigurationException(msg);
        }
        if (url.trim().equals("")) {
            props.providerDn = Dn.ROOT_DSE;
        } else {
            try {
                props.providerDn = new Dn(new String[]{url});
            }
            catch (LdapInvalidDnException lide) {
                String msg = I18n.err((I18n)I18n.ERR_733, (Object[])new Object[]{url});
                throw new ConfigurationException(msg);
            }
        }
        if (authentication == null) {
            props.level = credobj == null ? AuthenticationLevel.NONE : AuthenticationLevel.SIMPLE;
        } else {
            if (!(authentication instanceof String)) {
                throw new ConfigurationException(I18n.err((I18n)I18n.ERR_483, (Object[])new Object[]{authentication.getClass(), "java.naming.security.authentication"}));
            }
            if (AuthenticationLevel.NONE.toString().equals(authentication)) {
                props.level = AuthenticationLevel.NONE;
            } else if (AuthenticationLevel.SIMPLE.toString().equals(authentication)) {
                props.level = AuthenticationLevel.SIMPLE;
            } else {
                props.level = AuthenticationLevel.STRONG;
                props.saslMechanism = (String)authentication;
            }
        }
        if (principal == null && props.level == AuthenticationLevel.SIMPLE) {
            throw new ConfigurationException(I18n.err((I18n)I18n.ERR_487, (Object[])new Object[]{"java.naming.security.principal"}));
        }
        if (principal == null && props.level == AuthenticationLevel.NONE) {
            props.bindDn = Dn.EMPTY_DN;
        } else {
            if (!(principal instanceof String)) {
                throw new ConfigurationException(I18n.err((I18n)I18n.ERR_483, (Object[])new Object[]{principal.getClass(), "java.naming.security.principal"}));
            }
            if (((String)principal).trim().equals("")) {
                props.bindDn = Dn.EMPTY_DN;
            } else {
                try {
                    props.providerDn = new Dn(new String[]{(String)principal});
                }
                catch (LdapInvalidDnException lide) {
                    String msg = I18n.err((I18n)I18n.ERR_733, (Object[])new Object[]{principal});
                    throw new ConfigurationException(msg);
                }
            }
        }
        if (env.get(SASL_AUTHID) != null && props.level == AuthenticationLevel.STRONG) {
            Object obj = env.get(SASL_AUTHID);
            if (!(obj instanceof String)) {
                throw new ConfigurationException(I18n.err((I18n)I18n.ERR_483, (Object[])new Object[]{obj.getClass(), SASL_AUTHID}));
            }
            props.saslAuthId = (String)obj;
            props.saslAuthId = (String)principal;
        }
        if (props.level == AuthenticationLevel.SIMPLE && credobj == null) {
            throw new ConfigurationException(I18n.err((I18n)I18n.ERR_489, (Object[])new Object[0]));
        }
        if (credobj != null) {
            if (credobj instanceof String) {
                props.credentials = Strings.getBytesUtf8((String)((String)credobj));
            } else if (credobj instanceof byte[]) {
                props.credentials = (byte[])credobj;
            } else {
                throw new ConfigurationException(I18n.err((I18n)I18n.ERR_483, (Object[])new Object[]{credobj.getClass(), "java.naming.security.credentials"}));
            }
        }
        return props;
    }

    public Dn getBindDn() {
        return this.bindDn;
    }

    public Dn getProviderDn() {
        return this.providerDn;
    }

    public String getSaslAuthId() {
        return this.saslAuthId;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.level;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public byte[] getCredentials() {
        return this.credentials;
    }
}

