/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import javax.naming.Binding;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.entry.ServerEntryUtils;
import org.apache.directory.server.core.api.event.DirectoryListener;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerAdapter
implements DirectoryListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventListenerAdapter.class);
    private final NamingListener listener;
    private final ServerLdapContext source;

    public EventListenerAdapter(ServerLdapContext source, NamingListener listener) {
        this(source, listener, new SearchControls());
    }

    public EventListenerAdapter(ServerLdapContext source, NamingListener listener, SearchControls controls) {
        this.source = source;
        this.listener = listener;
    }

    private void deliverNamingExceptionEvent(Exception e) {
        LOG.error(I18n.err((I18n)I18n.ERR_118, (Object[])new Object[0]), (Throwable)e);
        NamingExceptionEvent evt = null;
        if (e instanceof NamingException) {
            evt = new NamingExceptionEvent(this.source, (NamingException)e);
        } else {
            NamingException ne = new NamingException(I18n.err((I18n)I18n.ERR_119, (Object[])new Object[0]));
            ne.setRootCause(e);
            evt = new NamingExceptionEvent(this.source, ne);
        }
        this.listener.namingExceptionThrown(evt);
    }

    public void entryAdded(AddOperationContext addContext) {
        try {
            Binding binding = new Binding(addContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)addContext.getEntry()), false);
            NamingEvent evt = new NamingEvent(this.source, 0, binding, null, addContext);
            if (this.listener instanceof NamespaceChangeListener) {
                ((NamespaceChangeListener)this.listener).objectAdded(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e);
        }
    }

    public void entryDeleted(DeleteOperationContext deleteContext) {
        try {
            if (this.listener instanceof NamespaceChangeListener) {
                Binding binding = new Binding(deleteContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)deleteContext.getEntry()), false);
                NamingEvent evt = new NamingEvent(this.source, 1, null, binding, deleteContext);
                ((NamespaceChangeListener)this.listener).objectAdded(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e);
        }
    }

    public void entryModified(ModifyOperationContext modifyContext) {
        try {
            Binding newBinding = new Binding(modifyContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)modifyContext.getEntry()), false);
            Binding oldBinding = new Binding(modifyContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)((ClonedServerEntry)modifyContext.getEntry()).getOriginalEntry()), false);
            NamingEvent evt = new NamingEvent(this.source, 3, newBinding, oldBinding, modifyContext);
            if (this.listener instanceof ObjectChangeListener) {
                ((ObjectChangeListener)this.listener).objectChanged(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e);
        }
    }

    public void entryMoved(MoveOperationContext moveContext) {
        try {
            if (this.listener instanceof NamespaceChangeListener) {
                Binding newBinding = new Binding(moveContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)moveContext.getEntry()), false);
                Binding oldBinding = new Binding(moveContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)((ClonedServerEntry)moveContext.getEntry()).getOriginalEntry()), false);
                NamingEvent evt = new NamingEvent(this.source, 2, newBinding, oldBinding, moveContext);
                ((NamespaceChangeListener)this.listener).objectRenamed(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e);
        }
    }

    public void entryMovedAndRenamed(MoveAndRenameOperationContext moveAndRenameContext) {
        try {
            if (this.listener instanceof NamespaceChangeListener) {
                Binding newBinding = new Binding(moveAndRenameContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)moveAndRenameContext.getEntry()), false);
                Binding oldBinding = new Binding(moveAndRenameContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)((ClonedServerEntry)moveAndRenameContext.getEntry()).getOriginalEntry()), false);
                NamingEvent evt = new NamingEvent(this.source, 2, newBinding, oldBinding, moveAndRenameContext);
                ((NamespaceChangeListener)this.listener).objectRenamed(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e);
        }
    }

    public void entryRenamed(RenameOperationContext renameContext) {
        try {
            if (this.listener instanceof NamespaceChangeListener) {
                Binding newBinding = new Binding(renameContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)renameContext.getEntry()), false);
                Binding oldBinding = new Binding(renameContext.getDn().getName(), ServerEntryUtils.toBasicAttributes((Entry)((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry()), false);
                NamingEvent evt = new NamingEvent(this.source, 2, newBinding, oldBinding, null);
                ((NamespaceChangeListener)this.listener).objectRenamed(evt);
            }
        }
        catch (Exception e) {
            this.deliverNamingExceptionEvent(e);
        }
    }
}

