/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.apache.commons.io.FileUtils;
import org.apache.directory.ldap.client.api.LdapAsyncConnection;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapCoreSessionConnection;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.ChangeType;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationUtils.class);
    private static final List<LdapConnection> openConnections = new ArrayList<LdapConnection>();

    public static void doDelete(File wkdir) throws IOException {
        if (wkdir.exists()) {
            try {
                FileUtils.deleteDirectory((File)wkdir);
            }
            catch (IOException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_115, (Object[])new Object[0]), (Throwable)e);
            }
        }
        if (wkdir.exists()) {
            throw new IOException(I18n.err((I18n)I18n.ERR_116, (Object[])new Object[]{wkdir}));
        }
    }

    public static void injectEntries(DirectoryService service, String ldif) throws Exception {
        LdifReader reader = new LdifReader();
        List entries = reader.parseLdif(ldif);
        for (LdifEntry entry : entries) {
            if (entry.isEntry()) {
                service.getAdminSession().add((Entry)new DefaultEntry(service.getSchemaManager(), entry.getEntry()));
                continue;
            }
            if (entry.isChangeModify()) {
                service.getAdminSession().modify(entry.getDn(), entry.getModifications());
                continue;
            }
            String message = I18n.err((I18n)I18n.ERR_117, (Object[])new Object[]{entry.getChangeType()});
            LOG.error(message);
            throw new NamingException(message);
        }
        reader.close();
    }

    public static LdifEntry getUserAddLdif() throws LdapException {
        return IntegrationUtils.getUserAddLdif("uid=akarasulu,ou=users,ou=system", "test".getBytes(), "Alex Karasulu", "Karasulu");
    }

    public static LdapContext getContext(String principalDn, DirectoryService service, String dn) throws Exception {
        if (principalDn == null) {
            principalDn = "";
        }
        Dn userDn = new Dn(service.getSchemaManager(), new String[]{principalDn});
        LdapPrincipal principal = new LdapPrincipal(service.getSchemaManager(), userDn, AuthenticationLevel.SIMPLE);
        if (dn == null) {
            dn = "";
        }
        CoreSession session = service.getSession(principal);
        ServerLdapContext ctx = new ServerLdapContext(service, session, (Name)new LdapName(dn));
        return ctx;
    }

    public static CoreSession getCoreSession(String principalDn, DirectoryService service, String dn) throws Exception {
        if (principalDn == null) {
            principalDn = "";
        }
        Dn userDn = new Dn(service.getSchemaManager(), new String[]{principalDn});
        LdapPrincipal principal = new LdapPrincipal(service.getSchemaManager(), userDn, AuthenticationLevel.SIMPLE);
        if (dn == null) {
            dn = "";
        }
        CoreSession session = service.getSession(principal);
        return session;
    }

    public static LdapContext getSystemContext(DirectoryService service) throws Exception {
        return IntegrationUtils.getContext("uid=admin,ou=system", service, "ou=system");
    }

    public static LdapContext getSchemaContext(DirectoryService service) throws Exception {
        return IntegrationUtils.getContext("uid=admin,ou=system", service, "ou=schema");
    }

    public static LdapContext getRootContext(DirectoryService service) throws Exception {
        return IntegrationUtils.getContext("uid=admin,ou=system", service, "");
    }

    public static void apply(DirectoryService service, LdifEntry entry) throws Exception {
        Dn dn = entry.getDn();
        CoreSession session = service.getAdminSession();
        switch (entry.getChangeType().getChangeType()) {
            case 0: {
                session.add((Entry)new DefaultEntry(service.getSchemaManager(), entry.getEntry()));
                break;
            }
            case 4: {
                session.delete(dn);
                break;
            }
            case 2: 
            case 3: {
                Rdn newRdn = new Rdn(entry.getNewRdn());
                if (entry.getNewSuperior() != null) {
                    Rdn oldRdn = dn.getRdn();
                    Dn newSuperior = new Dn(new String[]{entry.getNewSuperior()});
                    if (dn.size() == 0) {
                        throw new IllegalStateException(I18n.err((I18n)I18n.ERR_475, (Object[])new Object[0]));
                    }
                    if (oldRdn.equals((Object)newRdn)) {
                        session.move(dn, newSuperior);
                        break;
                    }
                    session.moveAndRename(dn, newSuperior, newRdn, entry.isDeleteOldRdn());
                    break;
                }
                session.rename(dn, newRdn, entry.isDeleteOldRdn());
                break;
            }
            case 1: {
                session.modify(dn, entry.getModifications());
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_476, (Object[])new Object[]{entry.getChangeType()}));
            }
        }
    }

    public static LdifEntry getUserAddLdif(String dnstr, byte[] password, String cn, String sn) throws LdapException {
        Dn dn = new Dn(new String[]{dnstr});
        LdifEntry ldif = new LdifEntry();
        ldif.setDn(dnstr);
        ldif.setChangeType(ChangeType.Add);
        DefaultAttribute attr = new DefaultAttribute("objectClass", new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"});
        ldif.addAttribute((Attribute)attr);
        attr = new DefaultAttribute("ou", new String[]{"Engineering", "People"});
        ldif.addAttribute((Attribute)attr);
        String uid = dn.getRdn().getNormValue().getString();
        ldif.putAttribute("uid", (Object)uid);
        ldif.putAttribute("l", (Object)"Bogusville");
        ldif.putAttribute("cn", (Object)cn);
        ldif.putAttribute("sn", (Object)sn);
        ldif.putAttribute("mail", (Object)(uid + "@apache.org"));
        ldif.putAttribute("telephoneNumber", (Object)"+1 408 555 4798");
        ldif.putAttribute("facsimileTelephoneNumber", (Object)"+1 408 555 9751");
        ldif.putAttribute("roomnumber", (Object)"4612");
        ldif.putAttribute("userPassword", (Object)password);
        String givenName = cn.split(" ")[0];
        ldif.putAttribute("givenName", (Object)givenName);
        return ldif;
    }

    public static void enableSchema(DirectoryService service, String schemaName) throws Exception {
        LdapConnection connection = IntegrationUtils.getAdminConnection(service);
        connection.modify("cn=" + schemaName + ",ou=schema", new Modification[]{new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "m-disabled", new String[]{"FALSE"})});
    }

    public static void disableSchema(DirectoryService service, String schemaName) throws Exception {
        LdapConnection connection = IntegrationUtils.getAdminConnection(service);
        DefaultModification mod = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "m-disabled", new String[]{"TRUE"});
        connection.modify("cn=" + schemaName + ",ou=schema", new Modification[]{mod});
    }

    public static boolean isDisabled(DirectoryService service, String schemaName) {
        Schema schema = service.getSchemaManager().getLoadedSchema(schemaName);
        return schema == null || schema.isDisabled();
    }

    public static boolean isLoaded(DirectoryService service, String schemaName) {
        Schema schema = service.getSchemaManager().getLoadedSchema(schemaName);
        return schema != null;
    }

    public static boolean isEnabled(DirectoryService service, String schemaName) {
        Schema schema = service.getSchemaManager().getLoadedSchema(schemaName);
        return schema != null && schema.isEnabled();
    }

    public static LdapConnection getAdminConnection(DirectoryService dirService) throws Exception {
        return IntegrationUtils.getConnectionAs(dirService, "uid=admin,ou=system", "secret");
    }

    public static LdapConnection getConnectionAs(DirectoryService dirService, String dn, String password) throws Exception {
        return IntegrationUtils.getConnectionAs(dirService, new Dn(new String[]{dn}), password);
    }

    public static LdapConnection getConnectionAs(DirectoryService dirService, Dn dn, String password) throws Exception {
        LdapConnection connectionObj = LdapConnectionFactory.getCoreSessionConnection();
        LdapCoreSessionConnection coreConnection = (LdapCoreSessionConnection)connectionObj;
        coreConnection.setDirectoryService(dirService);
        coreConnection.bind(dn, password);
        return coreConnection;
    }

    public static LdapConnection getNetworkConnectionAs(String host, int port, String dn, String password) throws Exception {
        LdapAsyncConnection connection = LdapConnectionFactory.getNetworkConnection((String)host, (int)port);
        connection.bind(dn, password);
        openConnections.add((LdapConnection)connection);
        return connection;
    }

    public static LdapConnection getAdminNetworkConnection(LdapServer ldapServer) throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        connection.setTimeOut(0L);
        connection.bind("uid=admin,ou=system", "secret");
        openConnections.add((LdapConnection)connection);
        return connection;
    }

    public static LdapConnection getNetworkConnectionAs(LdapServer ldapServer, String userDn, String password) throws Exception {
        return IntegrationUtils.getNetworkConnectionAs("localhost", ldapServer.getPort(), userDn, password);
    }

    public static void closeConnections() {
        for (LdapConnection con : openConnections) {
            if (con == null) continue;
            try {
                if (!con.isConnected()) continue;
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        openConnections.clear();
    }
}

