/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkSuite
extends Suite {
    private static final Logger LOG = LoggerFactory.getLogger(FrameworkSuite.class);
    private DirectoryService directoryService;
    private CreateLdapServer ldapServerBuilder;
    private LdapServer ldapServer;

    public FrameworkSuite(Class<?> clazz, RunnerBuilder builder) throws InitializationError {
        super(clazz, builder);
    }

    private void startDS(Description description) throws Exception {
        this.directoryService = DSAnnotationProcessor.getDirectoryService((Description)description);
        if (this.directoryService != null) {
            DSAnnotationProcessor.applyLdifs((Description)description, (DirectoryService)this.directoryService);
        }
    }

    private void stopDS() {
        if (this.directoryService != null) {
            try {
                LOG.debug("Shuting down DS for {}", (Object)this.directoryService.getInstanceId());
                this.directoryService.shutdown();
                FileUtils.deleteDirectory((File)this.directoryService.getInstanceLayout().getInstanceDirectory());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startLdapServer(Description description) throws Exception {
        this.ldapServer = ServerAnnotationProcessor.createLdapServer((Description)description, (DirectoryService)this.directoryService);
    }

    private void stopLdapServer() {
        if (this.ldapServer != null && this.ldapServer.isStarted()) {
            this.ldapServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        try {
            DirectoryServiceFactory dsFactory = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
            PartitionFactory partitionFactory = dsFactory.getPartitionFactory();
            LOG.debug("Using partition factory {}", (Object)partitionFactory.getClass().getSimpleName());
            this.startDS(this.getDescription());
            this.startLdapServer(this.getDescription());
            super.run(notifier);
            this.stopLdapServer();
            this.stopDS();
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
        }
        finally {
            this.directoryService = null;
            this.ldapServerBuilder = null;
            this.ldapServer = null;
        }
    }

    protected void runChild(Runner runner, RunNotifier notifier) {
        if (runner instanceof FrameworkRunner) {
            ((FrameworkRunner)runner).setSuite(this);
            super.runChild(runner, notifier);
        } else {
            super.runChild(runner, notifier);
        }
    }

    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public void setDirectoryService(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public CreateLdapServer getLdapServerBuilder() {
        return this.ldapServerBuilder;
    }

    public LdapServer getLdapServer() {
        return this.ldapServer;
    }

    static {
        System.setProperty("default.controls", "org.apache.directory.shared.ldap.codec.controls.cascade.CascadeFactory,org.apache.directory.shared.ldap.codec.controls.manageDsaIT.ManageDsaITFactory,org.apache.directory.shared.ldap.codec.controls.search.entryChange.EntryChangeFactory,org.apache.directory.shared.ldap.codec.controls.search.pagedSearch.PagedResultsFactory,org.apache.directory.shared.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory,org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesFactory");
        System.setProperty("extra.controls", "org.apache.directory.shared.ldap.extras.controls.ppolicy_impl.PasswordPolicyFactory,org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory,org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueFactory,org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory,org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory");
        System.setProperty("default.extendedOperation.requests", "org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel.CancelFactory,org.apache.directory.shared.ldap.extras.extended.ads_impl.certGeneration.CertGenerationFactory,org.apache.directory.shared.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownFactory,org.apache.directory.shared.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureFactory");
        System.setProperty("default.extendedOperation.responses", "org.apache.directory.shared.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectFactory");
    }
}

