/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.integ.FrameworkSuite;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(FrameworkRunner.class);
    private static final String SET_SERVICE_METHOD_NAME = "setService";
    private static final String SET_LDAP_SERVER_METHOD_NAME = "setLdapServer";
    private static final String SET_KDC_SERVER_METHOD_NAME = "setKdcServer";
    private static final String IS_RUN_IN_SUITE_FIELD_NAME = "isRunInSuite";
    private FrameworkSuite suite;
    private DirectoryService classDS;
    private LdapServer classLdapServer;
    private KdcServer classKdcServer;

    public FrameworkRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        CreateLdapServer classLdapServerBuilder = (CreateLdapServer)this.getDescription().getAnnotation(CreateLdapServer.class);
        try {
            DirectoryServiceFactory dsf;
            this.classDS = DSAnnotationProcessor.getDirectoryService((Description)this.getDescription());
            long revision = 0L;
            DirectoryService directoryService = null;
            if (this.classDS != null) {
                directoryService = this.classDS;
                if (this.suite != null) {
                    DSAnnotationProcessor.applyLdifs((Description)this.suite.getDescription(), (DirectoryService)this.classDS);
                }
                DSAnnotationProcessor.applyLdifs((Description)this.getDescription(), (DirectoryService)this.classDS);
            } else if (this.suite != null) {
                directoryService = this.suite.getDirectoryService();
                if (directoryService != null) {
                    revision = this.getCurrentRevision(directoryService);
                    DSAnnotationProcessor.applyLdifs((Description)this.getDescription(), (DirectoryService)directoryService);
                } else {
                    dsf = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
                    directoryService = dsf.getDirectoryService();
                    directoryService.getChangeLog().setEnabled(true);
                    dsf.init("default" + UUID.randomUUID().toString());
                    this.suite.setDirectoryService(directoryService);
                    DSAnnotationProcessor.applyLdifs((Description)this.suite.getDescription(), (DirectoryService)directoryService);
                    revision = this.getCurrentRevision(directoryService);
                    DSAnnotationProcessor.applyLdifs((Description)this.getDescription(), (DirectoryService)directoryService);
                }
            } else {
                dsf = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
                directoryService = dsf.getDirectoryService();
                directoryService.getChangeLog().setEnabled(true);
                dsf.init("default" + UUID.randomUUID().toString());
                this.classDS = directoryService;
                DSAnnotationProcessor.applyLdifs((Description)this.getDescription(), (DirectoryService)directoryService);
            }
            if (classLdapServerBuilder != null) {
                this.classLdapServer = ServerAnnotationProcessor.createLdapServer((Description)this.getDescription(), (DirectoryService)directoryService);
            } else if (this.suite != null && this.suite.getLdapServer() != null) {
                this.classLdapServer = this.suite.getLdapServer();
                if (directoryService == null) {
                    directoryService = this.classLdapServer.getDirectoryService();
                }
            }
            if (this.classKdcServer == null) {
                int minPort = this.getMinPort();
                this.classKdcServer = ServerAnnotationProcessor.getKdcServer((Description)this.getDescription(), (DirectoryService)directoryService, (int)(minPort + 1));
            } else if (this.suite != null) {
                // empty if block
            }
            if (this.suite == null) {
                DirectoryServiceFactory dsFactory = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
                PartitionFactory partitionFactory = dsFactory.getPartitionFactory();
                LOG.debug("Using partition factory {}", (Object)partitionFactory.getClass().getSimpleName());
            }
            super.run(notifier);
            if (this.classLdapServer != null && (this.suite == null || this.suite.getLdapServer() != this.classLdapServer)) {
                this.classLdapServer.stop();
            }
            if (this.classKdcServer != null) {
                this.classKdcServer.stop();
            }
            if (this.classDS != null) {
                LOG.debug("Shuting down DS for {}", (Object)this.classDS.getInstanceId());
                this.classDS.shutdown();
                FileUtils.deleteDirectory((File)this.classDS.getInstanceLayout().getInstanceDirectory());
            } else {
                this.revert(directoryService, revision);
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_181, (Object[])new Object[]{this.getTestClass().getName()}));
            LOG.error(e.getLocalizedMessage());
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
        }
        finally {
            this.suite = null;
            this.classDS = null;
            this.classLdapServer = null;
            this.classKdcServer = null;
        }
    }

    private int getMinPort() {
        LdapServer suiteServer;
        int minPort = 0;
        if (this.suite != null && (suiteServer = this.suite.getLdapServer()) != null) {
            for (Transport transport : suiteServer.getTransports()) {
                if (minPort > transport.getPort()) continue;
                minPort = transport.getPort();
            }
        }
        return minPort;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        LdapServer methodLdapServer = null;
        KdcServer methodKdcServer = null;
        if (method.getAnnotation(Ignore.class) != null) {
            Description description = this.describeChild(method);
            notifier.fireTestIgnored(description);
            return;
        }
        Description suiteDescription = null;
        if (this.suite != null) {
            suiteDescription = this.suite.getDescription();
        }
        Description classDescription = this.getDescription();
        Description methodDescription = this.describeChild(method);
        CreateLdapServer methodLdapServerBuilder = (CreateLdapServer)methodDescription.getAnnotation(CreateLdapServer.class);
        CreateKdcServer methodKdcServerBuilder = (CreateKdcServer)methodDescription.getAnnotation(CreateKdcServer.class);
        try {
            int minPort;
            DirectoryService directoryService = null;
            long revision = 0L;
            DirectoryService methodDS = DSAnnotationProcessor.getDirectoryService((Description)methodDescription);
            if (methodDS != null) {
                DSAnnotationProcessor.applyLdifs((Description)suiteDescription, (DirectoryService)methodDS);
                DSAnnotationProcessor.applyLdifs((Description)classDescription, (DirectoryService)methodDS);
                DSAnnotationProcessor.applyLdifs((Description)methodDescription, (DirectoryService)methodDS);
                directoryService = methodDS;
            } else if (this.classDS != null) {
                directoryService = this.classDS;
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs((Description)methodDescription, (DirectoryService)directoryService);
            } else if (this.classLdapServer != null) {
                directoryService = this.classLdapServer.getDirectoryService();
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs((Description)methodDescription, (DirectoryService)directoryService);
            } else if (this.classKdcServer != null) {
                directoryService = this.classKdcServer.getDirectoryService();
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs((Description)methodDescription, (DirectoryService)directoryService);
            } else if (this.suite != null) {
                directoryService = this.suite.getDirectoryService();
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs((Description)methodDescription, (DirectoryService)directoryService);
            }
            if (methodLdapServerBuilder != null) {
                minPort = this.getMinPort();
                methodLdapServer = ServerAnnotationProcessor.createLdapServer((Description)methodDescription, (DirectoryService)directoryService);
            }
            if (methodKdcServerBuilder != null) {
                minPort = this.getMinPort();
                methodKdcServer = ServerAnnotationProcessor.getKdcServer((Description)methodDescription, (DirectoryService)directoryService, (int)(minPort + 1));
            }
            Method setService = this.getTestClass().getJavaClass().getMethod(SET_SERVICE_METHOD_NAME, DirectoryService.class);
            setService.invoke((Object)this.getTestClass().getJavaClass(), directoryService);
            Field runInSuiteField = this.getTestClass().getJavaClass().getField(IS_RUN_IN_SUITE_FIELD_NAME);
            runInSuiteField.set(this.getTestClass().getJavaClass(), this.suite != null);
            Method setLdapServer = this.getTestClass().getJavaClass().getMethod(SET_LDAP_SERVER_METHOD_NAME, LdapServer.class);
            Method setKdcServer = this.getTestClass().getJavaClass().getMethod(SET_KDC_SERVER_METHOD_NAME, KdcServer.class);
            DirectoryService oldLdapServerDirService = null;
            DirectoryService oldKdcServerDirService = null;
            if (methodLdapServer != null) {
                methodLdapServer.setDirectoryService(directoryService);
                setLdapServer.invoke((Object)this.getTestClass().getJavaClass(), methodLdapServer);
            } else if (this.classLdapServer != null) {
                oldLdapServerDirService = this.classLdapServer.getDirectoryService();
                this.classLdapServer.setDirectoryService(directoryService);
                setLdapServer.invoke((Object)this.getTestClass().getJavaClass(), this.classLdapServer);
            }
            if (methodKdcServer != null) {
                methodKdcServer.setDirectoryService(directoryService);
                setKdcServer.invoke((Object)this.getTestClass().getJavaClass(), methodKdcServer);
            } else if (this.classKdcServer != null) {
                oldKdcServerDirService = this.classKdcServer.getDirectoryService();
                this.classKdcServer.setDirectoryService(directoryService);
                setKdcServer.invoke((Object)this.getTestClass().getJavaClass(), this.classKdcServer);
            }
            super.runChild(method, notifier);
            if (methodLdapServer != null) {
                methodLdapServer.stop();
            }
            if (oldLdapServerDirService != null) {
                this.classLdapServer.setDirectoryService(oldLdapServerDirService);
            }
            if (oldKdcServerDirService != null) {
                this.classKdcServer.setDirectoryService(oldKdcServerDirService);
            }
            if (methodDS != null) {
                LOG.debug("Shuting down DS for {}", (Object)methodDS.getInstanceId());
                methodDS.shutdown();
                FileUtils.deleteDirectory((File)methodDS.getInstanceLayout().getInstanceDirectory());
            } else {
                this.revert(directoryService, revision);
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_182, (Object[])new Object[]{method.getName()}));
            LOG.error("", (Throwable)e);
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
        }
    }

    public void setSuite(FrameworkSuite suite) {
        this.suite = suite;
    }

    public FrameworkSuite getSuite() {
        return this.suite;
    }

    private long getCurrentRevision(DirectoryService dirService) throws Exception {
        if (dirService != null && dirService.getChangeLog().isEnabled()) {
            long revision = dirService.getChangeLog().getCurrentRevision();
            LOG.debug("Create revision {}", (Object)revision);
            return revision;
        }
        return 0L;
    }

    private void revert(DirectoryService dirService, long revision) throws Exception {
        if (dirService == null) {
            return;
        }
        ChangeLog cl = dirService.getChangeLog();
        if (cl.isEnabled() && revision < cl.getCurrentRevision()) {
            LOG.debug("Revert revision {}", (Object)revision);
            dirService.revert(revision);
        }
    }

    static {
        System.setProperty("default.controls", "org.apache.directory.shared.ldap.codec.controls.cascade.CascadeFactory,org.apache.directory.shared.ldap.codec.controls.manageDsaIT.ManageDsaITFactory,org.apache.directory.shared.ldap.codec.controls.search.entryChange.EntryChangeFactory,org.apache.directory.shared.ldap.codec.controls.search.pagedSearch.PagedResultsFactory,org.apache.directory.shared.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory,org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesFactory");
        System.setProperty("extra.controls", "org.apache.directory.shared.ldap.extras.controls.ppolicy_impl.PasswordPolicyFactory,org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory,org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueFactory,org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory,org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory");
        System.setProperty("default.extendedOperation.requests", "org.apache.directory.shared.ldap.extras.extended.ads_impl.cancel.CancelFactory,org.apache.directory.shared.ldap.extras.extended.ads_impl.certGeneration.CertGenerationFactory,org.apache.directory.shared.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownFactory,org.apache.directory.shared.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureFactory");
        System.setProperty("default.extendedOperation.responses", "org.apache.directory.shared.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectFactory");
    }
}

