/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.binary.Base64;

public final class RssUtils {
    private RssUtils() {
    }

    public static SyndFeed createFeed(String feedUri) throws Exception {
        return RssUtils.createFeed(feedUri, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyndFeed createFeed(String feedUri, ClassLoader classLoader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            InputStream in = new URL(feedUri).openStream();
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader(in));
            return syndFeed;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public static SyndFeed createFeed(String feedUri, String username, String password) throws Exception {
        return RssUtils.createFeed(feedUri, username, password, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyndFeed createFeed(String feedUri, String username, String password, ClassLoader classLoader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            URL feedUrl = new URL(feedUri);
            HttpURLConnection httpcon = (HttpURLConnection)feedUrl.openConnection();
            String encoding = Base64.encodeBase64String((byte[])username.concat(":").concat(password).getBytes());
            httpcon.setRequestProperty("Authorization", "Basic " + encoding);
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader((URLConnection)httpcon));
            return syndFeed;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

