/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ObjectHelper;

public final class UnitOfWorkProcessor
extends DelegateAsyncProcessor {
    public UnitOfWorkProcessor(AsyncProcessor processor) {
        super(processor);
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (exchange.getUnitOfWork() == null) {
            final DefaultUnitOfWork uow = new DefaultUnitOfWork();
            exchange.setUnitOfWork(uow);
            try {
                uow.start();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            return this.processor.process(exchange, new AsyncCallback(){

                public void done(boolean sync) {
                    callback.done(sync);
                    exchange.getUnitOfWork().done(exchange);
                    try {
                        uow.stop();
                    }
                    catch (Exception e) {
                        throw ObjectHelper.wrapRuntimeCamelException(e);
                    }
                    exchange.setUnitOfWork(null);
                }
            });
        }
        return this.processor.process(exchange, callback);
    }
}

