/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.resequencer.ResequencerEngine;
import org.apache.camel.processor.resequencer.SequenceElementComparator;
import org.apache.camel.processor.resequencer.SequenceSender;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamResequencer
extends ServiceSupport
implements SequenceSender<Exchange>,
Runnable,
Processor {
    private ExceptionHandler exceptionHandler = new LoggingExceptionHandler(this.getClass());
    private ResequencerEngine<Exchange> engine;
    private PollingConsumer<? extends Exchange> consumer;
    private Endpoint<? extends Exchange> endpoint;
    private Processor processor;
    private Thread worker;
    private int capacity;

    public StreamResequencer(Endpoint<? extends Exchange> endpoint, Processor processor, SequenceElementComparator<Exchange> comparator) {
        this.engine = new ResequencerEngine<Exchange>(comparator);
        this.engine.setSequenceSender(this);
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getTimeout() {
        return this.engine.getTimeout();
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public void setTimeout(long timeout) {
        this.engine.setTimeout(timeout);
    }

    public String toString() {
        return "StreamResequencer[to: " + this.processor + "]";
    }

    @Override
    protected void doStart() throws Exception {
        this.consumer = this.endpoint.createPollingConsumer();
        ServiceHelper.startServices(this.processor, this.consumer);
        this.worker = new Thread((Runnable)this, this + " Polling Thread");
        this.engine.start();
        this.worker.start();
    }

    @Override
    protected void doStop() throws Exception {
        this.engine.stop();
        ServiceHelper.stopServices(this.consumer, this.processor);
    }

    @Override
    public void sendElement(Exchange o) throws Exception {
        this.processor.process(o);
    }

    @Override
    public void run() {
        while (!this.isStopped() && !this.isStopping()) {
            try {
                this.processExchange();
            }
            catch (Exception e) {
                this.exceptionHandler.handleException(e);
            }
        }
    }

    protected void processExchange() throws Exception {
        if (this.engine.size() >= this.capacity) {
            Thread.sleep(this.getTimeout());
        } else {
            Exchange exchange = this.consumer.receive(this.getTimeout());
            if (exchange != null) {
                this.engine.insert(exchange);
            }
        }
        this.engine.deliver();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
    }
}

