/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.spi.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleLanguage
implements Language {
    @Override
    public Predicate<Exchange> createPredicate(String expression) {
        return PredicateBuilder.toPredicate(this.createExpression(expression));
    }

    @Override
    public Expression<Exchange> createExpression(String expression) {
        if (expression.indexOf("${") >= 0) {
            return this.createComplexExpression(expression);
        }
        return this.createSimpleExpression(expression);
    }

    protected Expression<Exchange> createComplexExpression(String expression) {
        ArrayList<Expression> results = new ArrayList<Expression>();
        int pivot = 0;
        int size = expression.length();
        while (pivot < size) {
            int endIdx;
            int idx = expression.indexOf("${", pivot);
            if (idx < 0) {
                results.add(this.createConstantExpression(expression, pivot, size));
                break;
            }
            if (pivot < idx) {
                results.add(this.createConstantExpression(expression, pivot, idx));
            }
            if ((endIdx = expression.indexOf("}", pivot = idx + 2)) < 0) {
                throw new IllegalArgumentException("Expecting } but found end of string for simple expression: " + expression);
            }
            String simpleText = expression.substring(pivot, endIdx);
            Expression<Exchange> simpleExpression = this.createSimpleExpression(simpleText);
            results.add(simpleExpression);
            pivot = endIdx + 1;
        }
        return ExpressionBuilder.concatExpression(results, expression);
    }

    protected Expression createConstantExpression(String expression, int start, int end) {
        return ExpressionBuilder.constantExpression(expression.substring(start, end));
    }

    protected abstract <E extends Exchange> Expression<Exchange> createSimpleExpression(String var1);

    protected String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }
}

