/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.UuidGenerator;

public class DefaultUnitOfWork
implements UnitOfWork,
Service {
    private static final UuidGenerator DEFAULT_ID_GENERATOR = new UuidGenerator();
    private String id;
    private List<Synchronization> synchronizations;
    private List<AsyncCallback> asyncCallbacks;
    private CountDownLatch latch;

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        if (this.asyncCallbacks != null) {
            this.asyncCallbacks.clear();
        }
    }

    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>();
        }
        this.synchronizations.add(synchronization);
    }

    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    public void reset() {
    }

    public void done(Exchange exchange) {
        if (this.synchronizations != null) {
            boolean failed = exchange.isFailed();
            for (Synchronization synchronization : this.synchronizations) {
                if (failed) {
                    synchronization.onFailure(exchange);
                    continue;
                }
                synchronization.onComplete(exchange);
            }
        }
    }

    public boolean isSynchronous() {
        return this.asyncCallbacks == null || this.asyncCallbacks.isEmpty();
    }

    public String getId() {
        if (this.id == null) {
            this.id = DEFAULT_ID_GENERATOR.generateId();
        }
        return this.id;
    }
}

