/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.local;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.local.LocalTransportReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalTransportSender
extends AbstractHandler
implements TransportSender {
    protected static final Log log = LogFactory.getLog(LocalTransportSender.class);

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        msgContext.setDoingMTOM(TransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(TransportUtils.doWriteSwA(msgContext));
        EndpointReference epr = msgContext.getTo();
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            TransportUtils.writeMessage(msgContext, os);
            log.debug((Object)("Sending - " + new String(os.toByteArray())));
        }
        if (epr != null) {
            if (!epr.hasNoneAddress()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                TransportUtils.writeMessage(msgContext, out);
                this.finalizeSendWithToAddress(msgContext, out);
            }
        } else {
            OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
            if (out != null) {
                TransportUtils.writeMessage(msgContext, out);
            } else {
                throw new AxisFault("Both the TO and Property MessageContext.TRANSPORT_OUT is Null, No where to send");
            }
        }
        TransportUtils.setResponseWritten(msgContext, true);
        return Handler.InvocationResponse.CONTINUE;
    }

    public void finalizeSendWithToAddress(MessageContext msgContext, ByteArrayOutputStream out) throws AxisFault {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            ByteArrayOutputStream response = new ByteArrayOutputStream();
            LocalTransportReceiver localTransportReceiver = new LocalTransportReceiver(this);
            localTransportReceiver.processMessage(in, msgContext.getTo(), msgContext.getOptions().getAction(), response);
            ((InputStream)in).close();
            out.close();
            in = new ByteArrayInputStream(response.toByteArray());
            msgContext.setProperty("TRANSPORT_IN", in);
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
    }
}

