/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.kahadb.JournalCommand;
import org.apache.activemq.store.kahadb.Visitor;
import org.apache.activemq.store.kahadb.data.KahaAddMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaCommitCommand;
import org.apache.activemq.store.kahadb.data.KahaDestination;
import org.apache.activemq.store.kahadb.data.KahaEntryType;
import org.apache.activemq.store.kahadb.data.KahaLocalTransactionId;
import org.apache.activemq.store.kahadb.data.KahaPrepareCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveDestinationCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaRollbackCommand;
import org.apache.activemq.store.kahadb.data.KahaSubscriptionCommand;
import org.apache.activemq.store.kahadb.data.KahaTraceCommand;
import org.apache.activemq.store.kahadb.data.KahaTransactionInfo;
import org.apache.activemq.store.kahadb.data.KahaXATransactionId;
import org.apache.activemq.util.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kahadb.index.BTreeIndex;
import org.apache.kahadb.index.BTreeVisitor;
import org.apache.kahadb.journal.DataFile;
import org.apache.kahadb.journal.Journal;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.page.Page;
import org.apache.kahadb.page.PageFile;
import org.apache.kahadb.page.Transaction;
import org.apache.kahadb.util.ByteSequence;
import org.apache.kahadb.util.DataByteArrayInputStream;
import org.apache.kahadb.util.DataByteArrayOutputStream;
import org.apache.kahadb.util.LockFile;
import org.apache.kahadb.util.LongMarshaller;
import org.apache.kahadb.util.Marshaller;
import org.apache.kahadb.util.Sequence;
import org.apache.kahadb.util.SequenceSet;
import org.apache.kahadb.util.StringMarshaller;
import org.apache.kahadb.util.VariableMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDatabase {
    public static final String PROPERTY_LOG_SLOW_ACCESS_TIME = "org.apache.activemq.store.kahadb.LOG_SLOW_ACCESS_TIME";
    public static final int LOG_SLOW_ACCESS_TIME = Integer.parseInt(System.getProperty("org.apache.activemq.store.kahadb.LOG_SLOW_ACCESS_TIME", "500"));
    private static final Log LOG = LogFactory.getLog(MessageDatabase.class);
    private static final int DATABASE_LOCKED_WAIT_DELAY = 10000;
    public static final int CLOSED_STATE = 1;
    public static final int OPEN_STATE = 2;
    protected PageFile pageFile;
    protected Journal journal;
    protected Metadata metadata = new Metadata();
    protected MetadataMarshaller metadataMarshaller = new MetadataMarshaller();
    protected boolean failIfDatabaseIsLocked;
    protected boolean deleteAllMessages;
    protected File directory;
    protected Thread checkpointThread;
    protected boolean enableJournalDiskSyncs = true;
    long checkpointInterval = 5000L;
    long cleanupInterval = 30000L;
    int journalMaxFileLength = 0x2000000;
    int journalMaxWriteBatchSize = 0x400000;
    boolean enableIndexWriteAsync = false;
    int setIndexWriteBatchSize = PageFile.DEFAULT_WRITE_BATCH_SIZE;
    protected AtomicBoolean started = new AtomicBoolean();
    protected AtomicBoolean opened = new AtomicBoolean();
    private LockFile lockFile;
    private boolean ignoreMissingJournalfiles = false;
    private int indexCacheSize = 100;
    private boolean checkForCorruptJournalFiles = false;
    private boolean checksumJournalFiles = false;
    private Location nextRecoveryPosition;
    private Location lastRecoveryPosition;
    protected final Object indexMutex = new Object();
    private final HashSet<Integer> journalFilesBeingReplicated = new HashSet();
    private final HashMap<String, StoredDestination> storedDestinations = new HashMap();
    protected final LinkedHashMap<TransactionId, ArrayList<Operation>> inflightTransactions = new LinkedHashMap();
    protected final LinkedHashMap<TransactionId, ArrayList<Operation>> preparedTransactions = new LinkedHashMap();

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.load();
        }
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            this.unload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPageFile() throws IOException {
        Object object = this.indexMutex;
        synchronized (object) {
            final PageFile pageFile = this.getPageFile();
            pageFile.load();
            pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    if (pageFile.getPageCount() == 0L) {
                        Page page = tx.allocate();
                        assert (page.getPageId() == 0L);
                        page.set((Object)MessageDatabase.this.metadata);
                        MessageDatabase.this.metadata.page = page;
                        MessageDatabase.this.metadata.state = 1;
                        MessageDatabase.this.metadata.destinations = new BTreeIndex(pageFile, tx.allocate().getPageId());
                        tx.store(MessageDatabase.this.metadata.page, (Marshaller)MessageDatabase.this.metadataMarshaller, true);
                    } else {
                        Page page = tx.load(0L, (Marshaller)MessageDatabase.this.metadataMarshaller);
                        MessageDatabase.this.metadata = (Metadata)page.get();
                        MessageDatabase.this.metadata.page = page;
                    }
                    MessageDatabase.this.metadata.destinations.setKeyMarshaller((Marshaller)StringMarshaller.INSTANCE);
                    MessageDatabase.this.metadata.destinations.setValueMarshaller((Marshaller)new StoredDestinationMarshaller());
                    MessageDatabase.this.metadata.destinations.load(tx);
                }
            });
            pageFile.flush();
            this.storedDestinations.clear();
            pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    Iterator iterator = MessageDatabase.this.metadata.destinations.iterator(tx);
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        StoredDestination sd = MessageDatabase.this.loadStoredDestination(tx, (String)entry.getKey(), ((StoredDestination)entry.getValue()).subscriptions != null);
                        MessageDatabase.this.storedDestinations.put(entry.getKey(), sd);
                    }
                }
            });
        }
    }

    public void open() throws IOException {
        if (this.opened.compareAndSet(false, true)) {
            this.getJournal().start();
            this.loadPageFile();
            this.checkpointThread = new Thread("ActiveMQ Journal Checkpoint Worker"){

                public void run() {
                    try {
                        long lastCleanup = System.currentTimeMillis();
                        long lastCheckpoint = System.currentTimeMillis();
                        long sleepTime = Math.min(MessageDatabase.this.checkpointInterval, 500L);
                        while (MessageDatabase.this.opened.get()) {
                            Thread.sleep(sleepTime);
                            long now = System.currentTimeMillis();
                            if (now - lastCleanup >= MessageDatabase.this.cleanupInterval) {
                                MessageDatabase.this.checkpointCleanup(true);
                                lastCleanup = now;
                                lastCheckpoint = now;
                                continue;
                            }
                            if (now - lastCheckpoint < MessageDatabase.this.checkpointInterval) continue;
                            MessageDatabase.this.checkpointCleanup(false);
                            lastCheckpoint = now;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            this.checkpointThread.setDaemon(true);
            this.checkpointThread.start();
            this.recover();
        }
    }

    private void lock() throws IOException {
        if (this.lockFile == null) {
            File lockFileName = new File(this.directory, "lock");
            this.lockFile = new LockFile(lockFileName, true);
            if (this.failIfDatabaseIsLocked) {
                this.lockFile.lock();
            } else {
                while (true) {
                    try {
                        this.lockFile.lock();
                    }
                    catch (IOException e) {
                        LOG.info((Object)("Database " + lockFileName + " is locked... waiting " + 10 + " seconds for the database to be unlocked. Reason: " + e));
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        Object object = this.indexMutex;
        synchronized (object) {
            this.lock();
            if (this.deleteAllMessages) {
                this.getJournal().start();
                this.getJournal().delete();
                this.getJournal().close();
                this.journal = null;
                this.getPageFile().delete();
                LOG.info((Object)"Persistence store purged.");
                this.deleteAllMessages = false;
            }
            this.open();
            this.store((JournalCommand)new KahaTraceCommand().setMessage("LOADED " + new Date()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, InterruptedException {
        if (this.opened.compareAndSet(true, false)) {
            Object object = this.indexMutex;
            synchronized (object) {
                this.pageFile.unload();
                this.metadata = new Metadata();
            }
            this.journal.close();
            this.checkpointThread.join();
            this.lockFile.unlock();
            this.lockFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() throws IOException, InterruptedException {
        Object object = this.indexMutex;
        synchronized (object) {
            if (this.pageFile != null && this.pageFile.isLoaded()) {
                this.metadata.state = 1;
                this.metadata.firstInProgressTransactionLocation = this.getFirstInProgressTxLocation();
                this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                    public void execute(Transaction tx) throws IOException {
                        tx.store(MessageDatabase.this.metadata.page, (Marshaller)MessageDatabase.this.metadataMarshaller, true);
                    }
                });
            }
        }
        this.close();
    }

    private Location getFirstInProgressTxLocation() {
        Location l = null;
        if (!this.inflightTransactions.isEmpty()) {
            l = this.inflightTransactions.values().iterator().next().get(0).getLocation();
        }
        if (!this.preparedTransactions.isEmpty()) {
            Location t = this.preparedTransactions.values().iterator().next().get(0).getLocation();
            if (l == null || t.compareTo(l) <= 0) {
                l = t;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() throws IllegalStateException, IOException {
        Object object = this.indexMutex;
        synchronized (object) {
            long start = System.currentTimeMillis();
            Location recoveryPosition = this.getRecoveryPosition();
            if (recoveryPosition != null) {
                int redoCounter = 0;
                while (recoveryPosition != null) {
                    JournalCommand message = this.load(recoveryPosition);
                    this.metadata.lastUpdate = recoveryPosition;
                    this.process(message, recoveryPosition);
                    ++redoCounter;
                    recoveryPosition = this.journal.getNextLocation(recoveryPosition);
                }
                long end = System.currentTimeMillis();
                LOG.info((Object)("Replayed " + redoCounter + " operations from the journal in " + (float)(end - start) / 1000.0f + " seconds."));
            }
            this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.recoverIndex(tx);
                }
            });
        }
    }

    protected void recoverIndex(Transaction tx) throws IOException {
        long start = System.currentTimeMillis();
        Location lastAppendLocation = this.journal.getLastAppendLocation();
        long undoCounter = 0L;
        for (StoredDestination sd : this.storedDestinations.values()) {
            final ArrayList matches = new ArrayList();
            sd.locationIndex.visit(tx, (BTreeVisitor)new BTreeVisitor.GTEVisitor<Location, Long>(lastAppendLocation){

                protected void matched(Location key, Long value) {
                    matches.add(value);
                }
            });
            for (Long sequenceId : matches) {
                MessageKeys keys = (MessageKeys)sd.orderIndex.remove(tx, (Object)sequenceId);
                sd.locationIndex.remove(tx, (Object)keys.location);
                sd.messageIdIndex.remove(tx, (Object)keys.messageId);
                ++undoCounter;
            }
        }
        long end = System.currentTimeMillis();
        if (undoCounter > 0L) {
            LOG.info((Object)("Rolled back " + undoCounter + " messages from the index in " + (float)(end - start) / 1000.0f + " seconds."));
        }
        undoCounter = 0L;
        start = System.currentTimeMillis();
        final SequenceSet ss = new SequenceSet();
        for (StoredDestination sd : this.storedDestinations.values()) {
            sd.locationIndex.visit(tx, (BTreeVisitor)new BTreeVisitor<Location, Long>(){
                int last = -1;

                public boolean isInterestedInKeysBetween(Location first, Location second) {
                    if (first == null) {
                        return !ss.contains(0, second.getDataFileId());
                    }
                    if (second == null) {
                        return true;
                    }
                    return !ss.contains(first.getDataFileId(), second.getDataFileId());
                }

                public void visit(List<Location> keys, List<Long> values) {
                    for (Location l : keys) {
                        int fileId = l.getDataFileId();
                        if (this.last == fileId) continue;
                        ss.add((long)fileId);
                        this.last = fileId;
                    }
                }
            });
        }
        HashSet<Integer> missingJournalFiles = new HashSet<Integer>();
        while (!ss.isEmpty()) {
            missingJournalFiles.add((int)ss.removeFirst());
        }
        missingJournalFiles.removeAll(this.journal.getFileMap().keySet());
        if (!missingJournalFiles.isEmpty()) {
            LOG.info((Object)("Some journal files are missing: " + missingJournalFiles));
        }
        ArrayList<BTreeVisitor.BetweenVisitor> missingPredicates = new ArrayList<BTreeVisitor.BetweenVisitor>();
        for (Integer missing : missingJournalFiles) {
            missingPredicates.add(new BTreeVisitor.BetweenVisitor((Comparable)new Location(missing.intValue(), 0), (Comparable)new Location(missing + 1, 0)));
        }
        if (this.checkForCorruptJournalFiles) {
            Collection dataFiles = this.journal.getFileMap().values();
            for (DataFile dataFile : dataFiles) {
                int id = dataFile.getDataFileId();
                missingPredicates.add(new BTreeVisitor.BetweenVisitor((Comparable)new Location(id, dataFile.getLength()), (Comparable)new Location(id + 1, 0)));
                for (Sequence seq = (Sequence)dataFile.getCorruptedBlocks().getHead(); seq != null; seq = (Sequence)seq.getNext()) {
                    missingPredicates.add(new BTreeVisitor.BetweenVisitor((Comparable)new Location(id, (int)seq.getFirst()), (Comparable)new Location(id, (int)seq.getLast() + 1)));
                }
            }
        }
        if (!missingPredicates.isEmpty()) {
            for (StoredDestination sd : this.storedDestinations.values()) {
                final ArrayList matches = new ArrayList();
                sd.locationIndex.visit(tx, (BTreeVisitor)new BTreeVisitor.OrVisitor<Location, Long>(missingPredicates){

                    protected void matched(Location key, Long value) {
                        matches.add(value);
                    }
                });
                if (matches.isEmpty()) continue;
                if (this.ignoreMissingJournalfiles) {
                    for (Long sequenceId : matches) {
                        MessageKeys keys = (MessageKeys)sd.orderIndex.remove(tx, (Object)sequenceId);
                        sd.locationIndex.remove(tx, (Object)keys.location);
                        sd.messageIdIndex.remove(tx, (Object)keys.messageId);
                        ++undoCounter;
                    }
                    continue;
                }
                throw new IOException("Detected missing/corrupt journal files. " + matches.size() + " messages affected.");
            }
        }
        end = System.currentTimeMillis();
        if (undoCounter > 0L) {
            LOG.info((Object)("Detected missing/corrupt journal files.  Dropped " + undoCounter + " messages from the index in " + (float)(end - start) / 1000.0f + " seconds."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementalRecover() throws IOException {
        Object object = this.indexMutex;
        synchronized (object) {
            if (this.nextRecoveryPosition == null) {
                this.nextRecoveryPosition = this.lastRecoveryPosition == null ? this.getRecoveryPosition() : this.journal.getNextLocation(this.lastRecoveryPosition);
            }
            while (this.nextRecoveryPosition != null) {
                this.metadata.lastUpdate = this.lastRecoveryPosition = this.nextRecoveryPosition;
                JournalCommand message = this.load(this.lastRecoveryPosition);
                this.process(message, this.lastRecoveryPosition);
                this.nextRecoveryPosition = this.journal.getNextLocation(this.lastRecoveryPosition);
            }
        }
    }

    public Location getLastUpdatePosition() throws IOException {
        return this.metadata.lastUpdate;
    }

    private Location getRecoveryPosition() throws IOException {
        if (this.metadata.firstInProgressTransactionLocation != null) {
            return this.metadata.firstInProgressTransactionLocation;
        }
        if (this.metadata.lastUpdate != null) {
            return this.journal.getNextLocation(this.metadata.lastUpdate);
        }
        return this.journal.getNextLocation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkpointCleanup(final boolean cleanup) {
        try {
            long start = System.currentTimeMillis();
            Object object = this.indexMutex;
            synchronized (object) {
                if (!this.opened.get()) {
                    return;
                }
                this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.this.checkpointUpdate(tx, cleanup);
                    }
                });
            }
            long end = System.currentTimeMillis();
            if (LOG_SLOW_ACCESS_TIME > 0 && end - start > (long)LOG_SLOW_ACCESS_TIME) {
                LOG.info((Object)("Slow KahaDB access: cleanup took " + (end - start)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(Callback closure) throws Exception {
        Object object = this.indexMutex;
        synchronized (object) {
            this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.checkpointUpdate(tx, false);
                }
            });
            closure.execute();
        }
    }

    public Location store(JournalCommand data) throws IOException {
        return this.store(data, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location store(JournalCommand data, boolean sync) throws IOException {
        int size = data.serializedSizeFramed();
        DataByteArrayOutputStream os = new DataByteArrayOutputStream(size + 1);
        os.writeByte(data.type().getNumber());
        data.writeFramed((OutputStream)os);
        long start = System.currentTimeMillis();
        Location location = this.journal.write(os.toByteSequence(), sync);
        long start2 = System.currentTimeMillis();
        this.process(data, location);
        long end = System.currentTimeMillis();
        if (LOG_SLOW_ACCESS_TIME > 0 && end - start > (long)LOG_SLOW_ACCESS_TIME) {
            LOG.info((Object)("Slow KahaDB access: Journal append took: " + (start2 - start) + " ms, Index update took " + (end - start2) + " ms"));
        }
        Object object = this.indexMutex;
        synchronized (object) {
            this.metadata.lastUpdate = location;
        }
        return location;
    }

    public JournalCommand load(Location location) throws IOException {
        ByteSequence data = this.journal.read(location);
        DataByteArrayInputStream is = new DataByteArrayInputStream(data);
        byte readByte = is.readByte();
        KahaEntryType type = KahaEntryType.valueOf(readByte);
        if (type == null) {
            throw new IOException("Could not load journal record. Invalid location: " + location);
        }
        JournalCommand message = (JournalCommand)type.createMessage();
        message.mergeFramed((InputStream)is);
        return message;
    }

    private void process(JournalCommand data, final Location location) throws IOException {
        data.visit(new Visitor(){

            public void visit(KahaAddMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaRemoveMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaPrepareCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaCommitCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaRollbackCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaRemoveDestinationCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            public void visit(KahaSubscriptionCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(final KahaAddMessageCommand command, final Location location) throws IOException {
        if (command.hasTransactionInfo()) {
            Object object = this.indexMutex;
            synchronized (object) {
                ArrayList<Operation> inflightTx = this.getInflightTx(command.getTransactionInfo(), location);
                inflightTx.add(new AddOpperation(command, location));
            }
        }
        Object object = this.indexMutex;
        synchronized (object) {
            this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.upadateIndex(tx, command, location);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaRemoveMessageCommand command, final Location location) throws IOException {
        if (command.hasTransactionInfo()) {
            Object object = this.indexMutex;
            synchronized (object) {
                ArrayList<Operation> inflightTx = this.getInflightTx(command.getTransactionInfo(), location);
                inflightTx.add(new RemoveOpperation(command, location));
            }
        }
        Object object = this.indexMutex;
        synchronized (object) {
            this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaRemoveDestinationCommand command, final Location location) throws IOException {
        Object object = this.indexMutex;
        synchronized (object) {
            this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaSubscriptionCommand command, final Location location) throws IOException {
        Object object = this.indexMutex;
        synchronized (object) {
            this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaCommitCommand command, Location location) throws IOException {
        TransactionId key = this.key(command.getTransactionInfo());
        Object object = this.indexMutex;
        synchronized (object) {
            ArrayList inflightTx = (ArrayList)this.inflightTransactions.remove(key);
            if (inflightTx == null) {
                inflightTx = (ArrayList)this.preparedTransactions.remove(key);
            }
            if (inflightTx == null) {
                return;
            }
            final ArrayList messagingTx = inflightTx;
            this.pageFile.tx().execute((Transaction.Closure)new Transaction.Closure<IOException>(){

                public void execute(Transaction tx) throws IOException {
                    for (Operation op : messagingTx) {
                        op.execute(tx);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaPrepareCommand command, Location location) {
        Object object = this.indexMutex;
        synchronized (object) {
            TransactionId key = this.key(command.getTransactionInfo());
            ArrayList tx = (ArrayList)this.inflightTransactions.remove(key);
            if (tx != null) {
                this.preparedTransactions.put(key, tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaRollbackCommand command, Location location) {
        Object object = this.indexMutex;
        synchronized (object) {
            TransactionId key = this.key(command.getTransactionInfo());
            ArrayList tx = (ArrayList)this.inflightTransactions.remove(key);
            if (tx == null) {
                this.preparedTransactions.remove(key);
            }
        }
    }

    private void upadateIndex(Transaction tx, KahaAddMessageCommand command, Location location) throws IOException {
        long id;
        Long previous;
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (sd.subscriptions != null && sd.ackPositions.isEmpty()) {
            return;
        }
        if ((previous = (Long)sd.locationIndex.put(tx, (Object)location, (Object)(id = sd.nextMessageId++))) == null) {
            previous = (Long)sd.messageIdIndex.put(tx, (Object)command.getMessageId(), (Object)id);
            if (previous == null) {
                sd.orderIndex.put(tx, (Object)id, (Object)new MessageKeys(command.getMessageId(), location));
            } else {
                LOG.warn((Object)("Duplicate message add attempt rejected. Message id: " + command.getMessageId()));
                sd.messageIdIndex.put(tx, (Object)command.getMessageId(), (Object)previous);
            }
        } else {
            sd.locationIndex.put(tx, (Object)location, (Object)previous);
        }
    }

    private void updateIndex(Transaction tx, KahaRemoveMessageCommand command, Location ackLocation) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (!command.hasSubscriptionKey()) {
            Long sequenceId = (Long)sd.messageIdIndex.remove(tx, (Object)command.getMessageId());
            if (sequenceId != null) {
                MessageKeys keys = (MessageKeys)sd.orderIndex.remove(tx, (Object)sequenceId);
                sd.locationIndex.remove(tx, (Object)keys.location);
            }
        } else {
            Long sequence = (Long)sd.messageIdIndex.get(tx, (Object)command.getMessageId());
            if (sequence != null) {
                String subscriptionKey = command.getSubscriptionKey();
                Long prev = (Long)sd.subscriptionAcks.put(tx, (Object)subscriptionKey, (Object)sequence);
                this.removeAckLocation(tx, sd, subscriptionKey, prev);
                this.addAckLocation(sd, sequence, subscriptionKey);
            }
        }
    }

    private void updateIndex(Transaction tx, KahaRemoveDestinationCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        sd.orderIndex.clear(tx);
        sd.orderIndex.unload(tx);
        tx.free(sd.orderIndex.getPageId());
        sd.locationIndex.clear(tx);
        sd.locationIndex.unload(tx);
        tx.free(sd.locationIndex.getPageId());
        sd.messageIdIndex.clear(tx);
        sd.messageIdIndex.unload(tx);
        tx.free(sd.messageIdIndex.getPageId());
        if (sd.subscriptions != null) {
            sd.subscriptions.clear(tx);
            sd.subscriptions.unload(tx);
            tx.free(sd.subscriptions.getPageId());
            sd.subscriptionAcks.clear(tx);
            sd.subscriptionAcks.unload(tx);
            tx.free(sd.subscriptionAcks.getPageId());
        }
        String key = this.key(command.getDestination());
        this.storedDestinations.remove(key);
        this.metadata.destinations.remove(tx, (Object)key);
    }

    private void updateIndex(Transaction tx, KahaSubscriptionCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (command.hasSubscriptionInfo()) {
            String subscriptionKey = command.getSubscriptionKey();
            sd.subscriptions.put(tx, (Object)subscriptionKey, (Object)command);
            long ackLocation = -1L;
            if (!command.getRetroactive()) {
                ackLocation = sd.nextMessageId - 1L;
            }
            sd.subscriptionAcks.put(tx, (Object)subscriptionKey, (Object)ackLocation);
            this.addAckLocation(sd, ackLocation, subscriptionKey);
        } else {
            String subscriptionKey = command.getSubscriptionKey();
            sd.subscriptions.remove(tx, (Object)subscriptionKey);
            Long prev = (Long)sd.subscriptionAcks.remove(tx, (Object)subscriptionKey);
            if (prev != null) {
                this.removeAckLocation(tx, sd, subscriptionKey, prev);
            }
        }
    }

    private void checkpointUpdate(Transaction tx, boolean cleanup) throws IOException {
        LOG.debug((Object)"Checkpoint started.");
        this.metadata.state = 2;
        this.metadata.firstInProgressTransactionLocation = this.getFirstInProgressTxLocation();
        tx.store(this.metadata.page, (Marshaller)this.metadataMarshaller, true);
        this.pageFile.flush();
        if (cleanup) {
            final TreeSet gcCandidateSet = new TreeSet(this.journal.getFileMap().keySet());
            if (this.journalFilesBeingReplicated != null) {
                gcCandidateSet.removeAll(this.journalFilesBeingReplicated);
            }
            Location firstTxLocation = this.metadata.lastUpdate;
            if (this.metadata.firstInProgressTransactionLocation != null) {
                firstTxLocation = this.metadata.firstInProgressTransactionLocation;
            }
            if (firstTxLocation != null) {
                Integer last;
                while (!gcCandidateSet.isEmpty() && (last = (Integer)gcCandidateSet.last()) >= firstTxLocation.getDataFileId()) {
                    gcCandidateSet.remove(last);
                }
            }
            for (StoredDestination sd : this.storedDestinations.values()) {
                if (gcCandidateSet.isEmpty()) break;
                sd.locationIndex.visit(tx, (BTreeVisitor)new BTreeVisitor<Location, Long>(){
                    int last = -1;

                    public boolean isInterestedInKeysBetween(Location first, Location second) {
                        if (first == null) {
                            SortedSet<Integer> subset = gcCandidateSet.headSet(second.getDataFileId() + 1);
                            if (!subset.isEmpty() && subset.last().intValue() == second.getDataFileId()) {
                                subset.remove(second.getDataFileId());
                            }
                            return !subset.isEmpty();
                        }
                        if (second == null) {
                            SortedSet<Integer> subset = gcCandidateSet.tailSet(first.getDataFileId());
                            if (!subset.isEmpty() && subset.first().intValue() == first.getDataFileId()) {
                                subset.remove(first.getDataFileId());
                            }
                            return !subset.isEmpty();
                        }
                        SortedSet<Integer> subset = gcCandidateSet.subSet(first.getDataFileId(), second.getDataFileId() + 1);
                        if (!subset.isEmpty() && subset.first().intValue() == first.getDataFileId()) {
                            subset.remove(first.getDataFileId());
                        }
                        if (!subset.isEmpty() && subset.last().intValue() == second.getDataFileId()) {
                            subset.remove(second.getDataFileId());
                        }
                        return !subset.isEmpty();
                    }

                    public void visit(List<Location> keys, List<Long> values) {
                        for (Location l : keys) {
                            int fileId = l.getDataFileId();
                            if (this.last == fileId) continue;
                            gcCandidateSet.remove(fileId);
                            this.last = fileId;
                        }
                    }
                });
            }
            if (!gcCandidateSet.isEmpty()) {
                LOG.debug((Object)("Cleanup removing the data files: " + gcCandidateSet));
                this.journal.removeDataFiles(gcCandidateSet);
            }
        }
        LOG.debug((Object)"Checkpoint done.");
    }

    public HashSet<Integer> getJournalFilesBeingReplicated() {
        return this.journalFilesBeingReplicated;
    }

    protected StoredDestination getStoredDestination(KahaDestination destination, Transaction tx) throws IOException {
        String key = this.key(destination);
        StoredDestination rc = this.storedDestinations.get(key);
        if (rc == null) {
            boolean topic = destination.getType() == KahaDestination.DestinationType.TOPIC || destination.getType() == KahaDestination.DestinationType.TEMP_TOPIC;
            rc = this.loadStoredDestination(tx, key, topic);
            this.storedDestinations.put(key, rc);
        }
        return rc;
    }

    private StoredDestination loadStoredDestination(Transaction tx, String key, boolean topic) throws IOException {
        StoredDestination rc = (StoredDestination)this.metadata.destinations.get(tx, (Object)key);
        if (rc == null) {
            rc = new StoredDestination();
            rc.orderIndex = new BTreeIndex(this.pageFile, tx.allocate());
            rc.locationIndex = new BTreeIndex(this.pageFile, tx.allocate());
            rc.messageIdIndex = new BTreeIndex(this.pageFile, tx.allocate());
            if (topic) {
                rc.subscriptions = new BTreeIndex(this.pageFile, tx.allocate());
                rc.subscriptionAcks = new BTreeIndex(this.pageFile, tx.allocate());
            }
            this.metadata.destinations.put(tx, (Object)key, (Object)rc);
        }
        rc.orderIndex.setKeyMarshaller((Marshaller)LongMarshaller.INSTANCE);
        rc.orderIndex.setValueMarshaller((Marshaller)MessageKeysMarshaller.INSTANCE);
        rc.orderIndex.load(tx);
        Map.Entry lastEntry = rc.orderIndex.getLast(tx);
        if (lastEntry != null) {
            rc.nextMessageId = (Long)lastEntry.getKey() + 1L;
        }
        rc.locationIndex.setKeyMarshaller((Marshaller)LocationMarshaller.INSTANCE);
        rc.locationIndex.setValueMarshaller((Marshaller)LongMarshaller.INSTANCE);
        rc.locationIndex.load(tx);
        rc.messageIdIndex.setKeyMarshaller((Marshaller)StringMarshaller.INSTANCE);
        rc.messageIdIndex.setValueMarshaller((Marshaller)LongMarshaller.INSTANCE);
        rc.messageIdIndex.load(tx);
        if (topic) {
            rc.subscriptions.setKeyMarshaller((Marshaller)StringMarshaller.INSTANCE);
            rc.subscriptions.setValueMarshaller((Marshaller)KahaSubscriptionCommandMarshaller.INSTANCE);
            rc.subscriptions.load(tx);
            rc.subscriptionAcks.setKeyMarshaller((Marshaller)StringMarshaller.INSTANCE);
            rc.subscriptionAcks.setValueMarshaller((Marshaller)LongMarshaller.INSTANCE);
            rc.subscriptionAcks.load(tx);
            rc.ackPositions = new TreeMap();
            rc.subscriptionCursors = new HashMap();
            Iterator iterator = rc.subscriptionAcks.iterator(tx);
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.addAckLocation(rc, (Long)entry.getValue(), (String)entry.getKey());
            }
        }
        return rc;
    }

    private void addAckLocation(StoredDestination sd, Long messageSequence, String subscriptionKey) {
        HashSet<String> hs = sd.ackPositions.get(messageSequence);
        if (hs == null) {
            hs = new HashSet();
            sd.ackPositions.put(messageSequence, hs);
        }
        hs.add(subscriptionKey);
    }

    private void removeAckLocation(Transaction tx, StoredDestination sd, String subscriptionKey, Long sequenceId) throws IOException {
        HashSet<String> hs;
        if (sequenceId != null && (hs = sd.ackPositions.get(sequenceId)) != null) {
            hs.remove(subscriptionKey);
            if (hs.isEmpty()) {
                HashSet<String> firstSet = sd.ackPositions.values().iterator().next();
                sd.ackPositions.remove(sequenceId);
                if (hs == firstSet) {
                    ArrayList<Map.Entry> deletes = new ArrayList<Map.Entry>();
                    Iterator iterator = sd.orderIndex.iterator(tx);
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        if (((Long)entry.getKey()).compareTo(sequenceId) > 0) continue;
                        deletes.add(entry);
                    }
                    for (Map.Entry entry : deletes) {
                        sd.locationIndex.remove(tx, (Object)((MessageKeys)entry.getValue()).location);
                        sd.messageIdIndex.remove(tx, (Object)((MessageKeys)entry.getValue()).messageId);
                        sd.orderIndex.remove(tx, entry.getKey());
                    }
                }
            }
        }
    }

    private String key(KahaDestination destination) {
        return destination.getType().getNumber() + ":" + destination.getName();
    }

    private ArrayList<Operation> getInflightTx(KahaTransactionInfo info, Location location) {
        TransactionId key = this.key(info);
        ArrayList<Operation> tx = this.inflightTransactions.get(key);
        if (tx == null) {
            tx = new ArrayList();
            this.inflightTransactions.put(key, tx);
        }
        return tx;
    }

    private TransactionId key(KahaTransactionInfo transactionInfo) {
        if (transactionInfo.hasLocalTransacitonId()) {
            KahaLocalTransactionId tx = transactionInfo.getLocalTransacitonId();
            LocalTransactionId rc = new LocalTransactionId();
            rc.setConnectionId(new ConnectionId(tx.getConnectionId()));
            rc.setValue(tx.getTransacitonId());
            return rc;
        }
        KahaXATransactionId tx = transactionInfo.getXaTransacitonId();
        XATransactionId rc = new XATransactionId();
        rc.setBranchQualifier(tx.getBranchQualifier().toByteArray());
        rc.setGlobalTransactionId(tx.getGlobalTransactionId().toByteArray());
        rc.setFormatId(tx.getFormatId());
        return rc;
    }

    private PageFile createPageFile() {
        PageFile index = new PageFile(this.directory, "db");
        index.setEnableWriteThread(this.isEnableIndexWriteAsync());
        index.setWriteBatchSize(this.getIndexWriteBatchSize());
        index.setPageCacheSize(this.indexCacheSize);
        return index;
    }

    private Journal createJournal() {
        Journal manager = new Journal();
        manager.setDirectory(this.directory);
        manager.setMaxFileLength(this.getJournalMaxFileLength());
        manager.setCheckForCorruptionOnStartup(this.checkForCorruptJournalFiles);
        manager.setChecksum(this.checksumJournalFiles || this.checkForCorruptJournalFiles);
        manager.setWriteBatchSize(this.getJournalMaxWriteBatchSize());
        return manager;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalMaxWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.journalMaxWriteBatchSize = journalMaxWriteBatchSize;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public boolean isDeleteAllMessages() {
        return this.deleteAllMessages;
    }

    public void setDeleteAllMessages(boolean deleteAllMessages) {
        this.deleteAllMessages = deleteAllMessages;
    }

    public void setIndexWriteBatchSize(int setIndexWriteBatchSize) {
        this.setIndexWriteBatchSize = setIndexWriteBatchSize;
    }

    public int getIndexWriteBatchSize() {
        return this.setIndexWriteBatchSize;
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.enableIndexWriteAsync = enableIndexWriteAsync;
    }

    boolean isEnableIndexWriteAsync() {
        return this.enableIndexWriteAsync;
    }

    public boolean isEnableJournalDiskSyncs() {
        return this.enableJournalDiskSyncs;
    }

    public void setEnableJournalDiskSyncs(boolean syncWrites) {
        this.enableJournalDiskSyncs = syncWrites;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public PageFile getPageFile() {
        if (this.pageFile == null) {
            this.pageFile = this.createPageFile();
        }
        return this.pageFile;
    }

    public Journal getJournal() {
        if (this.journal == null) {
            this.journal = this.createJournal();
        }
        return this.journal;
    }

    public boolean isFailIfDatabaseIsLocked() {
        return this.failIfDatabaseIsLocked;
    }

    public void setFailIfDatabaseIsLocked(boolean failIfDatabaseIsLocked) {
        this.failIfDatabaseIsLocked = failIfDatabaseIsLocked;
    }

    public boolean isIgnoreMissingJournalfiles() {
        return this.ignoreMissingJournalfiles;
    }

    public void setIgnoreMissingJournalfiles(boolean ignoreMissingJournalfiles) {
        this.ignoreMissingJournalfiles = ignoreMissingJournalfiles;
    }

    public int getIndexCacheSize() {
        return this.indexCacheSize;
    }

    public void setIndexCacheSize(int indexCacheSize) {
        this.indexCacheSize = indexCacheSize;
    }

    public boolean isCheckForCorruptJournalFiles() {
        return this.checkForCorruptJournalFiles;
    }

    public void setCheckForCorruptJournalFiles(boolean checkForCorruptJournalFiles) {
        this.checkForCorruptJournalFiles = checkForCorruptJournalFiles;
    }

    public boolean isChecksumJournalFiles() {
        return this.checksumJournalFiles;
    }

    public void setChecksumJournalFiles(boolean checksumJournalFiles) {
        this.checksumJournalFiles = checksumJournalFiles;
    }

    class RemoveOpperation
    extends Operation {
        final KahaRemoveMessageCommand command;

        public RemoveOpperation(KahaRemoveMessageCommand command, Location location) {
            super(location);
            this.command = command;
        }

        public void execute(Transaction tx) throws IOException {
            MessageDatabase.this.updateIndex(tx, this.command, this.location);
        }

        public KahaRemoveMessageCommand getCommand() {
            return this.command;
        }
    }

    class AddOpperation
    extends Operation {
        final KahaAddMessageCommand command;

        public AddOpperation(KahaAddMessageCommand command, Location location) {
            super(location);
            this.command = command;
        }

        public void execute(Transaction tx) throws IOException {
            MessageDatabase.this.upadateIndex(tx, this.command, this.location);
        }

        public KahaAddMessageCommand getCommand() {
            return this.command;
        }
    }

    abstract class Operation {
        final Location location;

        public Operation(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public abstract void execute(Transaction var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class KahaSubscriptionCommandMarshaller
    extends VariableMarshaller<KahaSubscriptionCommand> {
        static final KahaSubscriptionCommandMarshaller INSTANCE = new KahaSubscriptionCommandMarshaller();

        KahaSubscriptionCommandMarshaller() {
        }

        public KahaSubscriptionCommand readPayload(DataInput dataIn) throws IOException {
            KahaSubscriptionCommand rc = new KahaSubscriptionCommand();
            rc.mergeFramed((InputStream)((Object)dataIn));
            return rc;
        }

        public void writePayload(KahaSubscriptionCommand object, DataOutput dataOut) throws IOException {
            object.writeFramed((OutputStream)((Object)dataOut));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LocationMarshaller
    implements Marshaller<Location> {
        static final LocationMarshaller INSTANCE = new LocationMarshaller();

        LocationMarshaller() {
        }

        public Location readPayload(DataInput dataIn) throws IOException {
            Location rc = new Location();
            rc.setDataFileId(dataIn.readInt());
            rc.setOffset(dataIn.readInt());
            return rc;
        }

        public void writePayload(Location object, DataOutput dataOut) throws IOException {
            dataOut.writeInt(object.getDataFileId());
            dataOut.writeInt(object.getOffset());
        }

        public int getFixedSize() {
            return 8;
        }

        public Location deepCopy(Location source) {
            return new Location(source);
        }

        public boolean isDeepCopySupported() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StoredDestinationMarshaller
    extends VariableMarshaller<StoredDestination> {
        protected StoredDestinationMarshaller() {
        }

        public StoredDestination readPayload(DataInput dataIn) throws IOException {
            StoredDestination value = new StoredDestination();
            value.orderIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            value.locationIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            value.messageIdIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            if (dataIn.readBoolean()) {
                value.subscriptions = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                value.subscriptionAcks = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            }
            return value;
        }

        public void writePayload(StoredDestination value, DataOutput dataOut) throws IOException {
            dataOut.writeLong(value.orderIndex.getPageId());
            dataOut.writeLong(value.locationIndex.getPageId());
            dataOut.writeLong(value.messageIdIndex.getPageId());
            if (value.subscriptions != null) {
                dataOut.writeBoolean(true);
                dataOut.writeLong(value.subscriptions.getPageId());
                dataOut.writeLong(value.subscriptionAcks.getPageId());
            } else {
                dataOut.writeBoolean(false);
            }
        }
    }

    static class StoredDestination {
        long nextMessageId;
        BTreeIndex<Long, MessageKeys> orderIndex;
        BTreeIndex<Location, Long> locationIndex;
        BTreeIndex<String, Long> messageIdIndex;
        BTreeIndex<String, KahaSubscriptionCommand> subscriptions;
        BTreeIndex<String, Long> subscriptionAcks;
        HashMap<String, Long> subscriptionCursors;
        TreeMap<Long, HashSet<String>> ackPositions;

        StoredDestination() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MessageKeysMarshaller
    extends VariableMarshaller<MessageKeys> {
        static final MessageKeysMarshaller INSTANCE = new MessageKeysMarshaller();

        protected MessageKeysMarshaller() {
        }

        public MessageKeys readPayload(DataInput dataIn) throws IOException {
            return new MessageKeys(dataIn.readUTF(), LocationMarshaller.INSTANCE.readPayload(dataIn));
        }

        public void writePayload(MessageKeys object, DataOutput dataOut) throws IOException {
            dataOut.writeUTF(object.messageId);
            LocationMarshaller.INSTANCE.writePayload(object.location, dataOut);
        }
    }

    static class MessageKeys {
        final String messageId;
        final Location location;

        public MessageKeys(String messageId, Location location) {
            this.messageId = messageId;
            this.location = location;
        }

        public String toString() {
            return "[" + this.messageId + "," + this.location + "]";
        }
    }

    class StoredSubscription {
        SubscriptionInfo subscriptionInfo;
        String lastAckId;
        Location lastAckLocation;
        Location cursor;

        StoredSubscription() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MetadataMarshaller
    extends VariableMarshaller<Metadata> {
        MetadataMarshaller() {
        }

        public Metadata readPayload(DataInput dataIn) throws IOException {
            Metadata rc = new Metadata();
            rc.read(dataIn);
            return rc;
        }

        public void writePayload(Metadata object, DataOutput dataOut) throws IOException {
            object.write(dataOut);
        }
    }

    protected class Metadata {
        protected Page<Metadata> page;
        protected int state;
        protected BTreeIndex<String, StoredDestination> destinations;
        protected Location lastUpdate;
        protected Location firstInProgressTransactionLocation;

        protected Metadata() {
        }

        public void read(DataInput is) throws IOException {
            this.state = is.readInt();
            this.destinations = new BTreeIndex(MessageDatabase.this.pageFile, is.readLong());
            this.lastUpdate = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            this.firstInProgressTransactionLocation = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
        }

        public void write(DataOutput os) throws IOException {
            os.writeInt(this.state);
            os.writeLong(this.destinations.getPageId());
            if (this.lastUpdate != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.lastUpdate, os);
            } else {
                os.writeBoolean(false);
            }
            if (this.firstInProgressTransactionLocation != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.firstInProgressTransactionLocation, os);
            } else {
                os.writeBoolean(false);
            }
        }
    }
}

