/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeAccess;

public class ExpandableArrayBuffer
implements MutableDirectBuffer {
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    public static final int INITIAL_CAPACITY = 128;
    private byte[] byteArray;

    public ExpandableArrayBuffer() {
        this(128);
    }

    public ExpandableArrayBuffer(int initialCapacity) {
        this.byteArray = new byte[initialCapacity];
    }

    @Override
    public void wrap(byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(long address, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressOffset() {
        return BufferUtil.ARRAY_BASE_OFFSET;
    }

    @Override
    public byte[] byteArray() {
        return this.byteArray;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return null;
    }

    @Override
    public void setMemory(int index, int length, byte value) {
        Arrays.fill(this.byteArray, index, index + length, value);
    }

    @Override
    public int capacity() {
        return this.byteArray.length;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public void checkLimit(int limit) {
        this.ensureCapacity(limit, 1);
    }

    @Override
    public long getLong(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 8);
        long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putLong(int index, long value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        long bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Long.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
    }

    @Override
    public long getLong(int index) {
        this.boundsCheck0(index, 8);
        return UnsafeAccess.UNSAFE.getLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putLong(int index, long value) {
        this.ensureCapacity(index, 8);
        UnsafeAccess.UNSAFE.putLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public int getInt(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putInt(int index, int value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        int bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Integer.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
    }

    @Override
    public int getInt(int index) {
        this.boundsCheck0(index, 4);
        return UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putInt(int index, int value) {
        this.ensureCapacity(index, 4);
        UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public double getDouble(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 8);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = UnsafeAccess.UNSAFE.getLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
            return Double.longBitsToDouble(Long.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putDouble(int index, double value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 8);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UnsafeAccess.UNSAFE.putLong(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putDouble(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
        }
    }

    @Override
    public double getDouble(int index) {
        this.boundsCheck0(index, 8);
        return UnsafeAccess.UNSAFE.getDouble(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putDouble(int index, double value) {
        this.ensureCapacity(index, 8);
        UnsafeAccess.UNSAFE.putDouble(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public float getFloat(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 4);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = UnsafeAccess.UNSAFE.getInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
            return Float.intBitsToFloat(Integer.reverseBytes(bits));
        }
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putFloat(int index, float value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 4);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UnsafeAccess.UNSAFE.putInt(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
        } else {
            UnsafeAccess.UNSAFE.putFloat(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
        }
    }

    @Override
    public float getFloat(int index) {
        this.boundsCheck0(index, 4);
        return UnsafeAccess.UNSAFE.getFloat(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putFloat(int index, float value) {
        this.ensureCapacity(index, 4);
        UnsafeAccess.UNSAFE.putFloat(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public short getShort(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 2);
        short bits = UnsafeAccess.UNSAFE.getShort(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        return bits;
    }

    @Override
    public void putShort(int index, short value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        short bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = Short.reverseBytes(bits);
        }
        UnsafeAccess.UNSAFE.putShort(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
    }

    @Override
    public short getShort(int index) {
        this.boundsCheck0(index, 2);
        return UnsafeAccess.UNSAFE.getShort(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putShort(int index, short value) {
        this.ensureCapacity(index, 2);
        UnsafeAccess.UNSAFE.putShort(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public byte getByte(int index) {
        return this.byteArray[index];
    }

    @Override
    public void putByte(int index, byte value) {
        this.ensureCapacity(index, 1);
        this.byteArray[index] = value;
    }

    @Override
    public void getBytes(int index, byte[] dst) {
        this.getBytes(index, dst, 0, dst.length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int offset, int length) {
        System.arraycopy(this.byteArray, index, dst, offset, length);
    }

    @Override
    public void getBytes(int index, MutableDirectBuffer dstBuffer, int dstIndex, int length) {
        dstBuffer.putBytes(dstIndex, this, index, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int length) {
        int dstOffset = dstBuffer.position();
        this.getBytes(index, dstBuffer, dstOffset, length);
        dstBuffer.position(dstOffset + length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dstBuffer, int dstOffset, int length) {
        long dstBaseOffset;
        byte[] dstByteArray;
        this.boundsCheck0(index, length);
        BufferUtil.boundsCheck(dstBuffer, (long)dstOffset, length);
        if (dstBuffer.hasArray()) {
            dstByteArray = dstBuffer.array();
            dstBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)dstBuffer.arrayOffset();
        } else {
            dstByteArray = null;
            dstBaseOffset = BufferUtil.address(dstBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, dstByteArray, dstBaseOffset + (long)dstOffset, length);
    }

    @Override
    public void putBytes(int index, byte[] src) {
        this.putBytes(index, src, 0, src.length);
    }

    @Override
    public void putBytes(int index, byte[] src, int offset, int length) {
        this.ensureCapacity(index, length);
        System.arraycopy(src, offset, this.byteArray, index, length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int length) {
        int srcIndex = srcBuffer.position();
        this.putBytes(index, srcBuffer, srcIndex, length);
        srcBuffer.position(srcIndex + length);
    }

    @Override
    public void putBytes(int index, ByteBuffer srcBuffer, int srcIndex, int length) {
        long srcBaseOffset;
        byte[] srcByteArray;
        this.ensureCapacity(index, length);
        BufferUtil.boundsCheck(srcBuffer, (long)srcIndex, length);
        if (srcBuffer.hasArray()) {
            srcByteArray = srcBuffer.array();
            srcBaseOffset = BufferUtil.ARRAY_BASE_OFFSET + (long)srcBuffer.arrayOffset();
        } else {
            srcByteArray = null;
            srcBaseOffset = BufferUtil.address(srcBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(srcByteArray, srcBaseOffset + (long)srcIndex, this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, length);
    }

    @Override
    public void putBytes(int index, DirectBuffer srcBuffer, int srcIndex, int length) {
        this.ensureCapacity(index, length);
        srcBuffer.boundsCheck(srcIndex, length);
        UnsafeAccess.UNSAFE.copyMemory(srcBuffer.byteArray(), srcBuffer.addressOffset() + (long)srcIndex, this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, length);
    }

    @Override
    public char getChar(int index, ByteOrder byteOrder) {
        this.boundsCheck0(index, 2);
        char bits = UnsafeAccess.UNSAFE.getChar(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        return bits;
    }

    @Override
    public void putChar(int index, char value, ByteOrder byteOrder) {
        this.ensureCapacity(index, 2);
        char bits = value;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            bits = (char)Short.reverseBytes((short)bits);
        }
        UnsafeAccess.UNSAFE.putChar(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, bits);
    }

    @Override
    public char getChar(int index) {
        this.boundsCheck0(index, 2);
        return UnsafeAccess.UNSAFE.getChar(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index);
    }

    @Override
    public void putChar(int index, char value) {
        this.ensureCapacity(index, 2);
        UnsafeAccess.UNSAFE.putChar(this.byteArray, BufferUtil.ARRAY_BASE_OFFSET + (long)index, value);
    }

    @Override
    public String getStringUtf8(int index) {
        int length = this.getInt(index);
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, ByteOrder byteOrder) {
        int length = this.getInt(index, byteOrder);
        return this.getStringUtf8(index, length);
    }

    @Override
    public String getStringUtf8(int index, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(index + 4, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringUtf8(int index, String value) {
        return this.putStringUtf8(index, value, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder) {
        return this.putStringUtf8(index, value, byteOrder, Integer.MAX_VALUE);
    }

    @Override
    public int putStringUtf8(int index, String value, int maxEncodedSize) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedSize) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedSize);
        }
        this.putInt(index, bytes.length);
        this.putBytes(index + 4, bytes);
        return 4 + bytes.length;
    }

    @Override
    public int putStringUtf8(int index, String value, ByteOrder byteOrder, int maxEncodedSize) {
        byte[] bytes;
        byte[] byArray = bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (bytes.length > maxEncodedSize) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + maxEncodedSize);
        }
        this.putInt(index, bytes.length, byteOrder);
        this.putBytes(index + 4, bytes);
        return 4 + bytes.length;
    }

    @Override
    public String getStringWithoutLengthUtf8(int index, int length) {
        byte[] stringInBytes = new byte[length];
        this.getBytes(index, stringInBytes);
        return new String(stringInBytes, StandardCharsets.UTF_8);
    }

    @Override
    public int putStringWithoutLengthUtf8(int index, String value) {
        byte[] bytes = value != null ? value.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        this.putBytes(index, bytes);
        return bytes.length;
    }

    private void ensureCapacity(int index, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index cannot be negative: index=" + index);
        }
        long resultingPosition = (long)index + (long)length;
        int currentArrayLength = this.byteArray.length;
        if (resultingPosition > (long)currentArrayLength) {
            if (currentArrayLength >= 0x7FFFFFF7) {
                throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, maxCapacity=%d", index, length, 0x7FFFFFF7));
            }
            this.byteArray = Arrays.copyOf(this.byteArray, this.calculateExpansion(currentArrayLength, (int)resultingPosition));
        }
    }

    private int calculateExpansion(int currentLength, int requiredLength) {
        long value = currentLength;
        while (value < (long)requiredLength) {
            if ((value *= 2L) <= Integer.MAX_VALUE) continue;
            value = 0x7FFFFFF7L;
        }
        return (int)value;
    }

    private void boundsCheck0(int index, int length) {
        int currentArrayLength = this.byteArray.length;
        long resultingPosition = (long)index + (long)length;
        if (index < 0 || resultingPosition > (long)currentArrayLength) {
            throw new IndexOutOfBoundsException(String.format("index=%d, length=%d, capacity=%d", index, length, currentArrayLength));
        }
    }

    @Override
    public void boundsCheck(int index, int length) {
        this.boundsCheck0(index, length);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpandableArrayBuffer that = (ExpandableArrayBuffer)obj;
        return Arrays.equals(this.byteArray, that.byteArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.byteArray);
    }

    @Override
    public int compareTo(DirectBuffer that) {
        int thisCapacity = this.capacity();
        int thatCapacity = that.capacity();
        byte[] thisByteArray = this.byteArray;
        byte[] thatByteArray = that.byteArray();
        long thisOffset = this.addressOffset();
        long thatOffset = that.addressOffset();
        int length = Math.min(thisCapacity, thatCapacity);
        for (int i = 0; i < length; ++i) {
            int cmp = Byte.compare(UnsafeAccess.UNSAFE.getByte(thisByteArray, thisOffset + (long)i), UnsafeAccess.UNSAFE.getByte(thatByteArray, thatOffset + (long)i));
            if (0 == cmp) continue;
            return cmp;
        }
        if (thisCapacity != thatCapacity) {
            return thisCapacity - thatCapacity;
        }
        return 0;
    }
}

