/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.html;

import java.util.ArrayList;
import junit.framework.Assert;
import net.sourceforge.jwebunit.html.Cell;

public class Row {
    private ArrayList cells = new ArrayList();

    public Row() {
    }

    public Row(Object[] rowCells) {
        this.appendCells(rowCells);
    }

    public void appendCells(Object[] rowCells) {
        for (int i = 0; i < rowCells.length; ++i) {
            Object column = rowCells[i];
            if (column instanceof Cell) {
                this.cells.add((Cell)column);
                continue;
            }
            this.cells.add(new Cell(column.toString()));
        }
    }

    public void appendCell(Cell cell) {
        this.cells.add(cell);
    }

    public void appendCell(String cellText) {
        this.cells.add(new Cell(cellText));
    }

    public ArrayList getCells() {
        return this.cells;
    }

    public int getCellCount() {
        return this.cells.size();
    }

    public boolean hasText(String text) {
        for (int i = 0; i < this.getCellCount(); ++i) {
            Cell c = (Cell)this.getCells().get(i);
            if (!c.equals(text)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatch(String regexp) {
        for (int i = 0; i < this.getCellCount(); ++i) {
            Cell c = (Cell)this.getCells().get(i);
            if (!c.match(regexp)) continue;
            return true;
        }
        return false;
    }

    public void assertEquals(Row r) {
        Assert.assertTrue((String)"Cell count are not equal", (this.getCells().size() == r.getCells().size() ? 1 : 0) != 0);
        for (int i = 0; i < this.getCells().size(); ++i) {
            ((Cell)this.getCells().get(i)).assertEquals((Cell)r.getCells().get(i));
        }
    }

    public void assertMatch(Row r) {
        Assert.assertTrue((String)"Cell count are not equal", (this.getCells().size() == r.getCells().size() ? 1 : 0) != 0);
        for (int i = 0; i < this.getCells().size(); ++i) {
            ((Cell)this.getCells().get(i)).assertMatch((Cell)r.getCells().get(i));
        }
    }
}

