/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.html;

import junit.framework.Assert;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class Cell {
    private int colspan;
    private int rowspan;
    private String value;

    public Cell(String value) {
        this(value, 1, 1);
    }

    public Cell(String value, int colspan, int rowspan) {
        this.value = value;
        this.colspan = colspan;
        this.rowspan = rowspan;
    }

    public int getColspan() {
        return this.colspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public final String getValue() {
        return this.value;
    }

    public void assertEquals(Cell c) {
        Assert.assertTrue((String)(c.getValue() + " do not equal " + this.getValue()), (boolean)this.getValue().equals(c.getValue()));
        Assert.assertTrue((String)("Expected colspan was " + c.getColspan() + " but was " + this.getColspan()), (this.getColspan() == c.getColspan() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected rowspan was " + c.getRowspan() + " but was " + this.getRowspan()), (this.getRowspan() == c.getRowspan() ? 1 : 0) != 0);
    }

    public void assertMatch(Cell c) {
        RE re = this.getRE(c.getValue());
        Assert.assertTrue((String)(c.getValue() + " do not match " + this.getValue()), (boolean)re.match(this.getValue()));
        Assert.assertTrue((String)("Expected colspan was " + c.getColspan() + " but was " + this.getColspan()), (this.getColspan() == c.getColspan() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected rowspan was " + c.getRowspan() + " but was " + this.getRowspan()), (this.getRowspan() == c.getRowspan() ? 1 : 0) != 0);
    }

    public boolean equals(String text) {
        return this.getValue().equals(text);
    }

    public boolean match(String regexp) {
        RE re = this.getRE(regexp);
        return re.match(this.getValue());
    }

    private RE getRE(String regexp) {
        RE re = null;
        try {
            re = new RE(regexp, 4);
        }
        catch (RESyntaxException e) {
            Assert.fail((String)e.toString());
        }
        return re;
    }
}

