/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.KeyboardEvent;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlElement
extends DomElement {
    private static final long serialVersionUID = -2841932584831342634L;
    private static final Log LOG = LogFactory.getLog(HtmlElement.class);
    public static final Short TAB_INDEX_OUT_OF_BOUNDS = new Short(Short.MIN_VALUE);
    private List<HtmlAttributeChangeListener> attributeListeners_;
    private HtmlForm owningForm_;

    protected HtmlElement(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        String value;
        if (page != null && page.getWebClient().getBrowserVersion().isFirefox() && (value = this.getAttribute("class")) != ATTRIBUTE_NOT_DEFINED) {
            this.getAttributeNode("class").setValue(value.trim());
        }
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        String oldAttributeValue = this.getAttribute(qualifiedName);
        String value = attributeValue;
        boolean mappedElement = HtmlPage.isMappedElement(this.getOwnerDocument(), qualifiedName);
        if (mappedElement) {
            ((HtmlPage)this.getPage()).removeMappedElement(this);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
        if (value.length() == 0) {
            value = ATTRIBUTE_VALUE_EMPTY;
        }
        if (!(this.getOwnerDocument() instanceof HtmlPage)) {
            return;
        }
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        if (mappedElement) {
            htmlPage.addMappedElement(this);
        }
        HtmlAttributeChangeEvent htmlEvent = oldAttributeValue == ATTRIBUTE_NOT_DEFINED ? new HtmlAttributeChangeEvent(this, qualifiedName, attributeValue) : new HtmlAttributeChangeEvent(this, qualifiedName, oldAttributeValue);
        if (oldAttributeValue == ATTRIBUTE_NOT_DEFINED) {
            this.fireHtmlAttributeAdded(htmlEvent);
            ((HtmlPage)this.getPage()).fireHtmlAttributeAdded(htmlEvent);
        } else {
            this.fireHtmlAttributeReplaced(htmlEvent);
            ((HtmlPage)this.getPage()).fireHtmlAttributeReplaced(htmlEvent);
        }
        if (this.getPage().getWebClient().getBrowserVersion().isIE()) {
            this.fireEvent(Event.createPropertyChangeEvent(this, qualifiedName));
        }
    }

    public final List<HtmlElement> getHtmlElementsByTagNames(List<String> tagNames) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        for (String tagName : tagNames) {
            list.addAll(this.getHtmlElementsByTagName(tagName));
        }
        return list;
    }

    public final <E extends HtmlElement> List<E> getHtmlElementsByTagName(String tagName) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        String lowerCaseTagName = tagName.toLowerCase();
        Iterable<HtmlElement> iterable = this.getHtmlElementDescendants();
        for (HtmlElement element : iterable) {
            if (!lowerCaseTagName.equals(element.getTagName())) continue;
            list.add(element);
        }
        return list;
    }

    @Override
    public final void removeAttribute(String attributeName) {
        String value = this.getAttribute(attributeName);
        if (this.getPage() instanceof HtmlPage) {
            ((HtmlPage)this.getPage()).removeMappedElement(this);
        }
        super.removeAttribute(attributeName);
        if (this.getPage() instanceof HtmlPage) {
            ((HtmlPage)this.getPage()).addMappedElement(this);
            HtmlAttributeChangeEvent event = new HtmlAttributeChangeEvent(this, attributeName, value);
            this.fireHtmlAttributeRemoved(event);
            ((HtmlPage)this.getPage()).fireHtmlAttributeRemoved(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        DomNode parentNode;
        if (this.attributeListeners_ != null) {
            HtmlElement htmlElement = this;
            synchronized (htmlElement) {
                for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                    listener.attributeAdded(event);
                }
            }
        }
        if ((parentNode = this.getParentNode()) instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeAdded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        DomNode parentNode;
        if (this.attributeListeners_ != null) {
            HtmlElement htmlElement = this;
            synchronized (htmlElement) {
                for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                    listener.attributeReplaced(event);
                }
            }
        }
        if ((parentNode = this.getParentNode()) instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeReplaced(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        DomNode parentNode;
        if (this.attributeListeners_ != null) {
            HtmlElement htmlElement = this;
            synchronized (htmlElement) {
                for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                    listener.attributeRemoved(event);
                }
            }
        }
        if ((parentNode = this.getParentNode()) instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeRemoved(event);
        }
    }

    @Override
    public String getNodeName() {
        String name = this.getLocalName();
        if (this.getPrefix() != null) {
            name = this.getPrefix() + ':' + name;
        }
        name = name.toLowerCase();
        return name;
    }

    public final String getId() {
        return this.getAttribute("id");
    }

    public final void setId(String newId) {
        this.setAttribute("id", newId);
    }

    public Short getTabIndex() {
        String index = this.getAttribute("tabindex");
        if (index == null || index.length() == 0) {
            return null;
        }
        try {
            long l = Long.parseLong(index);
            if (l >= 0L && l <= 32767L) {
                return new Short(new Long(l).shortValue());
            }
            return TAB_INDEX_OUT_OF_BOUNDS;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public HtmlElement getEnclosingElement(String tagName) {
        String tagNameLC = tagName.toLowerCase();
        for (DomNode currentNode = this.getParentNode(); currentNode != null; currentNode = currentNode.getParentNode()) {
            if (!(currentNode instanceof HtmlElement) || !currentNode.getNodeName().equals(tagNameLC)) continue;
            return (HtmlElement)currentNode;
        }
        return null;
    }

    public HtmlForm getEnclosingForm() {
        if (this.owningForm_ != null) {
            return this.owningForm_;
        }
        return (HtmlForm)this.getEnclosingElement("form");
    }

    public HtmlForm getEnclosingFormOrDie() throws IllegalStateException {
        HtmlForm form = this.getEnclosingForm();
        if (form == null) {
            throw new IllegalStateException("Element is not contained within a form: " + this);
        }
        return form;
    }

    public void type(String text) throws IOException {
        for (char ch : text.toCharArray()) {
            this.type(ch);
        }
    }

    public void type(String text, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        for (char ch : text.toCharArray()) {
            this.type(ch, shiftKey, ctrlKey, altKey);
        }
    }

    public Page type(char c) throws IOException {
        return this.type(c, false, false, false);
    }

    public Page type(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        boolean ie;
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        HtmlPage page = (HtmlPage)this.getPage();
        if (page.getFocusedElement() != this) {
            this.focus();
        }
        int keyCode = KeyboardEvent.charToKeyCode(c);
        KeyboardEvent keyDown = new KeyboardEvent(this, "keydown", keyCode, shiftKey, ctrlKey, altKey);
        ScriptResult keyDownResult = this.fireEvent(keyDown);
        KeyboardEvent keyPress = new KeyboardEvent(this, "keypress", keyCode, shiftKey, ctrlKey, altKey);
        ScriptResult keyPressResult = this.fireEvent(keyPress);
        if (!keyDown.isAborted(keyDownResult) && !keyPress.isAborted(keyPressResult)) {
            this.doType(c, shiftKey, ctrlKey, altKey);
        }
        if (!(ie = page.getWebClient().getBrowserVersion().isIE()) && (this instanceof HtmlTextInput || this instanceof HtmlTextArea || this instanceof HtmlPasswordInput)) {
            KeyboardEvent input = new KeyboardEvent(this, "input", keyCode, shiftKey, ctrlKey, altKey);
            this.fireEvent(input);
        }
        KeyboardEvent keyUp = new KeyboardEvent(this, "keyup", keyCode, shiftKey, ctrlKey, altKey);
        this.fireEvent(keyUp);
        HtmlForm form = this.getEnclosingForm();
        if (form != null && c == '\n' && this.isSubmittableByEnter()) {
            HtmlSubmitInput submit;
            if (!ie && (submit = (HtmlSubmitInput)form.getFirstByXPath(".//input[@type='submit']")) != null) {
                return submit.click();
            }
            form.submit((SubmittableElement)((Object)this));
            page.getWebClient().getJavaScriptEngine().processPostponedActions();
        }
        return page.getWebClient().getCurrentWindow().getEnclosedPage();
    }

    protected void doType(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) {
    }

    protected boolean isSubmittableByEnter() {
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(ClassUtils.getShortClassName(this.getClass()));
        buffer.append("[<");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        this.printOpeningTagContentAsXml(printWriter);
        buffer.append(writer.toString());
        buffer.append(">]");
        return buffer.toString();
    }

    public final <E extends HtmlElement> E getOneHtmlElementByAttribute(String elementName, String attributeName, String attributeValue) throws ElementNotFoundException {
        WebAssert.notNull("elementName", elementName);
        WebAssert.notNull("attributeName", attributeName);
        WebAssert.notNull("attributeValue", attributeValue);
        List<E> list = this.getElementsByAttribute(elementName, attributeName, attributeValue);
        int listSize = list.size();
        if (listSize == 0) {
            throw new ElementNotFoundException(elementName, attributeName, attributeValue);
        }
        return (E)((HtmlElement)list.get(0));
    }

    public <E extends HtmlElement> E getElementById(String id) throws ElementNotFoundException {
        return ((HtmlPage)this.getPage()).getHtmlElementById(id);
    }

    public boolean hasHtmlElementWithId(String id) {
        try {
            this.getElementById(id);
            return true;
        }
        catch (ElementNotFoundException e) {
            return false;
        }
    }

    public final <E extends HtmlElement> List<E> getElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        String lowerCaseTagName = elementName.toLowerCase();
        for (HtmlElement next : this.getHtmlElementDescendants()) {
            String attValue;
            if (!next.getTagName().equals(lowerCaseTagName) || (attValue = next.getAttribute(attributeName)) == null || !attValue.equals(attributeValue)) continue;
            list.add(next);
        }
        return list;
    }

    public final HtmlElement appendChildIfNoneExists(String tagName) {
        HtmlElement child;
        List children = this.getHtmlElementsByTagName(tagName);
        if (children.isEmpty()) {
            child = ((HtmlPage)this.getPage()).createElement(tagName);
            this.appendChild(child);
        } else {
            child = (HtmlElement)children.get(0);
        }
        return child;
    }

    public final void removeChild(String tagName, int i) {
        List children = this.getHtmlElementsByTagName(tagName);
        if (i >= 0 && i < children.size()) {
            ((HtmlElement)children.get(i)).remove();
        }
    }

    public final Iterable<HtmlElement> getChildElements() {
        return new Iterable<HtmlElement>(){

            @Override
            public Iterator<HtmlElement> iterator() {
                return new ChildElementsIterator();
            }
        };
    }

    static Map<String, DomAttr> createAttributeMap(int attributeCount) {
        return new LinkedHashMap<String, DomAttr>(attributeCount);
    }

    static DomAttr addAttributeToMap(SgmlPage page, Map<String, DomAttr> attributeMap, String namespaceURI, String qualifiedName, String value) {
        DomAttr newAttr = new DomAttr(page, namespaceURI, qualifiedName, value, true);
        attributeMap.put(qualifiedName, newAttr);
        return newAttr;
    }

    public final Function getEventHandler(String eventName) {
        HTMLElement jsObj = (HTMLElement)this.getScriptObject();
        return jsObj.getEventHandler(eventName);
    }

    public final void setEventHandler(String eventName, Function eventHandler) {
        HTMLElement jsObj = (HTMLElement)this.getScriptObject();
        jsObj.setEventHandler(eventName, eventHandler);
    }

    public final void setEventHandler(String eventName, String jsSnippet) {
        EventHandler function = new EventHandler(this, eventName, jsSnippet);
        this.setEventHandler(eventName, (Function)function);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created event handler " + function.getFunctionName() + " for " + eventName + " on " + this));
        }
    }

    public final void removeEventHandler(String eventName) {
        this.setEventHandler(eventName, (Function)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        HtmlElement htmlElement = this;
        synchronized (htmlElement) {
            if (this.attributeListeners_ == null) {
                this.attributeListeners_ = new ArrayList<HtmlAttributeChangeListener>();
            }
            this.attributeListeners_.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        HtmlElement htmlElement = this;
        synchronized (htmlElement) {
            if (this.attributeListeners_ != null) {
                this.attributeListeners_.remove(listener);
            }
        }
    }

    public ScriptResult fireEvent(String eventType) {
        return this.fireEvent(new Event(this, eventType));
    }

    public ScriptResult fireEvent(final Event event) {
        WebClient client = this.getPage().getWebClient();
        if (!client.isJavaScriptEnabled()) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Firing " + event));
        }
        final HTMLElement jsElt = (HTMLElement)this.getScriptObject();
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                return jsElt.fireEvent(event);
            }
        };
        HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
        ScriptResult result = (ScriptResult)cf.call(action);
        if (event.isAborted(result)) {
            this.preventDefault();
        }
        return result;
    }

    protected void preventDefault() {
    }

    public Page mouseOver() {
        return this.mouseOver(false, false, false, 0);
    }

    public Page mouseOver(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseover", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseMove() {
        return this.mouseMove(false, false, false, 0);
    }

    public Page mouseMove(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousemove", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseOut() {
        return this.mouseOut(false, false, false, 0);
    }

    public Page mouseOut(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseout", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseDown() {
        return this.mouseDown(false, false, false, 0);
    }

    public Page mouseDown(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousedown", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseUp() {
        return this.mouseUp(false, false, false, 0);
    }

    public Page mouseUp(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseup", shiftKey, ctrlKey, altKey, button);
    }

    public Page rightClick() {
        return this.rightClick(false, false, false);
    }

    public Page rightClick(boolean shiftKey, boolean ctrlKey, boolean altKey) {
        Page mouseDownPage = this.mouseDown(shiftKey, ctrlKey, altKey, 2);
        if (mouseDownPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"rightClick() is incomplete, as mouseDown() loaded a different page.");
            }
            return mouseDownPage;
        }
        Page mouseUpPage = this.mouseUp(shiftKey, ctrlKey, altKey, 2);
        if (mouseUpPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"rightClick() is incomplete, as mouseUp() loaded a different page.");
            }
            return mouseUpPage;
        }
        return this.doMouseEvent("contextmenu", shiftKey, ctrlKey, altKey, 2);
    }

    private Page doMouseEvent(String eventType, boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        HtmlPage page = (HtmlPage)this.getPage();
        MouseEvent event = new MouseEvent(this, eventType, shiftKey, ctrlKey, altKey, button);
        ScriptResult scriptResult = this.fireEvent(event);
        Page currentPage = scriptResult == null ? page : scriptResult.getNewPage();
        return currentPage;
    }

    public void blur() {
        ((HtmlPage)this.getPage()).setFocusedElement(null);
    }

    public void focus() {
        HtmlPage page = (HtmlPage)this.getPage();
        page.setFocusedElement(this);
        WebClient webClient = page.getWebClient();
        if (webClient.getBrowserVersion().isIE()) {
            HTMLElement jsElt = (HTMLElement)this.getScriptObject();
            jsElt.jsxFunction_setActive();
        }
    }

    @Override
    protected void checkChildHierarchy(Node childNode) throws DOMException {
        if (!(childNode instanceof Element || childNode instanceof Text || childNode instanceof Comment || childNode instanceof ProcessingInstruction || childNode instanceof CDATASection || childNode instanceof EntityReference)) {
            throw new DOMException(3, "The Element may not have a child of this type: " + childNode.getNodeType());
        }
        super.checkChildHierarchy(childNode);
    }

    void setOwningForm(HtmlForm form) {
        this.owningForm_ = form;
    }

    void removeFocus() {
    }

    @Override
    protected boolean isAttributeCaseSensitive() {
        return false;
    }

    public <P extends Page> P click() throws IOException {
        return this.click(false, false, false);
    }

    public <P extends Page> P click(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)this.getPage();
        }
        this.mouseDown(shiftKey, ctrlKey, altKey, 0);
        HtmlElement elementToFocus = this instanceof SubmittableElement ? this : null;
        ((HtmlPage)this.getPage()).setFocusedElement(elementToFocus);
        this.mouseUp(shiftKey, ctrlKey, altKey, 0);
        MouseEvent event = new MouseEvent(this, "click", shiftKey, ctrlKey, altKey, 0);
        return this.click(event);
    }

    public <P extends Page> P click(Event event) throws IOException {
        boolean pageAlreadyChanged;
        SgmlPage page = this.getPage();
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)page;
        }
        Page contentPage = page.getEnclosingWindow().getEnclosedPage();
        boolean stateUpdated = false;
        if (this.isStateUpdateFirst()) {
            this.doClickAction();
            stateUpdated = true;
        }
        JavaScriptEngine jsEngine = page.getWebClient().getJavaScriptEngine();
        jsEngine.holdPosponedActions();
        ScriptResult scriptResult = this.fireEvent(event);
        boolean bl = pageAlreadyChanged = contentPage != page.getEnclosingWindow().getEnclosedPage();
        if (!(pageAlreadyChanged || stateUpdated || event.isAborted(scriptResult))) {
            this.doClickAction();
        }
        jsEngine.processPostponedActions();
        return (P)this.getPage().getWebClient().getCurrentWindow().getEnclosedPage();
    }

    public <P extends Page> P dblClick() throws IOException {
        return this.dblClick(false, false, false);
    }

    public <P extends Page> P dblClick(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)this.getPage();
        }
        P clickPage = this.click(shiftKey, ctrlKey, altKey);
        if (clickPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"dblClick() is ignored, as click() loaded a different page.");
            }
            return clickPage;
        }
        MouseEvent event = new MouseEvent(this, "dblclick", shiftKey, ctrlKey, altKey, 0);
        ScriptResult scriptResult = this.fireEvent(event);
        if (scriptResult == null) {
            return clickPage;
        }
        return (P)scriptResult.getNewPage();
    }

    protected void doClickAction() throws IOException {
    }

    public final String getLangAttribute() {
        return this.getAttribute("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttribute("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttribute("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttribute("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttribute("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttribute("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttribute("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttribute("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttribute("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttribute("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttribute("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttribute("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttribute("onkeyup");
    }

    protected boolean isStateUpdateFirst() {
        return false;
    }

    @Override
    public String getCanonicalXPath() {
        DomNode parent = this.getParentNode();
        if (parent.getNodeType() == 9) {
            return "/" + this.getNodeName();
        }
        return parent.getCanonicalXPath() + '/' + this.getXPathToken();
    }

    private String getXPathToken() {
        DomNode parent = this.getParentNode();
        int total = 0;
        int nodeIndex = 0;
        for (DomNode child : parent.getChildren()) {
            if (child.getNodeType() == 1 && child.getNodeName().equals(this.getNodeName())) {
                ++total;
            }
            if (child != this) continue;
            nodeIndex = total;
        }
        if (nodeIndex == 1 && total == 1) {
            return this.getNodeName();
        }
        return this.getNodeName() + '[' + nodeIndex + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChildElementsIterator
    implements Iterator<HtmlElement> {
        private HtmlElement nextElement_;

        protected ChildElementsIterator() {
            if (HtmlElement.this.getFirstChild() != null) {
                if (HtmlElement.this.getFirstChild() instanceof HtmlElement) {
                    this.nextElement_ = (HtmlElement)HtmlElement.this.getFirstChild();
                } else {
                    this.setNextElement(HtmlElement.this.getFirstChild());
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextElement_ != null;
        }

        @Override
        public HtmlElement next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (this.nextElement_ == null) {
                throw new IllegalStateException();
            }
            DomNode sibling = this.nextElement_.getPreviousSibling();
            if (sibling != null) {
                sibling.remove();
            }
        }

        public HtmlElement nextElement() {
            if (this.nextElement_ != null) {
                HtmlElement result = this.nextElement_;
                this.setNextElement(this.nextElement_);
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextElement(DomNode node) {
            DomNode next;
            for (next = node.getNextSibling(); next != null && !(next instanceof HtmlElement); next = next.getNextSibling()) {
            }
            this.nextElement_ = (HtmlElement)next;
        }
    }
}

