/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;

class BrowserConfiguration {
    private String browserFamily_;
    private String defaultValue_;
    private int minVersionNumber_ = -1;
    private int maxVersionNumber_ = Integer.MAX_VALUE;
    private boolean iteratable_ = true;

    BrowserConfiguration() {
    }

    static BrowserConfiguration ff(String defaultValue) {
        BrowserConfiguration browserConfiguration = new BrowserConfiguration();
        browserConfiguration.browserFamily_ = "FF";
        browserConfiguration.defaultValue_ = defaultValue;
        return browserConfiguration;
    }

    static BrowserConfiguration ie(String defaultValue) {
        BrowserConfiguration browserConfiguration = new BrowserConfiguration();
        browserConfiguration.browserFamily_ = "IE";
        browserConfiguration.defaultValue_ = defaultValue;
        return browserConfiguration;
    }

    static BrowserConfiguration chrome(String defaultValue) {
        BrowserConfiguration browserConfiguration = new BrowserConfiguration();
        browserConfiguration.browserFamily_ = "Chrome";
        browserConfiguration.defaultValue_ = defaultValue;
        return browserConfiguration;
    }

    static BrowserConfiguration ffBelow60(String defaultValue) {
        return BrowserConfiguration.ff(defaultValue).upTo(59);
    }

    static BrowserConfiguration ff60up(String defaultValue) {
        return BrowserConfiguration.ff(defaultValue).startingWith(60);
    }

    static BrowserConfiguration getMatchingConfiguration(BrowserVersion browserVersion, BrowserConfiguration[] browserConfigurations) {
        for (BrowserConfiguration browserConfiguration : browserConfigurations) {
            if (!browserVersion.getNickname().startsWith(browserConfiguration.browserFamily_) || browserVersion.getBrowserVersionNumeric() < browserConfiguration.minVersionNumber_ || browserVersion.getBrowserVersionNumeric() > browserConfiguration.maxVersionNumber_) continue;
            return browserConfiguration;
        }
        return null;
    }

    String getDefaultValue() {
        return this.defaultValue_;
    }

    BrowserConfiguration startingWith(int minVersionNumber) {
        if (this.minVersionNumber_ != -1) {
            throw new IllegalStateException("startingWith has already been set to " + this.minVersionNumber_);
        }
        this.minVersionNumber_ = minVersionNumber;
        return this;
    }

    BrowserConfiguration upTo(int maxVersionNumber) {
        if (this.maxVersionNumber_ != Integer.MAX_VALUE) {
            throw new IllegalStateException("below has already been set to " + this.maxVersionNumber_);
        }
        this.maxVersionNumber_ = maxVersionNumber;
        return this;
    }

    BrowserConfiguration setIteratable(boolean iteratable) {
        this.iteratable_ = iteratable;
        return this;
    }

    boolean isIteratable() {
        return this.iteratable_;
    }
}

