/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.HiddenFunctionObject;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.NativeFunctionToStringFunction;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.RecursiveFunctionObject;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.TimeoutError;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptExecutor;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.host.ActiveXObject;
import com.gargoylesoftware.htmlunit.javascript.host.ArrayCustom;
import com.gargoylesoftware.htmlunit.javascript.host.DateCustom;
import com.gargoylesoftware.htmlunit.javascript.host.NumberCustom;
import com.gargoylesoftware.htmlunit.javascript.host.Reflect;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.intl.Intl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.IdFunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.UniqueTag;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptEngine
implements AbstractJavaScriptEngine<Script> {
    private static final Log LOG = LogFactory.getLog(JavaScriptEngine.class);
    private WebClient webClient_;
    private final HtmlUnitContextFactory contextFactory_;
    private final JavaScriptConfiguration jsConfig_;
    private transient ThreadLocal<Boolean> javaScriptRunning_;
    private transient ThreadLocal<List<PostponedAction>> postponedActions_;
    private transient boolean holdPostponedActions_;
    private transient JavaScriptExecutor javaScriptExecutor_;
    public static final String KEY_STARTING_SCOPE = "startingScope";
    public static final String KEY_STARTING_PAGE = "startingPage";

    public JavaScriptEngine(WebClient webClient) {
        this.webClient_ = webClient;
        this.contextFactory_ = new HtmlUnitContextFactory(webClient);
        this.initTransientFields();
        this.jsConfig_ = JavaScriptConfiguration.getInstance(webClient.getBrowserVersion());
    }

    public final WebClient getWebClient() {
        return this.webClient_;
    }

    public HtmlUnitContextFactory getContextFactory() {
        return this.contextFactory_;
    }

    @Override
    public void initialize(WebWindow webWindow) {
        WebAssert.notNull("webWindow", webWindow);
        this.getContextFactory().call(cx -> {
            try {
                this.init(webWindow, cx);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception while initializing JavaScript for the page", (Throwable)e);
                throw new ScriptException(null, (Throwable)e);
            }
            return null;
        });
    }

    public JavaScriptExecutor getJavaScriptExecutor() {
        return this.javaScriptExecutor_;
    }

    private void init(WebWindow webWindow, Context context) throws Exception {
        Window window;
        HashMap<String, Scriptable> prototypesPerJSName;
        HashMap<Class<? extends Scriptable>, Scriptable> prototypes;
        BrowserVersion browserVersion;
        WebClient webClient;
        block52: {
            Scriptable scriptable;
            webClient = webWindow.getWebClient();
            browserVersion = webClient.getBrowserVersion();
            prototypes = new HashMap<Class<? extends Scriptable>, Scriptable>();
            prototypesPerJSName = new HashMap<String, Scriptable>();
            window = new Window();
            window.setClassName("Window");
            context.initStandardObjects((ScriptableObject)window);
            ClassConfiguration windowConfig = this.jsConfig_.getClassConfiguration("Window");
            if (windowConfig.getJsConstructor() != null) {
                RecursiveFunctionObject functionObject = new RecursiveFunctionObject("Window", windowConfig.getJsConstructor(), (Scriptable)window);
                ScriptableObject.defineProperty((Scriptable)window, (String)"constructor", (Object)((Object)functionObject), (int)7);
            } else {
                JavaScriptEngine.defineConstructor(window, (Scriptable)window, new Window());
            }
            JavaScriptEngine.deleteProperties((Scriptable)window, "java", "javax", "org", "com", "edu", "net", "JavaAdapter", "JavaImporter", "Continuation", "Packages", "getClass");
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_XML)) {
                JavaScriptEngine.deleteProperties((Scriptable)window, "XML", "XMLList", "Namespace", "QName");
            }
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_Iterator)) {
                JavaScriptEngine.deleteProperties((Scriptable)window, "Iterator", "StopIteration");
            }
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_SYMBOL)) {
                JavaScriptEngine.deleteProperties((Scriptable)window, "Symbol");
            }
            ScriptableObject errorObject = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, (String)"Error");
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_ERROR_STACK_TRACE_LIMIT)) {
                errorObject.defineProperty("stackTraceLimit", (Object)10, 0);
            } else {
                ScriptableObject.deleteProperty((Scriptable)errorObject, (String)"stackTraceLimit");
            }
            if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_ERROR_CAPTURE_STACK_TRACE)) {
                ScriptableObject.deleteProperty((Scriptable)errorObject, (String)"captureStackTrace");
            }
            Intl intl = new Intl();
            intl.setParentScope((Scriptable)window);
            window.defineProperty(intl.getClassName(), intl, 2);
            intl.defineProperties(browserVersion);
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_REFLECT)) {
                Reflect reflect = new Reflect();
                reflect.setParentScope((Scriptable)window);
                window.defineProperty(reflect.getClassName(), reflect, 2);
                reflect.defineProperties();
            }
            String windowClassName = Window.class.getName();
            for (ClassConfiguration classConfiguration : this.jsConfig_.getAll()) {
                boolean bl = windowClassName.equals(classConfiguration.getHostClass().getName());
                if (bl) {
                    JavaScriptEngine.configureConstantsPropertiesAndFunctions(classConfiguration, window);
                    HtmlUnitScriptable prototype = JavaScriptEngine.configureClass(classConfiguration, (Scriptable)window, browserVersion);
                    prototypesPerJSName.put(classConfiguration.getClassName(), (Scriptable)prototype);
                    continue;
                }
                HtmlUnitScriptable prototype2 = JavaScriptEngine.configureClass(classConfiguration, (Scriptable)window, browserVersion);
                if (classConfiguration.isJsObject()) {
                    HtmlUnitScriptable obj = classConfiguration.getHostClass().newInstance();
                    prototype2.defineProperty("__proto__", (Object)prototype2, 2);
                    obj.defineProperty("prototype", (Object)prototype2, 2);
                    obj.setParentScope((Scriptable)window);
                    obj.setClassName(classConfiguration.getClassName());
                    ScriptableObject.defineProperty((Scriptable)window, (String)obj.getClassName(), (Object)((Object)obj), (int)2);
                    JavaScriptEngine.configureConstants(classConfiguration, obj);
                }
                prototypes.put((Class<? extends Scriptable>)classConfiguration.getHostClass(), (Scriptable)prototype2);
                prototypesPerJSName.put(classConfiguration.getClassName(), (Scriptable)prototype2);
            }
            for (ClassConfiguration classConfiguration : this.jsConfig_.getAll()) {
                Object function;
                block51: {
                    Member member = classConfiguration.getJsConstructor();
                    String jsClassName = classConfiguration.getClassName();
                    Scriptable prototype3 = (Scriptable)prototypesPerJSName.get(jsClassName);
                    String hostClassSimpleName = classConfiguration.getHostClassSimpleName();
                    if ("Image".equals(hostClassSimpleName) && browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_PROTOTYPE_SAME_AS_HTML_IMAGE)) {
                        prototype3 = (Scriptable)prototypesPerJSName.get("HTMLImageElement");
                    }
                    if ("Option".equals(hostClassSimpleName)) {
                        prototype3 = (Scriptable)prototypesPerJSName.get("HTMLOptionElement");
                    }
                    switch (hostClassSimpleName) {
                        case "WebKitMutationObserver": {
                            prototype3 = (Scriptable)prototypesPerJSName.get("MutationObserver");
                            break;
                        }
                        case "webkitURL": {
                            prototype3 = (Scriptable)prototypesPerJSName.get("URL");
                            break;
                        }
                    }
                    if (prototype3 == null || !classConfiguration.isJsObject()) continue;
                    if (member == null) {
                        ScriptableObject constructor;
                        if ("Window".equals(jsClassName)) {
                            constructor = (ScriptableObject)ScriptableObject.getProperty((Scriptable)window, (String)"constructor");
                        } else {
                            constructor = classConfiguration.getHostClass().newInstance();
                            ((SimpleScriptable)constructor).setClassName(classConfiguration.getClassName());
                        }
                        JavaScriptEngine.defineConstructor(window, prototype3, constructor);
                        JavaScriptEngine.configureConstantsStaticPropertiesAndStaticFunctions(classConfiguration, constructor);
                        continue;
                    }
                    function = "Window".equals(jsClassName) ? (BaseFunction)ScriptableObject.getProperty((Scriptable)window, (String)"constructor") : new RecursiveFunctionObject(jsClassName, member, (Scriptable)window);
                    if ("WebKitMutationObserver".equals(hostClassSimpleName) || "webkitURL".equals(hostClassSimpleName) || "Image".equals(hostClassSimpleName) || "Option".equals(hostClassSimpleName)) {
                        Object prototypeProperty;
                        block50: {
                            prototypeProperty = ScriptableObject.getProperty((Scriptable)window, (String)prototype3.getClassName());
                            if (function instanceof FunctionObject) {
                                try {
                                    ((FunctionObject)function).addAsConstructor((Scriptable)window, prototype3);
                                }
                                catch (Exception e) {
                                    if (!LOG.isWarnEnabled()) break block50;
                                    String newline = System.lineSeparator();
                                    LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype3.getClassName()));
                                }
                            }
                        }
                        ScriptableObject.defineProperty((Scriptable)window, (String)hostClassSimpleName, (Object)function, (int)2);
                        if (!hostClassSimpleName.equals(prototype3.getClassName())) {
                            if (prototypeProperty == UniqueTag.NOT_FOUND) {
                                ScriptableObject.deleteProperty((Scriptable)window, (String)prototype3.getClassName());
                            } else {
                                ScriptableObject.defineProperty((Scriptable)window, (String)prototype3.getClassName(), (Object)prototypeProperty, (int)2);
                            }
                        }
                    } else if (function instanceof FunctionObject) {
                        try {
                            ((FunctionObject)function).addAsConstructor((Scriptable)window, prototype3);
                        }
                        catch (Exception e) {
                            if (!LOG.isWarnEnabled()) break block51;
                            String newline = System.lineSeparator();
                            LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype3.getClassName()));
                        }
                    }
                }
                JavaScriptEngine.configureConstantsStaticPropertiesAndStaticFunctions(classConfiguration, (ScriptableObject)function);
            }
            window.setPrototype((Scriptable)prototypesPerJSName.get(Window.class.getSimpleName()));
            Scriptable objectPrototype = ScriptableObject.getObjectPrototype((Scriptable)window);
            for (Map.Entry entry : prototypesPerJSName.entrySet()) {
                String name = (String)entry.getKey();
                ClassConfiguration config = this.jsConfig_.getClassConfiguration(name);
                Scriptable prototype4 = (Scriptable)entry.getValue();
                if (!StringUtils.isEmpty((CharSequence)config.getExtendedClassName())) {
                    Scriptable parentPrototype = (Scriptable)prototypesPerJSName.get(config.getExtendedClassName());
                    prototype4.setPrototype(parentPrototype);
                    continue;
                }
                prototype4.setPrototype(objectPrototype);
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_WINDOW_ACTIVEXOBJECT_HIDDEN) && null != (scriptable = (Scriptable)prototypesPerJSName.get("ActiveXObject"))) {
                Method method = ActiveXObject.class.getDeclaredMethod("jsConstructor", Context.class, Object[].class, Function.class, Boolean.TYPE);
                HiddenFunctionObject functionObject = new HiddenFunctionObject("ActiveXObject", method, (Scriptable)window);
                try {
                    functionObject.addAsConstructor((Scriptable)window, scriptable);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block52;
                    String newline = System.lineSeparator();
                    LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + scriptable.getClassName()));
                }
            }
        }
        JavaScriptEngine.removePrototypeProperties((Scriptable)window, "String", "equals", "equalsIgnoreCase");
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_INCLUDES)) {
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "String", "includes");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_REPEAT)) {
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "String", "repeat");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_STARTS_ENDS_WITH)) {
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "String", "startsWith");
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "String", "endsWith");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.STRING_TRIM_LEFT_RIGHT)) {
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "String", "trimLeft");
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "String", "trimRight");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_FUNCTION_TOSOURCE)) {
            JavaScriptEngine.deleteProperties((Scriptable)window, "uneval");
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "Object", "toSource");
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "Array", "toSource");
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "Date", "toSource");
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "Function", "toSource");
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "Number", "toSource");
            JavaScriptEngine.removePrototypeProperties((Scriptable)window, "String", "toSource");
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_WINDOW_ACTIVEXOBJECT_HIDDEN)) {
            ((IdFunctionObject)ScriptableObject.getProperty((Scriptable)window, (String)"Object")).delete("assign");
            JavaScriptEngine.deleteProperties((Scriptable)window, "WeakSet");
        }
        JavaScriptEngine.deleteProperties((Scriptable)window, "isXMLName");
        NativeFunctionToStringFunction.installFix((Scriptable)window, webClient.getBrowserVersion());
        ScriptableObject scriptableObject = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)"Date");
        scriptableObject.defineFunctionProperties(new String[]{"toLocaleDateString", "toLocaleTimeString"}, DateCustom.class, 2);
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_OBJECT_GET_OWN_PROPERTY_SYMBOLS)) {
            ((ScriptableObject)ScriptableObject.getProperty((Scriptable)window, (String)"Object")).delete("getOwnPropertySymbols");
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_ARRAY_FROM)) {
            ScriptableObject scriptableObject2 = (ScriptableObject)ScriptRuntime.name((Context)context, (Scriptable)window, (String)"Array");
            scriptableObject2.defineFunctionProperties(new String[]{"from"}, ArrayCustom.class, 2);
        }
        ScriptableObject scriptableObject3 = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)"Number");
        scriptableObject3.defineFunctionProperties(new String[]{"toLocaleString"}, NumberCustom.class, 2);
        window.setPrototypes(prototypes, prototypesPerJSName);
        window.initialize(webWindow);
    }

    private static void defineConstructor(Window window, Scriptable prototype, ScriptableObject constructor) {
        block5: {
            String newline;
            block4: {
                constructor.setParentScope((Scriptable)window);
                try {
                    ScriptableObject.defineProperty((Scriptable)prototype, (String)"constructor", (Object)constructor, (int)7);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    newline = System.lineSeparator();
                    LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype.getClassName()));
                }
            }
            try {
                ScriptableObject.defineProperty((Scriptable)constructor, (String)"prototype", (Object)prototype, (int)7);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block5;
                newline = System.lineSeparator();
                LOG.warn((Object)("Error during JavaScriptEngine.init(WebWindow, Context)" + newline + e.getMessage() + newline + "prototype: " + prototype.getClassName()));
            }
        }
        window.defineProperty(constructor.getClassName(), constructor, 2);
    }

    private static void deleteProperties(Scriptable scope, String ... propertiesToDelete) {
        for (String property : propertiesToDelete) {
            scope.delete(property);
        }
    }

    private static void removePrototypeProperties(Scriptable scope, String className, String ... properties) {
        ScriptableObject prototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)scope, (String)className);
        for (String property : properties) {
            prototype.delete(property);
        }
    }

    public static HtmlUnitScriptable configureClass(ClassConfiguration config, Scriptable window, BrowserVersion browserVersion) throws InstantiationException, IllegalAccessException {
        HtmlUnitScriptable prototype = config.getHostClass().newInstance();
        prototype.setParentScope(window);
        prototype.setClassName(config.getClassName());
        JavaScriptEngine.configureConstantsPropertiesAndFunctions(config, prototype);
        return prototype;
    }

    private static void configureConstantsStaticPropertiesAndStaticFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        JavaScriptEngine.configureConstants(config, scriptable);
        JavaScriptEngine.configureStaticProperties(config, scriptable);
        JavaScriptEngine.configureStaticFunctions(config, scriptable);
    }

    private static void configureConstantsPropertiesAndFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        JavaScriptEngine.configureConstants(config, scriptable);
        JavaScriptEngine.configureProperties(config, scriptable);
        JavaScriptEngine.configureFunctions(config, scriptable);
    }

    private static void configureFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        boolean attributes = false;
        for (Map.Entry<String, Method> functionInfo : config.getFunctionEntries()) {
            String functionName = functionInfo.getKey();
            Method method = functionInfo.getValue();
            FunctionObject functionObject = new FunctionObject(functionName, (Member)method, (Scriptable)scriptable);
            scriptable.defineProperty(functionName, (Object)functionObject, 0);
        }
    }

    private static void configureConstants(ClassConfiguration config, ScriptableObject scriptable) {
        for (ClassConfiguration.ConstantInfo constantInfo : config.getConstants()) {
            scriptable.defineProperty(constantInfo.getName(), constantInfo.getValue(), constantInfo.getFlag());
        }
    }

    private static void configureProperties(ClassConfiguration config, ScriptableObject scriptable) {
        Map<String, ClassConfiguration.PropertyInfo> propertyMap = config.getPropertyMap();
        for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : propertyMap.entrySet()) {
            ClassConfiguration.PropertyInfo info = propertyEntry.getValue();
            Method readMethod = info.getReadMethod();
            Method writeMethod = info.getWriteMethod();
            scriptable.defineProperty(propertyEntry.getKey(), null, readMethod, writeMethod, 0);
        }
    }

    private static void configureStaticProperties(ClassConfiguration config, ScriptableObject scriptable) {
        for (Map.Entry<String, ClassConfiguration.PropertyInfo> propertyEntry : config.getStaticPropertyEntries()) {
            String propertyName = propertyEntry.getKey();
            Method readMethod = propertyEntry.getValue().getReadMethod();
            Method writeMethod = propertyEntry.getValue().getWriteMethod();
            boolean flag = false;
            scriptable.defineProperty(propertyName, null, readMethod, writeMethod, 0);
        }
    }

    private static void configureStaticFunctions(ClassConfiguration config, ScriptableObject scriptable) {
        for (Map.Entry<String, Method> staticfunctionInfo : config.getStaticFunctionEntries()) {
            String functionName = staticfunctionInfo.getKey();
            Method method = staticfunctionInfo.getValue();
            FunctionObject staticFunctionObject = new FunctionObject(functionName, (Member)method, (Scriptable)scriptable);
            scriptable.defineProperty(functionName, (Object)staticFunctionObject, 0);
        }
    }

    @Override
    public synchronized void registerWindowAndMaybeStartEventLoop(WebWindow webWindow) {
        if (this.webClient_ != null) {
            if (this.javaScriptExecutor_ == null) {
                this.javaScriptExecutor_ = BackgroundJavaScriptFactory.theFactory().createJavaScriptExecutor(this.webClient_);
            }
            this.javaScriptExecutor_.addWindow(webWindow);
        }
    }

    @Override
    public void shutdown() {
        this.webClient_ = null;
        if (this.javaScriptExecutor_ != null) {
            this.javaScriptExecutor_.shutdown();
            this.javaScriptExecutor_ = null;
        }
        if (this.postponedActions_ != null) {
            this.postponedActions_.remove();
        }
        if (this.javaScriptRunning_ != null) {
            this.javaScriptRunning_.remove();
        }
        this.holdPostponedActions_ = false;
    }

    @Override
    public Script compile(HtmlPage page, String sourceCode, String sourceName, int startLine) {
        Scriptable scope = JavaScriptEngine.getScope(page, null);
        return this.compile(page, scope, sourceCode, sourceName, startLine);
    }

    public Script compile(HtmlPage owningPage, Scriptable scope, final String sourceCode, final String sourceName, final int startLine) {
        WebAssert.notNull("sourceCode", sourceCode);
        if (LOG.isTraceEnabled()) {
            String newline = System.lineSeparator();
            LOG.trace((Object)("Javascript compile " + sourceName + newline + sourceCode + newline));
        }
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, owningPage){

            @Override
            public Object doRun(Context cx) {
                return cx.compileString(sourceCode, sourceName, startLine, null);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return sourceCode;
            }
        };
        return (Script)this.getContextFactory().call(action);
    }

    @Override
    public Object execute(HtmlPage page, String sourceCode, String sourceName, int startLine) {
        Script script = this.compile(page, sourceCode, sourceName, startLine);
        if (script == null) {
            return null;
        }
        return this.execute(page, script);
    }

    @Override
    public Object execute(HtmlPage page, Script script) {
        Scriptable scope = JavaScriptEngine.getScope(page, null);
        return this.execute(page, scope, script);
    }

    public Object execute(HtmlPage page, final Scriptable scope, final Script script) {
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, page){

            @Override
            public Object doRun(Context cx) {
                return script.exec(cx, scope);
            }

            @Override
            protected String getSourceCode(Context cx) {
                return null;
            }
        };
        return this.getContextFactory().call(action);
    }

    public Object callFunction(HtmlPage page, Function javaScriptFunction, Scriptable thisObject, Object[] args, DomNode node) {
        Scriptable scope = JavaScriptEngine.getScope(page, node);
        return this.callFunction(page, javaScriptFunction, scope, thisObject, args);
    }

    public Object callFunction(HtmlPage page, final Function function, final Scriptable scope, final Scriptable thisObject, final Object[] args) {
        HtmlUnitContextAction action = new HtmlUnitContextAction(scope, page){

            @Override
            public Object doRun(Context cx) {
                if (ScriptRuntime.hasTopCall((Context)cx)) {
                    return function.call(cx, scope, thisObject, args);
                }
                return ScriptRuntime.doTopCall((Callable)function, (Context)cx, (Scriptable)scope, (Scriptable)thisObject, (Object[])args, (boolean)cx.isStrictMode());
            }

            @Override
            protected String getSourceCode(Context cx) {
                return cx.decompileFunction(function, 2);
            }
        };
        return this.getContextFactory().call(action);
    }

    private static Scriptable getScope(HtmlPage page, DomNode node) {
        if (node != null) {
            return (Scriptable)node.getScriptableObject();
        }
        return (Scriptable)page.getEnclosingWindow().getScriptableObject();
    }

    @Override
    public boolean isScriptRunning() {
        return Boolean.TRUE.equals(this.javaScriptRunning_.get());
    }

    private void doProcessPostponedActions() {
        this.holdPostponedActions_ = false;
        WebClient webClient = this.getWebClient();
        if (webClient == null) {
            this.postponedActions_.set(null);
            return;
        }
        try {
            webClient.loadDownloadedResponses();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<PostponedAction> actions = this.postponedActions_.get();
        if (actions != null) {
            this.postponedActions_.set(null);
            try {
                for (PostponedAction action : actions) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Processing PostponedAction " + action));
                    }
                    if (!action.isStillAlive()) continue;
                    action.execute();
                }
            }
            catch (Exception e) {
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
    }

    @Override
    public void addPostponedAction(PostponedAction action) {
        List<PostponedAction> actions = this.postponedActions_.get();
        if (actions == null) {
            actions = new ArrayList<PostponedAction>();
            this.postponedActions_.set(actions);
        }
        actions.add(action);
    }

    protected void handleJavaScriptException(ScriptException scriptException, boolean triggerOnError) {
        Window w;
        WebWindow window;
        HtmlPage page = scriptException.getPage();
        if (triggerOnError && page != null && (window = page.getEnclosingWindow()) != null && (w = (Window)window.getScriptableObject()) != null) {
            try {
                w.triggerOnError(scriptException);
            }
            catch (Exception e) {
                this.handleJavaScriptException(new ScriptException(page, e, null), false);
            }
        }
        this.getWebClient().getJavaScriptErrorListener().scriptException(page, scriptException);
        if (this.getWebClient().getOptions().isThrowExceptionOnScriptError()) {
            throw scriptException;
        }
        LOG.info((Object)"Caught script exception", (Throwable)scriptException);
    }

    @Override
    public void holdPosponedActions() {
        this.holdPostponedActions_ = true;
    }

    @Override
    public void processPostponedActions() {
        this.doProcessPostponedActions();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }

    private void initTransientFields() {
        this.javaScriptRunning_ = new ThreadLocal();
        this.postponedActions_ = new ThreadLocal();
        this.holdPostponedActions_ = false;
    }

    public Class<? extends HtmlUnitScriptable> getJavaScriptClass(Class<?> c) {
        return this.jsConfig_.getDomJavaScriptMapping().get(c);
    }

    @Override
    public JavaScriptConfiguration getJavaScriptConfiguration() {
        return this.jsConfig_;
    }

    @Override
    public long getJavaScriptTimeout() {
        return this.getContextFactory().getTimeout();
    }

    @Override
    public void setJavaScriptTimeout(long timeout) {
        this.getContextFactory().setTimeout(timeout);
    }

    private abstract class HtmlUnitContextAction
    implements ContextAction<Object> {
        private final Scriptable scope_;
        private final HtmlPage page_;

        HtmlUnitContextAction(Scriptable scope, HtmlPage page) {
            this.scope_ = scope;
            this.page_ = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object run(Context cx) {
            Boolean javaScriptAlreadyRunning = (Boolean)JavaScriptEngine.this.javaScriptRunning_.get();
            JavaScriptEngine.this.javaScriptRunning_.set(Boolean.TRUE);
            try {
                Object response;
                Object object;
                ArrayDeque<Scriptable> stack = (ArrayDeque<Scriptable>)cx.getThreadLocal((Object)JavaScriptEngine.KEY_STARTING_SCOPE);
                if (null == stack) {
                    stack = new ArrayDeque<Scriptable>();
                    cx.putThreadLocal((Object)JavaScriptEngine.KEY_STARTING_SCOPE, stack);
                }
                stack.push(this.scope_);
                try {
                    cx.putThreadLocal((Object)JavaScriptEngine.KEY_STARTING_PAGE, (Object)this.page_);
                    object = this.page_;
                    synchronized (object) {
                        block19: {
                            if (this.page_ == this.page_.getEnclosingWindow().getEnclosedPage()) break block19;
                            Object var6_7 = null;
                            return var6_7;
                        }
                        response = this.doRun(cx);
                    }
                }
                finally {
                    stack.pop();
                }
                if (!JavaScriptEngine.this.holdPostponedActions_) {
                    JavaScriptEngine.this.doProcessPostponedActions();
                }
                object = response;
                return object;
            }
            catch (Exception e) {
                JavaScriptEngine.this.handleJavaScriptException(new ScriptException(this.page_, e, this.getSourceCode(cx)), true);
                Object var4_9 = null;
                return var4_9;
            }
            catch (TimeoutError e) {
                JavaScriptEngine.this.getWebClient().getJavaScriptErrorListener().timeoutError(this.page_, e.getAllowedTime(), e.getExecutionTime());
                if (JavaScriptEngine.this.getWebClient().getOptions().isThrowExceptionOnScriptError()) {
                    throw new RuntimeException(e);
                }
                LOG.info((Object)"Caught script timeout error", (Throwable)e);
                Object var4_10 = null;
                return var4_10;
            }
            finally {
                JavaScriptEngine.this.javaScriptRunning_.set(javaScriptAlreadyRunning);
            }
        }

        protected abstract Object doRun(Context var1);

        protected abstract String getSourceCode(Context var1);
    }
}

