/*
 * Decompiled with CFR 0.152.
 */
package flexjson.factories;

import flexjson.JSONException;
import flexjson.ObjectBinder;
import flexjson.ObjectFactory;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateObjectFactory
implements ObjectFactory {
    List<DateFormat> dateFormats;

    public DateObjectFactory() {
        this.dateFormats = new ArrayList<DateFormat>();
        this.dateFormats.add(DateFormat.getDateTimeInstance());
        this.dateFormats.add(DateFormat.getDateTimeInstance(1, 1));
        this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2));
        this.dateFormats.add(DateFormat.getDateTimeInstance(3, 3));
        this.dateFormats.add(new SimpleDateFormat("EEE MMM d hh:mm:ss a z yyyy"));
        this.dateFormats.add(new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"));
        this.dateFormats.add(new SimpleDateFormat("MM/dd/yy hh:mm:ss a"));
        this.dateFormats.add(new SimpleDateFormat("MM/dd/yy"));
    }

    public DateObjectFactory(List<DateFormat> dateFormats) {
        this.dateFormats = dateFormats;
    }

    @Override
    public Object instantiate(ObjectBinder context, Object value, Type targetType, Class targetClass) {
        try {
            if (value instanceof Double) {
                Date d = (Date)((Class)targetType).newInstance();
                d.setTime(((Double)value).longValue());
                return d;
            }
            if (value instanceof Long) {
                Date d = (Date)((Class)targetType).newInstance();
                d.setTime((Long)value);
                return d;
            }
            for (DateFormat format : this.dateFormats) {
                try {
                    return format.parse(value.toString());
                }
                catch (ParseException e) {
                }
            }
            throw new JSONException(String.format("%s:  Parsing date %s was not recognized as a date format", context.getCurrentPath(), value));
        }
        catch (IllegalAccessException e) {
            throw new JSONException(String.format("%s:  Error encountered trying to instantiate %s", context.getCurrentPath(), ((Class)targetType).getName()), e);
        }
        catch (InstantiationException e) {
            throw new JSONException(String.format("%s:  Error encountered trying to instantiate %s.  Make sure there is a public no-arg constructor.", context.getCurrentPath(), ((Class)targetType).getName()), e);
        }
    }
}

