/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.mdiy.biz.impl;

import com.mingsoft.base.biz.impl.BaseBizImpl;
import com.mingsoft.base.dao.IBaseDao;
import com.mingsoft.mdiy.biz.IFormBiz;
import com.mingsoft.mdiy.dao.IFormDao;
import com.mingsoft.mdiy.dao.IFormFieldDao;
import com.mingsoft.mdiy.entity.FormEntity;
import com.mingsoft.mdiy.entity.FormFieldEntity;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormBizImpl
extends BaseBizImpl
implements IFormBiz {
    private static final String FORM_ID = "fromID";
    private static final String DATE = "date";
    private static final String ID = "id";
    @Autowired
    private IFormDao formDao;
    @Autowired
    private IFormFieldDao formFieldDao;

    protected IBaseDao getDao() {
        return this.formDao;
    }

    public void saveDiyFormData(int formId, Map params) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(Integer.valueOf(formId));
        if (dfe == null) {
            return;
        }
        String tableName = dfe.getFormTableName();
        List filedList = this.formFieldDao.queryByDiyFormId(formId);
        if (filedList == null) {
            return;
        }
        Map values = this.builderSqlMap(filedList, params);
        values.put(FORM_ID, formId);
        values.put(DATE, new Date());
        this.formFieldDao.insertBySQL(tableName, values);
    }

    public Map queryDiyFormData(int diyFormId, int appId, PageUtil page) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(Integer.valueOf(diyFormId));
        if (dfe != null) {
            List fieldList = this.formFieldDao.queryByDiyFormId(diyFormId);
            ArrayList fields = new ArrayList();
            for (int i = 0; i < fieldList.size(); ++i) {
                HashMap<String, String> field = new HashMap<String, String>();
                field.put(((FormFieldEntity)fieldList.get(i)).getDiyFormFieldFieldName(), ((FormFieldEntity)fieldList.get(i)).getDiyFormFieldTipsName());
                fields.add(field);
            }
            HashMap<String, Integer> wheres = new HashMap<String, Integer>();
            wheres.put(FORM_ID, diyFormId);
            List list = this.formDao.queryBySQL(dfe.getFormTableName(), null, wheres, Integer.valueOf(page.getPageSize() * page.getPageNo()), Integer.valueOf(page.getPageSize()), ID);
            HashMap<String, List> r = new HashMap<String, List>();
            r.put("fields", fieldList);
            r.put("list", list);
            return r;
        }
        return null;
    }

    public void deleteQueryDiyFormData(int id, int diyFormId) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(Integer.valueOf(diyFormId));
        HashMap<String, Integer> wheres = new HashMap<String, Integer>();
        wheres.put(FORM_ID, diyFormId);
        wheres.put(ID, id);
        this.formDao.deleteBySQL(dfe.getFormTableName(), wheres);
    }

    public int countDiyFormData(int diyFormId, int appId) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(Integer.valueOf(diyFormId));
        HashMap<String, Integer> wheres = new HashMap<String, Integer>();
        wheres.put(FORM_ID, diyFormId);
        return this.formDao.countBySQL(dfe.getFormTableName(), wheres);
    }

    private Map builderSqlMap(List listField, Map params) {
        HashMap mapParams = new HashMap();
        for (int i = 0; i < listField.size(); ++i) {
            FormFieldEntity field = (FormFieldEntity)listField.get(i);
            String fieldName = field.getDiyFormFieldFieldName();
            if (StringUtil.isBlank(params.get(fieldName))) {
                mapParams.put(fieldName, null);
                continue;
            }
            mapParams.put(fieldName, params.get(fieldName));
        }
        return mapParams;
    }

    public void createDiyFormTable(String table, Map<Object, List> fileds) {
        this.formDao.createDiyFormTable(table, fileds);
    }
}

