/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.mdiy.action;

import com.mingsoft.base.constant.e.TableEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.mdiy.action.BaseAction;
import com.mingsoft.mdiy.biz.IFormBiz;
import com.mingsoft.mdiy.biz.IFormFieldBiz;
import com.mingsoft.mdiy.constant.e.DiyFormFieldEnum;
import com.mingsoft.mdiy.entity.FormEntity;
import com.mingsoft.mdiy.entity.FormFieldEntity;
import com.mingsoft.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="diyFormField")
@RequestMapping(value={"/${managerPath}/mdiy/form/formField"})
public class FormFieldAction
extends BaseAction {
    private static final String FIELD_ID = "id";
    private static final String FIELD_DATE = "date";
    private static final String FIELD_FORMID = "formId";
    @Autowired
    private IFormFieldBiz diyFormFieldBiz;
    @Autowired
    private IFormBiz diyFormBiz;

    @RequestMapping(value={"/list"})
    @ResponseBody
    public Map list(int diyFormId, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List fieldList = this.diyFormFieldBiz.queryByDiyFormId(diyFormId);
        map.put("fieldList", fieldList);
        Map fieldType = DiyFormFieldEnum.toMap();
        map.put("fieldType", fieldType);
        map.put("fieldNum", fieldType.size());
        return map;
    }

    @RequestMapping(value={"/{diyFormId}/save"})
    @ResponseBody
    public void save(@ModelAttribute FormFieldEntity diyFormfield, @PathVariable int diyFormId, HttpServletResponse response) {
        FormEntity diyForm = (FormEntity)this.diyFormBiz.getEntity(diyFormId);
        if (diyForm == null) {
            this.outJson(response, null, false, this.getResString("err.not.exist", new String[]{this.getResString("diy.form")}));
            return;
        }
        if (!StringUtil.checkLength((String)diyFormfield.getDiyFormFieldTipsName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("diy.form.tips.name"), "1", "20"}));
            return;
        }
        if (!StringUtil.checkLength((String)diyFormfield.getDiyFormFieldFieldName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("diy.form.table.column.name"), "1", "20"}));
            return;
        }
        if (this.diyFormFieldBiz.getByFieldName(Integer.valueOf(diyFormfield.getDiyFormFieldFormId()), diyFormfield.getDiyFormFieldFieldName()) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("diy.form.table.column.name")}));
            return;
        }
        HashMap<String, String> fileds = new HashMap<String, String>();
        fileds.put("fieldName", diyFormfield.getDiyFormFieldFieldName());
        fileds.put("fieldType", diyFormfield.getDiyFormFieldColumnType());
        fileds.put("default", diyFormfield.getDiyFormFieldDefault());
        this.diyFormFieldBiz.alterTable(diyForm.getFormTableName(), fileds, TableEnum.ALTER_ADD);
        this.diyFormFieldBiz.saveEntity((BaseEntity)diyFormfield);
        this.outJson(response, null, true, null);
    }

    @RequestMapping(value={"/{diyFormFieldId}/edit"})
    @ResponseBody
    public Map edit(@PathVariable int diyFormFieldId, HttpServletRequest request) {
        HashMap<String, FormFieldEntity> mode = new HashMap<String, FormFieldEntity>();
        FormFieldEntity diyFormfield = (FormFieldEntity)this.diyFormFieldBiz.getEntity(diyFormFieldId);
        mode.put("diyFormfield", diyFormfield);
        return mode;
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute FormFieldEntity diyFormfield, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)diyFormfield.getDiyFormFieldTipsName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldTipsName"), "1", "20"}));
            return;
        }
        if (!StringUtil.checkLength((String)diyFormfield.getDiyFormFieldFieldName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldFieldName"), "1", "20"}));
            return;
        }
        FormEntity diyForm = (FormEntity)this.diyFormBiz.getEntity(diyFormfield.getDiyFormFieldFormId());
        FormFieldEntity oldField = (FormFieldEntity)this.diyFormFieldBiz.getEntity(diyFormfield.getDiyFormFieldId());
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fieldOldName", oldField.getDiyFormFieldFieldName());
        fields.put("fieldName", diyFormfield.getDiyFormFieldFieldName());
        fields.put("fieldType", diyFormfield.getDiyFormFieldColumnType());
        if (diyForm == null) {
            this.outJson(response, null, false, this.getResString("err.not.exist"));
            return;
        }
        this.diyFormFieldBiz.alterTable(diyForm.getFormTableName(), fields, "modify");
        this.diyFormFieldBiz.updateEntity((BaseEntity)diyFormfield);
        this.outJson(response, null, true, null);
    }

    @RequestMapping(value={"/{diyFormFieldFieldName}/checkFieldNameExist"})
    @ResponseBody
    public boolean checkFieldNameExist(@PathVariable String diyFormFieldFieldName, HttpServletRequest request) {
        int diyFormFieldFormId = 1;
        if (request.getParameter("diyFormFieldFormId") != null) {
            diyFormFieldFormId = Integer.parseInt(request.getParameter("diyFormFieldFormId"));
        }
        return diyFormFieldFieldName.equalsIgnoreCase(FIELD_ID) || diyFormFieldFieldName.equalsIgnoreCase(FIELD_DATE) || diyFormFieldFieldName.equalsIgnoreCase(FIELD_FORMID) || this.diyFormFieldBiz.getByFieldName(Integer.valueOf(diyFormFieldFormId), diyFormFieldFieldName) != null;
    }

    @RequestMapping(value={"/{fieldId}/delete"})
    public void delete(@PathVariable int fieldId, HttpServletRequest request, HttpServletResponse response) {
        FormFieldEntity diyFormField = (FormFieldEntity)this.diyFormFieldBiz.getEntity(fieldId);
        if (diyFormField == null) {
            this.outJson(response, null, false, this.getResString("err.not.exist", new String[]{this.getResString("diy.form.field")}));
            return;
        }
        FormEntity diyForm = (FormEntity)this.diyFormBiz.getEntity(diyFormField.getDiyFormFieldFormId());
        if (diyForm == null) {
            this.outJson(response, null, false, this.getResString("err.not.exist", new String[]{this.getResString("diy.form")}));
            return;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fieldName", diyFormField.getDiyFormFieldFieldName());
        this.diyFormFieldBiz.alterTable(diyForm.getFormTableName(), fields, "drop");
        this.diyFormFieldBiz.deleteEntity(diyFormField.getDiyFormFieldId());
        this.outJson(response, null, true);
    }
}

