/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.mdiy.action;

import com.mingsoft.base.constant.e.TableEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.biz.IColumnBiz;
import com.mingsoft.basic.entity.ColumnEntity;
import com.mingsoft.mdiy.action.BaseAction;
import com.mingsoft.mdiy.biz.IContentModelBiz;
import com.mingsoft.mdiy.biz.IContentModelFieldBiz;
import com.mingsoft.mdiy.constant.e.ContentModelFieldEnum;
import com.mingsoft.mdiy.entity.ContentModelEntity;
import com.mingsoft.mdiy.entity.ContentModelFieldEntity;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/mdiy/contentModel/contentModelField"})
public class ContentModelFieldAction
extends BaseAction {
    @Autowired
    private IContentModelFieldBiz contentModelFieldBiz;
    @Autowired
    private IContentModelBiz contentModelBiz;
    @Autowired
    private IColumnBiz columnBiz;

    @RequestMapping(value={"/{contentModelId}/list"})
    public String list(@PathVariable int contentModelId, HttpServletRequest request, ModelMap model, HttpServletResponse response) {
        List list = this.contentModelFieldBiz.queryListByCmid(contentModelId);
        model.put((Object)"fieldTypes", (Object)ContentModelFieldEnum.toMap());
        model.put((Object)"contentModelId", (Object)contentModelId);
        model.addAttribute("contentModelFieldList", (Object)list);
        return this.view("/mdiy/content_model/content_model_field_list");
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public void save(@ModelAttribute ContentModelFieldEntity field, HttpServletRequest request, HttpServletResponse response) {
        ContentModelEntity contentModel = (ContentModelEntity)this.contentModelBiz.getEntity(field.getFieldCmid());
        if (!StringUtil.checkLength((String)field.getFieldTipsName(), (int)1, (int)30)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.field.tips.name"), "1", "30"}));
            return;
        }
        if (!StringUtil.checkLength((String)field.getFieldFieldName(), (int)1, (int)30)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.field.column.ame"), "1", "30"}));
            return;
        }
        if (this.contentModelFieldBiz.getEntityByCmId(field.getFieldCmid(), field.getFieldFieldName()) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("content.model.field")}));
            return;
        }
        this.contentModelFieldBiz.saveEntity((BaseEntity)field);
        HashMap<String, String> fileds = new HashMap<String, String>();
        fileds.put("fieldName", field.getFieldFieldName());
        fileds.put("fieldType", field.getFieldColumnType());
        fileds.put("default", field.getFieldDefault());
        this.contentModelFieldBiz.alterTable(contentModel.getCmTableName(), fileds, TableEnum.ALTER_ADD);
        this.outJson(response, null, true, null);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public void delete(HttpServletRequest request, HttpServletResponse response) {
        String fieldIds = request.getParameter("fieldId");
        if (!StringUtil.isBlank((String)fieldIds) && StringUtil.isIntegers((String[])fieldIds.split(","))) {
            int[] ids = StringUtil.stringsToInts((String[])fieldIds.split(","));
            for (int i = 0; i < ids.length; ++i) {
                ContentModelFieldEntity field = (ContentModelFieldEntity)this.contentModelFieldBiz.getEntity(ids[i]);
                this.contentModelFieldBiz.deleteEntity(ids[i]);
                ContentModelEntity contentModel = (ContentModelEntity)this.contentModelBiz.getEntity(field.getFieldCmid());
                if (contentModel == null) continue;
                HashMap<String, String> fields = new HashMap<String, String>();
                fields.put("fieldName", field.getFieldFieldName());
                this.contentModelFieldBiz.alterTable(contentModel.getCmTableName(), fields, TableEnum.ALTER_DROP);
            }
            this.outJson(response, true);
        }
    }

    @RequestMapping(value={"/{filedId}/edit"})
    @ResponseBody
    public void edit(@PathVariable int filedId, HttpServletResponse response) {
        ContentModelFieldEntity contentModelField = (ContentModelFieldEntity)this.contentModelFieldBiz.getEntity(filedId);
        this.outJson(response, (BaseEntity)contentModelField);
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute ContentModelFieldEntity contentModelFieldEntity, HttpServletRequest request, HttpServletResponse response) {
        this.contentModelFieldBiz.updateEntity((BaseEntity)contentModelFieldEntity);
        this.outJson(response, true);
    }

    @RequestMapping(value={"/{columnId}/queryField"})
    public String queryField(@PathVariable int columnId, ModelMap model, HttpServletRequest request) {
        ColumnEntity column = (ColumnEntity)this.columnBiz.getEntity(columnId);
        if (column != null) {
            ContentModelEntity contentModel;
            int fieldCmid = column.getColumnContentModelId();
            List listField = this.contentModelFieldBiz.queryListByCmid(fieldCmid);
            int basicId = this.getInt(request, "basicId");
            if (basicId != 0 && (contentModel = (ContentModelEntity)this.contentModelBiz.getEntity(fieldCmid)) != null) {
                ArrayList<String> listFieldName = new ArrayList<String>();
                for (int i = 0; i < listField.size(); ++i) {
                    ContentModelFieldEntity field = (ContentModelFieldEntity)listField.get(i);
                    listFieldName.add(field.getFieldFieldName());
                }
                HashMap<String, Integer> where = new HashMap<String, Integer>();
                where.put("basicId", basicId);
                List fieldLists = this.contentModelFieldBiz.queryBySQL(contentModel.getCmTableName(), listFieldName, where);
                if (fieldLists != null && fieldLists.size() > 0) {
                    Map filedValue = (Map)fieldLists.get(0);
                    model.addAttribute("filedValue", (Object)filedValue);
                }
            }
            model.addAttribute("listField", (Object)listField);
            model.addAttribute("appId", (Object)this.getAppId(request));
        }
        return this.view("/mdiy/content_model/content_model_field");
    }
}

