/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.servlet;

import com.mingsoft.basic.servlet.BaseServlet;
import com.mingsoft.util.FileUtil;
import com.mingsoft.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;

@WebServlet(urlPatterns={"/upload"})
public class UploadServlet
extends BaseServlet {
    private static final int BUFFER_SIZE = 102400;
    private static final String TEMP = "/temp";

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html;charset=utf-8");
        Integer chunk = 0;
        Integer chunks = 0;
        PrintWriter out = res.getWriter();
        String uploadFolder = this.getServletContext().getRealPath("/");
        String isRename = req.getParameter("isRename");
        String _tempPath = req.getServletContext().getRealPath(TEMP);
        FileUtil.createFolder((String)_tempPath);
        File tempPath = new File(_tempPath);
        int maxSize = 1000000;
        String deniedFile = ".exe,.com,.cgi,.asp";
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(4096);
        factory.setRepository(tempPath);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        String uploadPath = "";
        try {
            List fileItems = upload.parseRequest(req);
            Iterator iter = fileItems.iterator();
            String regExp = ".+\\\\(.+)$";
            String[] errorType = deniedFile.split(",");
            String fileName = "";
            while (iter.hasNext()) {
                FileItem item = (FileItem)iter.next();
                InputStream input = item.getInputStream();
                String fieldName = item.getFieldName();
                if (fieldName.equals("uploadPath")) {
                    uploadPath = Streams.asString((InputStream)input) + File.separator;
                    uploadFolder = uploadFolder + uploadPath;
                    this.logger.info((Object)("uploadPath:" + uploadFolder));
                    continue;
                }
                if (fieldName.equals("isRename")) {
                    isRename = Streams.asString((InputStream)input);
                    this.logger.info((Object)("isRename:" + isRename));
                    continue;
                }
                if (fieldName.equals("maxSize")) {
                    maxSize = Integer.parseInt(item.getString()) * 0x100000;
                    this.logger.info((Object)("maxSize:" + maxSize));
                    continue;
                }
                if (fieldName.equals("allowedFile")) {
                    String allowedFile = item.getString();
                    this.logger.info((Object)("allowedFile:" + allowedFile));
                    continue;
                }
                if (fieldName.equals("deniedFile")) {
                    this.logger.info((Object)("deniedFile:" + deniedFile));
                    deniedFile = item.getString();
                    continue;
                }
                if ("chunk".equals(fieldName)) {
                    chunk = Integer.valueOf(Streams.asString((InputStream)input));
                    this.logger.info((Object)("chunk:" + chunk));
                    continue;
                }
                if ("chunks".equals(fieldName)) {
                    chunks = Integer.valueOf(Streams.asString((InputStream)input));
                    this.logger.info((Object)("chunks:" + chunks));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    fileName = new String(item.get(), "UTF-8");
                    this.logger.info((Object)("name:" + fileName));
                    continue;
                }
                if (item.isFormField()) continue;
                if (StringUtil.isBlank((String)fileName)) {
                    fileName = item.getName();
                }
                long size = item.getSize();
                if ((fileName == null || fileName.equals("")) && size == 0L) continue;
                try {
                    String _fileName;
                    upload.setSizeMax((long)maxSize);
                    String folder = uploadFolder + File.separator + TEMP;
                    FileUtil.createFolder((String)folder);
                    File destFile = new File(folder, fileName);
                    if (chunk == 0 && destFile.exists()) {
                        destFile.delete();
                        destFile = new File(folder, fileName);
                    }
                    this.appendFile(input, destFile);
                    if (chunk == chunks - 1) {
                        _fileName = fileName;
                        if (StringUtil.isBlank((String)isRename) || Boolean.parseBoolean(isRename)) {
                            _fileName = System.currentTimeMillis() + fileName.substring(fileName.indexOf("."));
                            destFile.renameTo(new File(uploadFolder, _fileName));
                        } else {
                            destFile.renameTo(new File(uploadFolder, _fileName));
                        }
                        this.logger.info((Object)"\u4e0a\u4f20\u5b8c\u6210");
                        out.print(uploadPath + File.separator + _fileName);
                        new File(folder).delete();
                    } else if (chunks == 0) {
                        _fileName = fileName;
                        if (StringUtil.isBlank((String)isRename) || Boolean.parseBoolean(isRename)) {
                            _fileName = System.currentTimeMillis() + fileName.substring(fileName.indexOf("."));
                        }
                        destFile.renameTo(new File(uploadFolder, _fileName));
                        new File(folder).delete();
                        out.print(uploadPath + File.separator + _fileName);
                        this.logger.info((Object)"\u4e0a\u4f20\u5b8c\u6210");
                    } else {
                        this.logger.info((Object)("\u8fd8\u5269[" + (chunks - 1 - chunk) + "]\u4e2a\u5757\u6587\u4ef6"));
                    }
                    this.logger.debug((Object)("upload file ok return path " + uploadFolder + fileName));
                    try {
                        if (null != input) {
                            input.close();
                        }
                        if (null == out) continue;
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        this.logger.error((Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    this.logger.debug((Object)e);
                }
            }
        }
        catch (FileUploadException e) {
            this.logger.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFile(InputStream in, File destFile) {
        OutputStream out = null;
        try {
            out = destFile.exists() ? new BufferedOutputStream(new FileOutputStream(destFile, true), 102400) : new BufferedOutputStream(new FileOutputStream(destFile), 102400);
            in = new BufferedInputStream(in, 102400);
            int len = 0;
            byte[] buffer = new byte[102400];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
                if (null != out) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage());
            }
        }
    }
}

