/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.biz.IColumnBiz;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.SessionConstEnum;
import com.mingsoft.basic.entity.CategoryEntity;
import com.mingsoft.basic.entity.ColumnEntity;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="basicColumnAction")
@RequestMapping(value={"/${managerPath}/column"})
public class ColumnAction
extends BaseAction {
    @Autowired
    private IColumnBiz columnBiz;
    @Autowired
    private ICategoryBiz categoryBiz;
    @Autowired
    private IModelBiz modelBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return this.view("/column/index");
    }

    @RequestMapping(value={"/add"})
    public String add(HttpServletRequest request, ModelMap model) {
        ManagerEntity managerSession = (ManagerEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int appId = this.getAppId(request);
        List list = this.columnBiz.queryAll(appId, this.getModelCodeId(request));
        ColumnEntity columnSuper = new ColumnEntity();
        model.addAttribute("appId", (Object)appId);
        model.addAttribute("columnSuper", (Object)columnSuper);
        model.addAttribute("column", (Object)new ColumnEntity());
        model.addAttribute("listColumn", (Object)com.alibaba.fastjson.JSONArray.toJSONString((Object)list));
        return this.view("/column/form");
    }

    private boolean checkForm(ColumnEntity column, HttpServletResponse response) {
        if (StringUtil.isBlank((String)column.getCategoryTitle())) {
            this.outJson(response, (BaseEnum)ModelCode.COLUMN, false, this.getResString("err.empty", new String[]{this.getResString("categoryTitle")}));
            return false;
        }
        if (!StringUtil.checkLength((String)column.getCategoryTitle(), (int)1, (int)31)) {
            this.outJson(response, (BaseEnum)ModelCode.COLUMN, false, this.getResString("err.length", new String[]{this.getResString("categoryTitle"), "1", "30"}));
            return false;
        }
        if (StringUtil.isBlank((Object)column.getColumnType())) {
            this.outJson(response, (BaseEnum)ModelCode.COLUMN, false, this.getResString("err.empty", new String[]{this.getResString("columnType")}));
            return false;
        }
        if (StringUtil.checkLength((String)column.getColumnDescrip(), (int)0, (int)500)) {
            column.setColumnDescrip(StringUtil.subString((String)column.getColumnDescrip(), (int)500));
        }
        if (StringUtil.checkLength((String)column.getColumnKeyword(), (int)0, (int)500)) {
            column.setColumnKeyword(StringUtil.subString((String)column.getColumnKeyword(), (int)500));
        }
        return true;
    }

    private void columnPath(HttpServletRequest request, ColumnEntity column) {
        String columnPath = "";
        String file = this.getRealPath(request, null) + "html" + File.separator + column.getAppId();
        String delFile = "";
        column = (ColumnEntity)this.columnBiz.getEntity(column.getCategoryId());
        delFile = file + column.getColumnPath();
        if (!StringUtil.isBlank((String)delFile)) {
            File delFileName = new File(delFile);
            delFileName.delete();
        }
        if (column.getCategoryCategoryId() == 0) {
            column.setColumnPath(File.separator + column.getCategoryId());
            file = file + File.separator + column.getCategoryId();
        } else {
            List list = this.columnBiz.queryParentColumnByColumnId(column.getCategoryId());
            if (!StringUtil.isBlank((Object)list)) {
                String temp = "";
                for (int i = list.size() - 1; i >= 0; --i) {
                    ColumnEntity entity = (ColumnEntity)list.get(i);
                    columnPath = columnPath + File.separator + entity.getCategoryId();
                    temp = temp + File.separator + entity.getCategoryId();
                }
                column.setColumnPath(columnPath + File.separator + column.getCategoryId());
                file = file + temp + File.separator + column.getCategoryId();
            }
        }
        this.columnBiz.updateEntity((BaseEntity)column);
        File fileName = new File(file);
        fileName.mkdir();
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public void delete(HttpServletResponse response, HttpServletRequest request) {
        int[] ids = BasicUtil.getInts((String)"ids", (String)",");
        for (int i = 0; i < ids.length; ++i) {
            this.columnBiz.deleteCategory(ids[i]);
        }
        this.outJson(response, true);
    }

    @RequestMapping(value={"/{columnId}/edit"})
    public String edit(@PathVariable int columnId, HttpServletRequest request, ModelMap model) {
        ManagerEntity managerSession = (ManagerEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int appId = this.getAppId(request);
        List list = new ArrayList();
        list = this.columnBiz.queryAll(appId, this.getModelCodeId(request));
        ColumnEntity column = (ColumnEntity)this.columnBiz.getEntity(columnId);
        model.addAttribute("appId", (Object)appId);
        model.addAttribute("column", (Object)column);
        model.addAttribute("columnc", (Object)column.getCategoryId());
        ColumnEntity columnSuper = new ColumnEntity();
        if (column.getCategoryCategoryId() != 0) {
            columnSuper = (ColumnEntity)this.columnBiz.getEntity(column.getCategoryCategoryId());
        }
        model.addAttribute("columnSuper", (Object)columnSuper);
        model.addAttribute("listColumn", (Object)com.alibaba.fastjson.JSONArray.toJSONString(list));
        return this.view("/column/form");
    }

    @RequestMapping(value={"/list"})
    public void list(@ModelAttribute ColumnEntity column, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        int websiteId = this.getAppId(request);
        List list = this.columnBiz.queryAll(websiteId, this.getModelCodeId(request));
        EUListBean _list = new EUListBean(list, list.size());
        this.outJson(response, (Object)JSONArray.toJSONString((Object)_list, (SerializeFilter[])new SerializeFilter[0]));
    }

    @RequestMapping(value={"/save"})
    public void save(@ModelAttribute ColumnEntity column, HttpServletRequest request, HttpServletResponse response) {
        if (!this.checkForm(column, response)) {
            return;
        }
        column.setCategoryAppId(this.getAppId(request));
        column.setAppId(BasicUtil.getAppId());
        column.setCategoryManagerId(this.getManagerBySession(request).getManagerId());
        column.setCategoryDateTime(new Timestamp(System.currentTimeMillis()));
        column.setCategoryModelId(this.getModelCodeId(request));
        if (column.getColumnType() == ColumnEntity.ColumnTypeEnum.COLUMN_TYPE_COVER.toInt()) {
            column.setColumnListUrl(null);
        }
        this.columnBiz.saveCategory((CategoryEntity)column);
        this.columnPath(request, column);
        this.outJson(response, (BaseEnum)ModelCode.COLUMN, true, null, (Object)com.alibaba.fastjson.JSONArray.toJSONString((Object)column.getCategoryId()));
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute ColumnEntity column, HttpServletRequest request, HttpServletResponse response) {
        int websiteId = this.getAppId(request);
        if (!this.checkForm(column, response)) {
            return;
        }
        if (column.getColumnType() == ColumnEntity.ColumnTypeEnum.COLUMN_TYPE_COVER.toInt()) {
            column.setColumnListUrl(null);
        }
        column.setCategoryManagerId(this.getManagerBySession(request).getManagerId());
        column.setAppId(websiteId);
        this.columnBiz.updateCategory((CategoryEntity)column);
        this.columnPath(request, column);
        List childList = this.columnBiz.queryChild(column.getCategoryId(), websiteId, Integer.valueOf(this.getModelCodeId(request)), null);
        if (childList != null && childList.size() > 0) {
            for (int i = 0; i < childList.size(); ++i) {
                ((ColumnEntity)childList.get(i)).setCategoryCategoryId(column.getCategoryId());
                ((ColumnEntity)childList.get(i)).setCategoryManagerId(this.getManagerBySession(request).getManagerId());
                ((ColumnEntity)childList.get(i)).setAppId(websiteId);
                this.columnBiz.updateCategory((CategoryEntity)childList.get(i));
                this.columnPath(request, (ColumnEntity)childList.get(i));
            }
        }
        this.outJson(response, (BaseEnum)ModelCode.COLUMN, true, null, (Object)com.alibaba.fastjson.JSONArray.toJSONString((Object)column.getCategoryId()));
    }
}

