/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IBasicBiz;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.entity.BasicEntity;
import com.mingsoft.basic.entity.ModelEntity;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/basic"})
public class BasicAction
extends BaseAction {
    @Autowired
    private IBasicBiz basicBiz;
    @Autowired
    private ICategoryBiz categoryBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletRequest request, ModelMap mode, HttpServletResponse response) {
        int appId = this.getManagerBySession(request).getBasicId();
        ModelEntity model = this.getCategoryModelCode(request);
        if (model == null) {
            this.outString(response, (Object)this.getResString("err"));
            return null;
        }
        List list = this.categoryBiz.queryByAppIdOrModelId(Integer.valueOf(appId), Integer.valueOf(model.getModelId()));
        JSONObject ja = new JSONObject();
        request.setAttribute("listCategory", (Object)JSONObject.toJSON((Object)list).toString());
        return this.view("/basic/index");
    }

    @RequestMapping(value={"/{categoryId}/list"})
    public String list(HttpServletRequest request, @PathVariable int categoryId) {
        String keyWord = request.getParameter("keyword");
        String categoryTitle = request.getParameter("categoryTitle");
        int pageNo = 1;
        if (request.getParameter("pageNo") != null) {
            pageNo = Integer.parseInt(request.getParameter("pageNo"));
        }
        String url = "/manager/basic/" + categoryId + "/list.do?categoryTitle=" + StringUtil.encodeStringByUTF8((String)categoryTitle) + "&keyword=" + (keyWord == null ? "" : keyWord);
        int count = 0;
        PageUtil page = new PageUtil(pageNo, 60, count, this.getUrl(request) + url);
        List basicList = this.basicBiz.query(Integer.valueOf(this.getAppId(request)), Integer.valueOf(categoryId), keyWord, page, Integer.valueOf(this.getModelCodeId(request)), null);
        request.setAttribute("basicList", (Object)basicList);
        request.setAttribute("categoryId", (Object)categoryId);
        return this.view("/basic/basic_list");
    }

    @RequestMapping(value={"/add"})
    public String add(HttpServletRequest request, HttpServletResponse response) {
        String categoryId = request.getParameter("categoryId");
        request.setAttribute("categoryId", (Object)categoryId);
        return this.view("/basic/basic");
    }

    @RequestMapping(value={"/save"})
    public void save(@ModelAttribute BasicEntity basic, HttpServletRequest request, HttpServletResponse response) {
        basic.setBasicAppId(this.getAppId(request));
        basic.setBasicModelId(this.getModelCodeId(request));
        this.basicBiz.saveEntity((BaseEntity)basic);
        this.outJson(response, null, true);
    }

    @RequestMapping(value={"/{basicId}/edit"})
    public String edit(@PathVariable int basicId, HttpServletRequest request) {
        BasicEntity basic = this.basicBiz.getBasic(basicId);
        request.setAttribute("basic", (Object)basic);
        return this.view("/basic/basic");
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute BasicEntity basic, HttpServletRequest request, HttpServletResponse response) {
        this.basicBiz.updateBasic(basic);
        this.outJson(response, null, true);
    }

    @RequestMapping(value={"/{basicId}/delete"})
    @ResponseBody
    public void delete(@PathVariable int basicId, HttpServletResponse response, HttpServletRequest request) {
        this.basicBiz.deleteBasic(basicId);
        this.outJson(response, null, true);
    }

    @RequestMapping(value={"/allDelete"})
    @ResponseBody
    public void allDelete(HttpServletResponse response, HttpServletRequest request) {
        String basicIds = request.getParameter("basicIds");
        if (!StringUtil.isBlank((String)basicIds)) {
            for (int i = 0; i < basicIds.split(",").length; ++i) {
                int basicId = Integer.parseInt(basicIds.split(",")[i]);
                this.basicBiz.deleteBasic(basicId);
            }
        }
        this.outJson(response, null, true);
    }

    @RequestMapping(value={"/listForAjax"})
    public void listForAjax(HttpServletResponse response, HttpServletRequest request) {
        PageUtil page = new PageUtil(1000);
        List list = this.basicBiz.query(Integer.valueOf(this.getAppId(request)), null, null, page, Integer.valueOf(this.getBasicModelCode(request).getModelId()), null);
        this.outJson(response, (Object)JSONArray.toJSONString((Object)list));
    }

    @RequestMapping(value={"/{categoryId}/query"})
    public void query(@PathVariable Integer categoryId, HttpServletRequest request, ModelMap mode, HttpServletResponse response) {
        List list = this.basicBiz.query(categoryId.intValue());
        String jsonStr = JSONObject.toJSONString((Object)list);
        this.LOG.debug((Object)jsonStr);
        this.outJson(response, (Object)jsonStr);
    }
}

