/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.mingsoft.base.constant.e.BaseCookieEnum;
import com.mingsoft.base.constant.e.BaseEnum;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.constant.Const;
import com.mingsoft.basic.constant.e.CookieConstEnum;
import com.mingsoft.basic.constant.e.SessionConstEnum;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.basic.entity.ModelEntity;
import com.mingsoft.basic.parser.IGeneralParser;
import com.mingsoft.util.AESUtil;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.MissingResourceException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;

public abstract class BaseAction
extends com.mingsoft.base.action.BaseAction {
    protected ModelEntity getCategoryModelCode(HttpServletRequest request) {
        Object obj = this.getSession(request, (BaseSessionEnum)SessionConstEnum.MODEL_ID_SESSION);
        if (StringUtil.isInteger((Object)obj)) {
            IModelBiz modelBiz = (IModelBiz)this.getBean(request.getServletContext(), "modelBiz");
            return modelBiz.getModel("99", Integer.parseInt(obj.toString()));
        }
        return null;
    }

    protected ModelEntity getBasicModelCode(HttpServletRequest request) {
        Object obj = this.getSession(request, (BaseSessionEnum)SessionConstEnum.MODEL_ID_SESSION);
        if (StringUtil.isInteger((Object)obj)) {
            IModelBiz modelBiz = (IModelBiz)this.getBean(request.getServletContext(), "modelBiz");
            return modelBiz.getModel("98", Integer.parseInt(obj.toString()));
        }
        return null;
    }

    protected int getManagerId(HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int managerParent = managerSession.getManagerParentID();
        if (managerParent == 0) {
            return managerSession.getManagerId();
        }
        return managerParent;
    }

    protected boolean isSystemManager(HttpServletRequest request) {
        ManagerSessionEntity manager = this.getManagerBySession(request);
        return manager.getManagerRoleID() == 1;
    }

    protected ManagerSessionEntity getManagerBySession(HttpServletRequest request) {
        ManagerSessionEntity managerSession = (ManagerSessionEntity)this.getSession(request, (BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        if (managerSession != null) {
            return managerSession;
        }
        return null;
    }

    protected String getResString(String key) {
        String str = "";
        try {
            str = super.getResString(key);
        }
        catch (MissingResourceException e) {
            str = Const.RESOURCES.getString(key);
        }
        return str;
    }

    protected boolean checkRandCode(HttpServletRequest request) {
        return this.checkRandCode(request, SessionConstEnum.CODE_SESSION.toString());
    }

    protected String decryptByAES(HttpServletRequest request, String str) {
        return AESUtil.decrypt((String)str, (String)StringUtil.Md5((String)(this.getApp(request).getAppId() + "")).substring(16));
    }

    protected String encryptByAES(HttpServletRequest request, String str) {
        return AESUtil.encrypt((String)str, (String)StringUtil.Md5((String)(this.getApp(request).getAppId() + "")).substring(16));
    }

    protected int getHistoryPageNoByCookie(HttpServletRequest request) {
        if (Integer.valueOf(this.getCookie(request, (BaseCookieEnum)CookieConstEnum.PAGENO_COOKIE)) >= 1) {
            return Integer.valueOf(this.getCookie(request, (BaseCookieEnum)CookieConstEnum.PAGENO_COOKIE));
        }
        return 0;
    }

    @Deprecated
    protected int getAppId(HttpServletRequest request) {
        return this.getApp(request).getAppId();
    }

    @Deprecated
    protected AppEntity getApp(HttpServletRequest request) {
        AppEntity app = new AppEntity();
        IAppBiz appBiz = (IAppBiz)this.getBean(request.getServletContext(), "appBiz");
        AppEntity website = appBiz.getByUrl(this.getDomain(request));
        if (website == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)website, (Object)app);
        return app;
    }

    protected String getRandCode(HttpServletRequest request) {
        return this.getSession(request, (BaseSessionEnum)SessionConstEnum.CODE_SESSION) + "";
    }

    protected int getModelCodeIdForAES(HttpServletRequest request, String code) {
        IModelBiz modelBiz = (IModelBiz)this.getBean(request.getServletContext(), "modelBiz");
        ModelEntity model = modelBiz.getEntityByModelCode(this.decryptByAES(request, code));
        if (model != null) {
            return model.getModelId();
        }
        return 0;
    }

    @Deprecated
    protected int getModelCodeId(HttpServletRequest request) {
        Object obj = this.getSession(request, (BaseSessionEnum)SessionConstEnum.MODEL_ID_SESSION);
        if (obj != null) {
            return Integer.parseInt(obj.toString());
        }
        return 0;
    }

    protected int getRootModelCodeId(HttpServletRequest request) {
        Object obj = this.getSession(request, (BaseSessionEnum)SessionConstEnum.MODEL_ID_SESSION);
        if (StringUtil.isInteger((Object)obj)) {
            IModelBiz modelBiz = (IModelBiz)this.getBean(request.getServletContext(), "modelBiz");
            ModelEntity model = (ModelEntity)modelBiz.getEntity(Integer.parseInt(obj.toString()));
            return model.getModelModelId();
        }
        return 0;
    }

    protected int getModelCodeId(HttpServletRequest request, BaseEnum code) {
        IModelBiz modelBiz = (IModelBiz)this.getBean(request.getServletContext(), "modelBiz");
        ModelEntity model = modelBiz.getEntityByModelCode(code);
        if (model != null) {
            return model.getModelId();
        }
        return 0;
    }

    protected int getModelCodeId(HttpServletRequest request, String code) {
        IModelBiz modelBiz = (IModelBiz)this.getBean(request.getServletContext(), "modelBiz");
        ModelEntity model = modelBiz.getEntityByModelCode(code);
        if (model != null) {
            return model.getModelId();
        }
        return 0;
    }

    protected String getCodeBySession(HttpServletRequest request) {
        Object obj = this.getSession(request, (BaseSessionEnum)SessionConstEnum.CODE_SESSION);
        if (obj != null) {
            return (String)obj;
        }
        return null;
    }

    protected String redirectBack(HttpServletRequest request, boolean flag) {
        if (flag) {
            return "redirect:" + this.getCookie(request, (BaseCookieEnum)CookieConstEnum.BACK_COOKIE);
        }
        return this.getCookie(request, (BaseCookieEnum)CookieConstEnum.BACK_COOKIE);
    }

    protected String parserMsTag(String html, IGeneralParser parser, HttpServletRequest req) {
        if (StringUtil.isBlank((String)html)) {
            return "";
        }
        HashMap<Object, String> map = new HashMap<Object, String>();
        if (this.isMobileDevice(req)) {
            map.put(IGeneralParser.MOBILE, "m");
        }
        return parser.parse(html, new Object[]{this.getApp(req), map});
    }

    protected String getTemplatePath(HttpServletRequest req) {
        AppEntity app = this.getApp(req);
        if (app == null) {
            return "";
        }
        String tmpName = app.getAppStyle();
        String tmpPath = this.getRealPath(req, "templets");
        String webSiteTmpPath = tmpPath + File.separator + app.getAppId() + File.separator + tmpName;
        if (this.isMobileDevice(req)) {
            webSiteTmpPath = webSiteTmpPath + File.separator + app.getAppMobileStyle();
        }
        return webSiteTmpPath;
    }

    protected boolean checkRandCode(HttpServletRequest request, String param) {
        String sessionCode = this.getRandCode(request);
        String requestCode = request.getParameter(param);
        this.LOG.debug((Object)("session_code:" + sessionCode + " requestCode:" + requestCode));
        return sessionCode.equalsIgnoreCase(requestCode);
    }

    protected String view(String path) {
        return Const.VIEW + path;
    }

    @Deprecated
    protected void removeUrlParams(HttpServletRequest request, String[] fitlers) {
        request.setAttribute("params", (Object)this.assemblyRequestUrlParams(request, fitlers));
    }
}

