/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.people.action;

import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.people.action.BaseAction;
import com.mingsoft.people.bean.PeopleBean;
import com.mingsoft.people.biz.IPeopleBiz;
import com.mingsoft.people.biz.IPeopleUserBiz;
import com.mingsoft.people.constant.Const;
import com.mingsoft.people.constant.ModelCode;
import com.mingsoft.people.entity.PeopleEntity;
import com.mingsoft.people.entity.PeopleUserEntity;
import com.mingsoft.util.StringUtil;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/${managerPath}/people/peopleUser"})
public class PeopleUserAction
extends BaseAction {
    @Autowired
    private IPeopleUserBiz peopleUserBiz;
    @Autowired
    private IPeopleBiz peopleBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return this.view("/people/user/index");
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    public EUListBean list(@ModelAttribute PeopleBean peopleUser, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (peopleUser == null) {
            peopleUser = new PeopleBean();
        }
        peopleUser.setPeopleAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List peopleUserList = this.peopleUserBiz.query((BaseEntity)peopleUser);
        EUListBean list = new EUListBean(peopleUserList, (int)BasicUtil.endPage((List)peopleUserList).getTotal());
        return list;
    }

    @RequestMapping(value={"/form"})
    public String form(@ModelAttribute PeopleUserEntity peopleUser, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (peopleUser.getPuPeopleId() != null) {
            BaseEntity peopleUserEntity = this.peopleUserBiz.getEntity(peopleUser.getPuPeopleId());
            model.addAttribute("peopleUserEntity", (Object)peopleUserEntity);
        }
        return this.view("/people/user/form");
    }

    @RequestMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute PeopleUserEntity peopleUser, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (peopleUser.getPuPeopleId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", this.getResString("pu.people.id")));
            return;
        }
        PeopleUserEntity _peopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(peopleUser.getPuPeopleId());
        this.outJson(response, (Object)_peopleUser, new String[]{"peopleOldPassword", "peoplePassword"});
    }

    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"people:save"})
    public void save(@ModelAttribute PeopleUserEntity peopleUser, HttpServletResponse response, HttpServletRequest request) {
        if (!StringUtil.checkLength((String)(peopleUser.getPuRealName() + ""), (int)0, (int)50)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.real.name"), "0", "50"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuAddress() + ""), (int)0, (int)200)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.address"), "0", "200"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuIcon() + ""), (int)0, (int)200)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.icon"), "0", "200"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuNickname() + ""), (int)0, (int)50)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.nickname"), "0", "50"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuSex() + ""), (int)0, (int)10)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.sex"), "0", "10"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuCard() + ""), (int)0, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.card"), "0", "255"));
            return;
        }
        if (!StringUtil.isBlank((String)StringUtil.Md5((String)peopleUser.getPeoplePassword()))) {
            peopleUser.setPeoplePassword(StringUtil.Md5((String)peopleUser.getPeoplePassword()));
        }
        if (!this.checkPeople(peopleUser, request, response)) {
            return;
        }
        peopleUser.setPeopleDateTime(new Date());
        peopleUser.setPeopleAppId(BasicUtil.getAppId());
        this.peopleUserBiz.savePeople(peopleUser);
        this.outJson(response, (Object)peopleUser, new String[]{"peopleOldPassword", "peoplePassword"});
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"people:del"})
    public void delete(@RequestBody List<PeopleUserEntity> peopleUsers, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[peopleUsers.size()];
        for (int i = 0; i < peopleUsers.size(); ++i) {
            ids[i] = peopleUsers.get(i).getPuPeopleId();
        }
        this.peopleUserBiz.deletePeople(ids);
        this.outJson(response, true);
    }

    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"people:update"})
    public void update(@ModelAttribute PeopleUserEntity peopleUser, HttpServletResponse response, HttpServletRequest request) {
        if (!StringUtil.checkLength((String)(peopleUser.getPuRealName() + ""), (int)0, (int)50)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.real.name"), "0", "50"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuAddress() + ""), (int)0, (int)200)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.address"), "0", "200"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuIcon() + ""), (int)0, (int)200)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.icon"), "0", "200"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuNickname() + ""), (int)0, (int)50)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.nickname"), "0", "50"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuSex() + ""), (int)0, (int)10)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.sex"), "0", "10"));
            return;
        }
        if (!StringUtil.checkLength((String)(peopleUser.getPuCard() + ""), (int)0, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", this.getResString("pu.card"), "0", "255"));
            return;
        }
        if (!this.checkUpdatePeople(peopleUser, request, response)) {
            return;
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeoplePassword())) {
            peopleUser.setPeoplePassword(StringUtil.Md5((String)peopleUser.getPeoplePassword()));
        }
        peopleUser.setPeopleId(peopleUser.getPuPeopleId());
        this.peopleUserBiz.updatePeople(peopleUser);
        this.outJson(response, (Object)peopleUser, new String[]{"peopleOldPassword", "peoplePassword"});
    }

    public boolean checkUpdatePeople(PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity peoplePhone;
        PeopleUserEntity oldPeopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(peopleUser.getPuPeopleId());
        int appId = this.getAppId(request);
        if (!StringUtil.isBlank((String)peopleUser.getPeopleMail()) && !StringUtil.isEmail((String)peopleUser.getPeopleMail()).booleanValue()) {
            this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.msg.mail.format.error", Const.RESOURCES));
            return false;
        }
        if (StringUtil.isBlank((String)peopleUser.getPeopleName())) {
            this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.msg.name.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeoplePhone()) && !StringUtil.isMobile((String)peopleUser.getPeoplePhone())) {
            this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.msg.phone.format.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeopleName())) {
            peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeopleName(), appId);
            if (StringUtil.isBlank((String)oldPeopleUser.getPeopleName())) {
                if (peoplePhone != null) {
                    this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                    return false;
                }
            } else if (!oldPeopleUser.getPeopleName().equals(peopleUser.getPeopleName()) && peoplePhone != null) {
                this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                return false;
            }
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeoplePhone())) {
            peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeoplePhone(), appId);
            if (StringUtil.isBlank((String)oldPeopleUser.getPeoplePhone())) {
                if (peoplePhone != null) {
                    this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                    return false;
                }
            } else if (!oldPeopleUser.getPeoplePhone().equals(peopleUser.getPeoplePhone()) && peoplePhone != null) {
                this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                return false;
            }
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeopleMail())) {
            peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeopleMail(), appId);
            if (StringUtil.isBlank((String)oldPeopleUser.getPeopleMail())) {
                if (peoplePhone != null) {
                    this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                    return false;
                }
            } else if (!oldPeopleUser.getPeopleMail().equals(peopleUser.getPeopleMail()) && peoplePhone != null) {
                this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
                return false;
            }
        }
        return true;
    }

    public boolean checkPeople(PeopleUserEntity peopleUser, HttpServletRequest request, HttpServletResponse response) {
        PeopleEntity peopleMail;
        PeopleEntity peoplePhone;
        int appId = this.getAppId(request);
        if (!StringUtil.isBlank((String)peopleUser.getPeopleMail()) && !StringUtil.isEmail((String)peopleUser.getPeopleMail()).booleanValue()) {
            this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.msg.mail.format.error", Const.RESOURCES));
            return false;
        }
        if (StringUtil.isBlank((String)peopleUser.getPeopleName())) {
            this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.msg.name.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeoplePhone()) && !StringUtil.isMobile((String)peopleUser.getPeoplePhone())) {
            this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.msg.phone.format.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeopleName()) && (peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeopleName(), appId)) != null) {
            this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.register.msg.name.repeat.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeoplePhone()) && (peoplePhone = this.peopleBiz.getEntityByUserName(peopleUser.getPeoplePhone(), appId)) != null) {
            this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.register.msg.phone.repeat.error", Const.RESOURCES));
            return false;
        }
        if (!StringUtil.isBlank((String)peopleUser.getPeopleMail()) && (peopleMail = this.peopleBiz.getEntityByUserName(peopleUser.getPeopleMail(), appId)) != null) {
            this.outJson(response, ModelCode.PEOPLE_USER, false, this.getResString("people.register.msg.mail.repeat.error", Const.RESOURCES));
            return false;
        }
        return true;
    }

    @Deprecated
    @RequestMapping(value={"/getEntity"})
    public void getEntity(String peopleId, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtil.isBlank((String)peopleId) || !StringUtil.isInteger((String)peopleId)) {
            this.outJson(response, ModelCode.PEOPLE_USER, false);
            return;
        }
        PeopleUserEntity peopleUser = (PeopleUserEntity)this.peopleUserBiz.getEntity(Integer.parseInt(peopleId));
        if (peopleUser == null) {
            this.outJson(response, ModelCode.PEOPLE_USER, false);
            return;
        }
        this.outJson(response, ModelCode.PEOPLE_USER, true, null, JSONObject.toJSONString((Object)((Object)peopleUser)));
    }
}

