/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.ITagBiz;
import net.mingsoft.mdiy.entity.TagEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u6807\u7b7e\u7ba1\u7406\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/tag"})
public class TagAction
extends BaseAction {
    @Autowired
    private ITagBiz tagBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        return "/mdiy/tag/index";
    }

    @ApiOperation(value="\u6807\u7b7e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tagName", value="\u6a21\u5757\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="tagType", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7ed1\u5b9a\u6a21\u677f\u7684\u8def\u5f84", required=false, paramType="query"), @ApiImplicitParam(name="tagDescription", value="\u81ea\u5b9a\u4e49\u9875\u9762\u6807\u9898", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore TagEntity tag, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model, BindingResult result) {
        BasicUtil.startPage();
        List tagList = this.tagBiz.query(tag);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(tagList, (int)BasicUtil.endPage((List)tagList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute TagEntity tag, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (tag.getId() != null) {
            BaseEntity tagEntity = this.tagBiz.getEntity(Integer.parseInt(tag.getId()));
            model.addAttribute("tagEntity", (Object)tagEntity);
        }
        return "/mdiy/tag/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u6807\u7b7e\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u6807\u7b7e\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public TagEntity get(@ModelAttribute @ApiIgnore TagEntity tag, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (tag.getId() == null) {
            return null;
        }
        TagEntity _tag = (TagEntity)this.tagBiz.getEntity(Integer.parseInt(tag.getId()));
        return _tag;
    }

    @ApiOperation(value="\u4fdd\u5b58\u6807\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tagName", value="\u6a21\u5757\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="tagDescription", value="\u81ea\u5b9a\u4e49\u9875\u9762\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="tagType", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7ed1\u5b9a\u6a21\u677f\u7684\u8def\u5f84", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:tag:save"})
    public void save(@ModelAttribute @ApiIgnore TagEntity tag, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)tag.getTagName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("tag.name")}));
            return;
        }
        if (!StringUtil.checkLength((String)(tag.getTagName() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("tag.name"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)tag.getTagDescription())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("tag.description")}));
            return;
        }
        if (!StringUtil.checkLength((String)(tag.getTagDescription() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("tag.description"), "1", "255"}));
            return;
        }
        this.tagBiz.saveEntity(tag);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)tag)));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6807\u7b7e")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:tag:del"})
    public void delete(@RequestBody @ApiIgnore List<TagEntity> tags, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[tags.size()];
        for (int i = 0; i < tags.size(); ++i) {
            ids[i] = Integer.parseInt(tags.get(i).getId());
        }
        this.tagBiz.delete(ids);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u66f4\u65b0\u6807\u7b7e\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6807\u7b7e\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="tagName", value="\u6a21\u5757\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="tagDescription", value="\u81ea\u5b9a\u4e49\u9875\u9762\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="tagType", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7ed1\u5b9a\u6a21\u677f\u7684\u8def\u5f84", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:tag:update"})
    public void update(@ModelAttribute @ApiIgnore TagEntity tag, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)tag.getId())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("id")}));
            return;
        }
        if (!StringUtil.checkLength((String)(tag.getId() + ""), (int)1, (int)11)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("id"), "1", "11"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)tag.getTagName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("tag.name")}));
            return;
        }
        if (!StringUtil.checkLength((String)(tag.getTagName() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("tag.name"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)tag.getTagDescription())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("tag.description")}));
            return;
        }
        if (!StringUtil.checkLength((String)(tag.getTagDescription() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("tag.description"), "1", "255"}));
            return;
        }
        this.tagBiz.updateEntity(tag);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)tag)));
    }
}

