/*
 * Decompiled with CFR 0.152.
 */
package net.ftlines.wicketsource;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketSourceFilter {
    private static final String NOTIFY_COMPONENT_INSTANTIATION_LISTENERS = "org.apache.wicket.application.ComponentInstantiationListenerCollection.onInstantiation";
    private static final String WICKET_PAGE_ON_RENDER = "org.apache.wicket.Page.onRender";
    private static final String WICKET_PAGE_ON_BEFORE_RENDER = "org.apache.wicket.Page.onBeforeRender";

    public static String getClassName(Component component) {
        String name = component.getClass().getName();
        if (name.indexOf("$") > 0) {
            name = component.getClass().getSuperclass().getName();
        }
        name = Strings.lastPathComponent((String)name, (char)':');
        return name;
    }

    public static StackTraceElement findCreationSource(Throwable location, Component component) {
        return WicketSourceFilter.findCreationSource(WicketSourceFilter.filterForInteresting(component, location), component);
    }

    private static StackTraceElement findCreationSource(List<StackTraceElement> elements, Component component) {
        StackTraceElement wicketInternalOrigin = null;
        StackTraceElement userDeclaredOrigin = null;
        for (int i = 0; i < elements.size(); ++i) {
            String componentClass;
            String elementClass;
            if (elements.get(i).toString().indexOf(NOTIFY_COMPONENT_INSTANTIATION_LISTENERS) != -1 && i + 1 < elements.size() && ((wicketInternalOrigin = elements.get(i + 1)).toString().indexOf(WICKET_PAGE_ON_RENDER) != -1 || wicketInternalOrigin.toString().indexOf(WICKET_PAGE_ON_BEFORE_RENDER) != -1)) {
                wicketInternalOrigin = null;
            }
            if (!(elementClass = elements.get(i).getClassName()).equals(componentClass = component.getClassRelativePath().substring(0, component.getClassRelativePath().indexOf(58)))) continue;
            userDeclaredOrigin = i + 1 < elements.size() ? elements.get(i + 1) : elements.get(i);
        }
        if (userDeclaredOrigin != null) {
            return userDeclaredOrigin;
        }
        return wicketInternalOrigin;
    }

    private static List<StackTraceElement> filterForInteresting(Component component, Throwable location) {
        Class<?> componentClass = component.getClass();
        String componentType = componentClass.getName();
        if (componentType.indexOf(36) >= 0) {
            componentType = componentClass.getSuperclass().getName();
        }
        componentType = componentType.substring(componentType.lastIndexOf(46) + 1);
        String[] skippedElements = new String[]{"org.apache.wicket.MarkupContainer", "org.apache.wicket.Component", "org.apache.wicket.markup"};
        String[] breakingElements = new String[]{"org.apache.wicket.protocol.http.WicketServlet", "org.apache.wicket.protocol.http.WicketFilter", "java.lang.reflect"};
        StackTraceElement[] trace = location.getStackTrace();
        ArrayList<StackTraceElement> keep = new ArrayList<StackTraceElement>();
        for (int i = 0; i < trace.length; ++i) {
            String traceString = trace[i].toString();
            if (WicketSourceFilter.shouldSkip(traceString, skippedElements) || traceString.startsWith("sun.reflect.") && i > 1) continue;
            if (traceString.indexOf("java.lang.reflect") < 0) {
                keep.add(trace[i]);
            }
            if (WicketSourceFilter.shouldSkip(traceString, breakingElements)) break;
        }
        return keep;
    }

    private static boolean shouldSkip(String text, String[] filters) {
        for (int i = 0; i < filters.length; ++i) {
            if (text.indexOf(filters[i]) < 0) continue;
            return true;
        }
        return false;
    }
}

