/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TychoUtilities {
    private static final String TychoConstants_CTX_ECLIPSE_PLUGIN_CLASSPATH = "org.codehaus.tycho.TychoConstants/eclipsePluginClasspath";
    private static final Method getContextValueMethod;
    private static final Method getLocationsMethod;

    public static List<String> addOsgiClasspathElements(MavenProject project, List<String> defaultClasspathElements) {
        if (getLocationsMethod == null) {
            return defaultClasspathElements;
        }
        List classpath = (List)TychoUtilities.getContextValue(project, TychoConstants_CTX_ECLIPSE_PLUGIN_CLASSPATH);
        if (classpath == null || classpath.isEmpty()) {
            return defaultClasspathElements;
        }
        ArrayList<String> osgiClasspath = new ArrayList<String>();
        for (Object classpathEntry : classpath) {
            for (File file : TychoUtilities.getLocations(classpathEntry)) {
                osgiClasspath.add(file.getAbsolutePath());
            }
        }
        osgiClasspath.addAll(defaultClasspathElements);
        return osgiClasspath;
    }

    private static Object getContextValue(MavenProject project, String key) {
        try {
            return getContextValueMethod.invoke((Object)project, key);
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
        catch (IllegalAccessException e) {
            return Collections.emptyList();
        }
        catch (InvocationTargetException e) {
            return Collections.emptyList();
        }
    }

    private static List<File> getLocations(Object classpathEntry) {
        try {
            return (List)getLocationsMethod.invoke(classpathEntry, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
        catch (IllegalAccessException e) {
            return Collections.emptyList();
        }
        catch (InvocationTargetException e) {
            return Collections.emptyList();
        }
    }

    static {
        Method getContextValueMethod0 = null;
        Method getLocationsMethod0 = null;
        try {
            final Class<MavenProject> mpClazz = MavenProject.class;
            getContextValueMethod0 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Method m = mpClazz.getDeclaredMethod("getContextValue", String.class);
                    m.setAccessible(true);
                    return m;
                }
            });
            final Class<?> cpeClazz = Class.forName("org.codehaus.tycho.ClasspathEntry");
            getLocationsMethod0 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Method m = cpeClazz.getDeclaredMethod("getLocations", new Class[0]);
                    m.setAccessible(true);
                    return m;
                }
            });
        }
        catch (ClassNotFoundException ex) {
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        getContextValueMethod = getContextValueMethod0;
        getLocationsMethod = getLocationsMethod0;
    }
}

