/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.mysqla.io.NativeProtocol;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.mysqla.io.Buffer;

public class CommandBuilder {
    public PacketPayload buildComQuery(PacketPayload sharedPacket, byte[] query) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(query.length + 1);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 3L);
        packet.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, query);
        return packet;
    }

    public PacketPayload buildComQuery(PacketPayload sharedPacket, String query) {
        return this.buildComQuery(sharedPacket, StringUtils.getBytes(query));
    }

    public PacketPayload buildComQuery(PacketPayload sharedPacket, String query, String encoding) {
        return this.buildComQuery(sharedPacket, StringUtils.getBytes(query, encoding));
    }

    public PacketPayload buildComInitDb(PacketPayload sharedPacket, byte[] dbName) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(dbName.length + 1);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 2L);
        packet.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, dbName);
        return packet;
    }

    public PacketPayload buildComInitDb(PacketPayload sharedPacket, String dbName) {
        return this.buildComInitDb(sharedPacket, StringUtils.getBytes(dbName));
    }

    public PacketPayload buildComShutdown(PacketPayload sharedPacket) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(1);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 8L);
        return packet;
    }

    public PacketPayload buildComSetOption(PacketPayload sharedPacket, int val) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(3);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 27L);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT2, val);
        return packet;
    }

    public PacketPayload buildComPing(PacketPayload sharedPacket) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(1);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 14L);
        return packet;
    }

    public PacketPayload buildComQuit(PacketPayload sharedPacket) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(1);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 1L);
        return packet;
    }

    public PacketPayload buildComStmtPrepare(PacketPayload sharedPacket, byte[] query) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(query.length + 1);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 22L);
        packet.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, query);
        return packet;
    }

    public PacketPayload buildComStmtPrepare(PacketPayload sharedPacket, String queryString, String characterEncoding) {
        return this.buildComStmtPrepare(sharedPacket, StringUtils.getBytes(queryString, characterEncoding));
    }

    public PacketPayload buildComStmtClose(PacketPayload sharedPacket, long serverStatementId) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(5);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 25L);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT4, serverStatementId);
        return packet;
    }

    public PacketPayload buildComStmtReset(PacketPayload sharedPacket, long serverStatementId) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(5);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 26L);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT4, serverStatementId);
        return packet;
    }

    public PacketPayload buildComStmtFetch(PacketPayload sharedPacket, long serverStatementId, long numRowsToFetch) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(9);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 28L);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT4, serverStatementId);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT4, numRowsToFetch);
        return packet;
    }

    public PacketPayload buildComStmtSendLongData(PacketPayload sharedPacket, long serverStatementId, int parameterIndex, byte[] longData) {
        PacketPayload packet = sharedPacket != null ? sharedPacket : new Buffer(9);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT1, 24L);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT4, serverStatementId);
        packet.writeInteger(NativeProtocol.IntegerDataType.INT2, parameterIndex);
        packet.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, longData);
        return packet;
    }
}

