/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.jdbc.JdbcPropertySet;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.conf.AbstractRuntimeProperty;
import com.mysql.cj.core.conf.PropertyDefinitions;
import com.mysql.cj.core.conf.url.ConnectionUrl;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.jdbc.JdbcPropertySetImpl;
import com.mysql.cj.jdbc.MysqlDataSourceFactory;
import com.mysql.cj.jdbc.NonRegisteringDriver;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class MysqlDataSource
extends JdbcPropertySetImpl
implements DataSource,
Referenceable,
Serializable,
JdbcPropertySet {
    static final long serialVersionUID = -5515846944416881264L;
    protected static final NonRegisteringDriver mysqlDriver;
    protected transient PrintWriter logWriter = null;
    protected String databaseName = null;
    protected String encoding = null;
    protected String hostName = null;
    protected String password = null;
    protected String profileSQLString = "false";
    protected String url = null;
    protected String user = null;
    protected boolean explicitUrl = false;
    protected int port = 3306;
    protected String description = "MySQL Connector/J Data Source";

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.getConnection(this.user, this.password);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public Connection getConnection(String userID, String pass) throws SQLException {
        try {
            Properties props = new Properties();
            if (userID != null) {
                props.setProperty("user", userID);
            }
            if (pass != null) {
                props.setProperty("password", pass);
            }
            this.exposeAsProperties(props);
            return this.getConnection(props);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setDatabaseName(String dbName) {
        this.databaseName = dbName;
    }

    public String getDatabaseName() {
        return this.databaseName != null ? this.databaseName : "";
    }

    @Override
    public void setLogWriter(PrintWriter output) throws SQLException {
        try {
            this.logWriter = output;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        try {
            return this.logWriter;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public int getLoginTimeout() {
        try {
            return 0;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public int getPort() {
        return this.port;
    }

    public void setPortNumber(int p) {
        this.setPort(p);
    }

    public int getPortNumber() {
        return this.getPort();
    }

    public void setPropertiesViaRef(Reference ref) throws SQLException {
        for (String propName : PropertyDefinitions.PROPERTY_NAME_TO_PROPERTY_DEFINITION.keySet()) {
            ReadableProperty propToSet = this.getReadableProperty(propName);
            if (ref == null) continue;
            propToSet.initializeFrom(ref, null);
        }
        this.postInitialization();
    }

    @Override
    public Reference getReference() throws NamingException {
        String factoryName = MysqlDataSourceFactory.class.getName();
        Reference ref = new Reference(this.getClass().getName(), factoryName, null);
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("serverName", this.getServerName()));
        ref.add(new StringRefAddr("port", "" + this.getPort()));
        ref.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("explicitUrl", String.valueOf(this.explicitUrl)));
        for (String propName : PropertyDefinitions.PROPERTY_NAME_TO_PROPERTY_DEFINITION.keySet()) {
            ReadableProperty propToStore = this.getReadableProperty(propName);
            String val = propToStore.getStringValue();
            if (val == null) continue;
            ref.add(new StringRefAddr(propToStore.getPropertyDefinition().getName(), val));
        }
        return ref;
    }

    public void setServerName(String serverName) {
        this.hostName = serverName;
    }

    public String getServerName() {
        return this.hostName != null ? this.hostName : "";
    }

    public void setURL(String url) {
        this.setUrl(url);
    }

    public String getURL() {
        return this.getUrl();
    }

    public void setUrl(String url) {
        this.url = url;
        this.explicitUrl = true;
    }

    public String getUrl() {
        if (!this.explicitUrl) {
            StringBuilder sbUrl = new StringBuilder(ConnectionUrl.Type.SINGLE_CONNECTION.getProtocol());
            sbUrl.append("//").append(this.getServerName()).append(":").append(this.getPort()).append("/").append(this.getDatabaseName());
            return sbUrl.toString();
        }
        return this.url;
    }

    public void setUser(String userID) {
        this.user = userID;
    }

    public String getUser() {
        return this.user;
    }

    protected Connection getConnection(Properties props) throws SQLException {
        String jdbcUrlToUse = null;
        jdbcUrlToUse = !this.explicitUrl ? this.getUrl() : this.url;
        ConnectionUrl connUrl = ConnectionUrl.getConnectionUrlInstance(jdbcUrlToUse, null);
        if (connUrl.getType() == null) {
            throw SQLError.createSQLException(Messages.getString("MysqlDataSource.BadUrl", new Object[]{jdbcUrlToUse}), "08006", null);
        }
        Properties urlProps = connUrl.getConnectionArgumentsAsProperties();
        urlProps.remove("DBNAME");
        urlProps.remove("HOST");
        urlProps.remove("PORT");
        urlProps.stringPropertyNames().stream().forEach(k -> props.setProperty((String)k, urlProps.getProperty((String)k)));
        return mysqlDriver.connect(jdbcUrlToUse, props);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected String getStringProperty(String name) throws SQLException {
        try {
            return this.getStringReadableProperty(name).getValue();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected void setStringProperty(String name, String value) throws SQLException {
        try {
            ReadableProperty<String> prop = this.getStringReadableProperty(name);
            if (prop.getPropertyDefinition().isRuntimeModifiable()) {
                this.getStringModifiableProperty(name).setValue(value);
            } else {
                ((AbstractRuntimeProperty)((Object)prop)).setFromString(value, null);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected boolean getBooleanProperty(String name) throws SQLException {
        try {
            return this.getBooleanReadableProperty(name).getValue();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected void setBooleanProperty(String name, boolean value) throws SQLException {
        try {
            ReadableProperty<Boolean> prop = this.getBooleanReadableProperty(name);
            if (prop.getPropertyDefinition().isRuntimeModifiable()) {
                this.getBooleanModifiableProperty(name).setValue(value);
            } else {
                ((AbstractRuntimeProperty)((Object)prop)).setFromString("" + value, null);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected int getIntegerProperty(String name) throws SQLException {
        try {
            return this.getIntegerReadableProperty(name).getValue();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected void setIntegerProperty(String name, int value) throws SQLException {
        try {
            ReadableProperty<Integer> prop = this.getIntegerReadableProperty(name);
            if (prop.getPropertyDefinition().isRuntimeModifiable()) {
                this.getIntegerModifiableProperty(name).setValue(value);
            } else {
                ((AbstractRuntimeProperty)((Object)prop)).setFromString("" + value, null);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected long getLongProperty(String name) throws SQLException {
        try {
            return this.getLongReadableProperty(name).getValue();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected void setLongProperty(String name, long value) throws SQLException {
        try {
            ReadableProperty<Long> prop = this.getLongReadableProperty(name);
            if (prop.getPropertyDefinition().isRuntimeModifiable()) {
                this.getLongModifiableProperty(name).setValue(value);
            } else {
                ((AbstractRuntimeProperty)((Object)prop)).setFromString("" + value, null);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected int getMemorySizeProperty(String name) throws SQLException {
        try {
            return this.getMemorySizeReadableProperty(name).getValue();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected void setMemorySizeProperty(String name, int value) throws SQLException {
        try {
            ReadableProperty<Integer> prop = this.getIntegerReadableProperty(name);
            if (prop.getPropertyDefinition().isRuntimeModifiable()) {
                this.getMemorySizeModifiableProperty(name).setValue(value);
            } else {
                ((AbstractRuntimeProperty)((Object)prop)).setFromString("" + value, null);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected String getEnumProperty(String name) throws SQLException {
        try {
            return this.getEnumReadableProperty(name).getStringValue();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    protected void setEnumProperty(String name, String value) throws SQLException {
        try {
            ReadableProperty prop = this.getEnumReadableProperty(name);
            if (prop.getPropertyDefinition().isRuntimeModifiable()) {
                this.getEnumModifiableProperty(name).setFromString(value, null);
            } else {
                ((AbstractRuntimeProperty)((Object)prop)).setFromString("" + value, null);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public Properties exposeAsProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        for (String propName : PropertyDefinitions.PROPERTY_NAME_TO_PROPERTY_DEFINITION.keySet()) {
            ReadableProperty propToGet = this.getReadableProperty(propName);
            String propValue = propToGet.getStringValue();
            if (propValue == null || !propToGet.isExplicitlySet()) continue;
            props.setProperty(propToGet.getPropertyDefinition().getName(), propValue);
        }
        return props;
    }

    static {
        try {
            mysqlDriver = new NonRegisteringDriver();
        }
        catch (Exception E) {
            throw new RuntimeException(Messages.getString("MysqlDataSource.0"));
        }
    }

    public boolean getDumpQueriesOnException() throws SQLException {
        return this.getBooleanProperty("dumpQueriesOnException");
    }

    public void setDumpQueriesOnException(boolean bl) throws SQLException {
        this.setBooleanProperty("dumpQueriesOnException", bl);
    }

    public String getSocksProxyHost() throws SQLException {
        return this.getStringProperty("socksProxyHost");
    }

    public void setSocksProxyHost(String string) throws SQLException {
        this.setStringProperty("socksProxyHost", string);
    }

    public String getResourceId() throws SQLException {
        return this.getStringProperty("resourceId");
    }

    public void setResourceId(String string) throws SQLException {
        this.setStringProperty("resourceId", string);
    }

    public boolean getHaEnableJMX() throws SQLException {
        return this.getBooleanProperty("haEnableJMX");
    }

    public void setHaEnableJMX(boolean bl) throws SQLException {
        this.setBooleanProperty("haEnableJMX", bl);
    }

    public int getLoadBalanceAutoCommitStatementThreshold() throws SQLException {
        return this.getIntegerProperty("loadBalanceAutoCommitStatementThreshold");
    }

    public void setLoadBalanceAutoCommitStatementThreshold(int n) throws SQLException {
        this.setIntegerProperty("loadBalanceAutoCommitStatementThreshold", n);
    }

    public String getLogger() throws SQLException {
        return this.getStringProperty("logger");
    }

    public void setLogger(String string) throws SQLException {
        this.setStringProperty("logger", string);
    }

    public boolean getQueryTimeoutKillsConnection() throws SQLException {
        return this.getBooleanProperty("queryTimeoutKillsConnection");
    }

    public void setQueryTimeoutKillsConnection(boolean bl) throws SQLException {
        this.setBooleanProperty("queryTimeoutKillsConnection", bl);
    }

    public String getClobCharacterEncoding() throws SQLException {
        return this.getStringProperty("clobCharacterEncoding");
    }

    public void setClobCharacterEncoding(String string) throws SQLException {
        this.setStringProperty("clobCharacterEncoding", string);
    }

    public boolean getUseLocalTransactionState() throws SQLException {
        return this.getBooleanProperty("useLocalTransactionState");
    }

    public void setUseLocalTransactionState(boolean bl) throws SQLException {
        this.setBooleanProperty("useLocalTransactionState", bl);
    }

    public int getLargeRowSizeThreshold() throws SQLException {
        return this.getIntegerProperty("largeRowSizeThreshold");
    }

    public void setLargeRowSizeThreshold(int n) throws SQLException {
        this.setIntegerProperty("largeRowSizeThreshold", n);
    }

    public int getLoadBalanceBlacklistTimeout() throws SQLException {
        return this.getIntegerProperty("loadBalanceBlacklistTimeout");
    }

    public void setLoadBalanceBlacklistTimeout(int n) throws SQLException {
        this.setIntegerProperty("loadBalanceBlacklistTimeout", n);
    }

    public String getLoadBalanceAutoCommitStatementRegex() throws SQLException {
        return this.getStringProperty("loadBalanceAutoCommitStatementRegex");
    }

    public void setLoadBalanceAutoCommitStatementRegex(String string) throws SQLException {
        this.setStringProperty("loadBalanceAutoCommitStatementRegex", string);
    }

    public int getMaxAllowedPacket() throws SQLException {
        return this.getIntegerProperty("maxAllowedPacket");
    }

    public void setMaxAllowedPacket(int n) throws SQLException {
        this.setIntegerProperty("maxAllowedPacket", n);
    }

    public boolean getIgnoreNonTxTables() throws SQLException {
        return this.getBooleanProperty("ignoreNonTxTables");
    }

    public void setIgnoreNonTxTables(boolean bl) throws SQLException {
        this.setBooleanProperty("ignoreNonTxTables", bl);
    }

    public boolean getLoadBalanceValidateConnectionOnSwapServer() throws SQLException {
        return this.getBooleanProperty("loadBalanceValidateConnectionOnSwapServer");
    }

    public void setLoadBalanceValidateConnectionOnSwapServer(boolean bl) throws SQLException {
        this.setBooleanProperty("loadBalanceValidateConnectionOnSwapServer", bl);
    }

    public int getMaxRows() throws SQLException {
        return this.getIntegerProperty("maxRows");
    }

    public void setMaxRows(int n) throws SQLException {
        this.setIntegerProperty("maxRows", n);
    }

    public boolean getPadCharsWithSpace() throws SQLException {
        return this.getBooleanProperty("padCharsWithSpace");
    }

    public void setPadCharsWithSpace(boolean bl) throws SQLException {
        this.setBooleanProperty("padCharsWithSpace", bl);
    }

    public boolean getUseAffectedRows() throws SQLException {
        return this.getBooleanProperty("useAffectedRows");
    }

    public void setUseAffectedRows(boolean bl) throws SQLException {
        this.setBooleanProperty("useAffectedRows", bl);
    }

    public String getEnabledTLSProtocols() throws SQLException {
        return this.getStringProperty("enabledTLSProtocols");
    }

    public void setEnabledTLSProtocols(String string) throws SQLException {
        this.setStringProperty("enabledTLSProtocols", string);
    }

    public boolean getUseColumnNamesInFindColumn() throws SQLException {
        return this.getBooleanProperty("useColumnNamesInFindColumn");
    }

    public void setUseColumnNamesInFindColumn(boolean bl) throws SQLException {
        this.setBooleanProperty("useColumnNamesInFindColumn", bl);
    }

    public String getCharacterSetResults() throws SQLException {
        return this.getStringProperty("characterSetResults");
    }

    public void setCharacterSetResults(String string) throws SQLException {
        this.setStringProperty("characterSetResults", string);
    }

    public boolean getElideSetAutoCommits() throws SQLException {
        return this.getBooleanProperty("elideSetAutoCommits");
    }

    public void setElideSetAutoCommits(boolean bl) throws SQLException {
        this.setBooleanProperty("elideSetAutoCommits", bl);
    }

    public String getServerRSAPublicKeyFile() throws SQLException {
        return this.getStringProperty("serverRSAPublicKeyFile");
    }

    public void setServerRSAPublicKeyFile(String string) throws SQLException {
        this.setStringProperty("serverRSAPublicKeyFile", string);
    }

    public boolean getPedantic() throws SQLException {
        return this.getBooleanProperty("pedantic");
    }

    public void setPedantic(boolean bl) throws SQLException {
        this.setBooleanProperty("pedantic", bl);
    }

    public String getDefaultAuthenticationPlugin() throws SQLException {
        return this.getStringProperty("defaultAuthenticationPlugin");
    }

    public void setDefaultAuthenticationPlugin(String string) throws SQLException {
        this.setStringProperty("defaultAuthenticationPlugin", string);
    }

    public boolean getOverrideSupportsIntegrityEnhancementFacility() throws SQLException {
        return this.getBooleanProperty("overrideSupportsIntegrityEnhancementFacility");
    }

    public void setOverrideSupportsIntegrityEnhancementFacility(boolean bl) throws SQLException {
        this.setBooleanProperty("overrideSupportsIntegrityEnhancementFacility", bl);
    }

    public boolean getAllowLoadLocalInfile() throws SQLException {
        return this.getBooleanProperty("allowLoadLocalInfile");
    }

    public void setAllowLoadLocalInfile(boolean bl) throws SQLException {
        this.setBooleanProperty("allowLoadLocalInfile", bl);
    }

    public String getExceptionInterceptors() throws SQLException {
        return this.getStringProperty("exceptionInterceptors");
    }

    public void setExceptionInterceptors(String string) throws SQLException {
        this.setStringProperty("exceptionInterceptors", string);
    }

    public boolean getAutoDeserialize() throws SQLException {
        return this.getBooleanProperty("autoDeserialize");
    }

    public void setAutoDeserialize(boolean bl) throws SQLException {
        this.setBooleanProperty("autoDeserialize", bl);
    }

    public boolean getProfileSQL() throws SQLException {
        return this.getBooleanProperty("profileSQL");
    }

    public void setProfileSQL(boolean bl) throws SQLException {
        this.setBooleanProperty("profileSQL", bl);
    }

    public int getTcpSndBuf() throws SQLException {
        return this.getIntegerProperty("tcpSndBuf");
    }

    public void setTcpSndBuf(int n) throws SQLException {
        this.setIntegerProperty("tcpSndBuf", n);
    }

    public boolean getEmulateUnsupportedPstmts() throws SQLException {
        return this.getBooleanProperty("emulateUnsupportedPstmts");
    }

    public void setEmulateUnsupportedPstmts(boolean bl) throws SQLException {
        this.setBooleanProperty("emulateUnsupportedPstmts", bl);
    }

    public int getSelfDestructOnPingMaxOperations() throws SQLException {
        return this.getIntegerProperty("selfDestructOnPingMaxOperations");
    }

    public void setSelfDestructOnPingMaxOperations(int n) throws SQLException {
        this.setIntegerProperty("selfDestructOnPingMaxOperations", n);
    }

    public String getSocketFactory() throws SQLException {
        return this.getStringProperty("socketFactory");
    }

    public void setSocketFactory(String string) throws SQLException {
        this.setStringProperty("socketFactory", string);
    }

    public boolean getCacheResultSetMetadata() throws SQLException {
        return this.getBooleanProperty("cacheResultSetMetadata");
    }

    public void setCacheResultSetMetadata(boolean bl) throws SQLException {
        this.setBooleanProperty("cacheResultSetMetadata", bl);
    }

    public String getHaLoadBalanceStrategy() throws SQLException {
        return this.getStringProperty("haLoadBalanceStrategy");
    }

    public void setHaLoadBalanceStrategy(String string) throws SQLException {
        this.setStringProperty("haLoadBalanceStrategy", string);
    }

    public boolean getAllowMasterDownConnections() throws SQLException {
        return this.getBooleanProperty("allowMasterDownConnections");
    }

    public void setAllowMasterDownConnections(boolean bl) throws SQLException {
        this.setBooleanProperty("allowMasterDownConnections", bl);
    }

    public int getMaxReconnects() throws SQLException {
        return this.getIntegerProperty("maxReconnects");
    }

    public void setMaxReconnects(int n) throws SQLException {
        this.setIntegerProperty("maxReconnects", n);
    }

    public boolean getUseSSL() throws SQLException {
        return this.getBooleanProperty("useSSL");
    }

    public void setUseSSL(boolean bl) throws SQLException {
        this.setBooleanProperty("useSSL", bl);
    }

    public String getSessionVariables() throws SQLException {
        return this.getStringProperty("sessionVariables");
    }

    public void setSessionVariables(String string) throws SQLException {
        this.setStringProperty("sessionVariables", string);
    }

    public boolean getAllowSlaveDownConnections() throws SQLException {
        return this.getBooleanProperty("allowSlaveDownConnections");
    }

    public void setAllowSlaveDownConnections(boolean bl) throws SQLException {
        this.setBooleanProperty("allowSlaveDownConnections", bl);
    }

    public boolean getDontTrackOpenResources() throws SQLException {
        return this.getBooleanProperty("dontTrackOpenResources");
    }

    public void setDontTrackOpenResources(boolean bl) throws SQLException {
        this.setBooleanProperty("dontTrackOpenResources", bl);
    }

    public boolean getAllowPublicKeyRetrieval() throws SQLException {
        return this.getBooleanProperty("allowPublicKeyRetrieval");
    }

    public void setAllowPublicKeyRetrieval(boolean bl) throws SQLException {
        this.setBooleanProperty("allowPublicKeyRetrieval", bl);
    }

    public String getTrustCertificateKeyStoreUrl() throws SQLException {
        return this.getStringProperty("trustCertificateKeyStoreUrl");
    }

    public void setTrustCertificateKeyStoreUrl(String string) throws SQLException {
        this.setStringProperty("trustCertificateKeyStoreUrl", string);
    }

    public boolean getPopulateInsertRowWithDefaultValues() throws SQLException {
        return this.getBooleanProperty("populateInsertRowWithDefaultValues");
    }

    public void setPopulateInsertRowWithDefaultValues(boolean bl) throws SQLException {
        this.setBooleanProperty("populateInsertRowWithDefaultValues", bl);
    }

    public boolean getCacheCallableStmts() throws SQLException {
        return this.getBooleanProperty("cacheCallableStmts");
    }

    public void setCacheCallableStmts(boolean bl) throws SQLException {
        this.setBooleanProperty("cacheCallableStmts", bl);
    }

    public String getServerTimezone() throws SQLException {
        return this.getStringProperty("serverTimezone");
    }

    public void setServerTimezone(String string) throws SQLException {
        this.setStringProperty("serverTimezone", string);
    }

    public boolean getXdevapiUseAsyncProtocol() throws SQLException {
        return this.getBooleanProperty("xdevapiUseAsyncProtocol");
    }

    public void setXdevapiUseAsyncProtocol(boolean bl) throws SQLException {
        this.setBooleanProperty("xdevapiUseAsyncProtocol", bl);
    }

    public boolean getJdbcCompliantTruncation() throws SQLException {
        return this.getBooleanProperty("jdbcCompliantTruncation");
    }

    public void setJdbcCompliantTruncation(boolean bl) throws SQLException {
        this.setBooleanProperty("jdbcCompliantTruncation", bl);
    }

    public boolean getTransformedBitIsBoolean() throws SQLException {
        return this.getBooleanProperty("transformedBitIsBoolean");
    }

    public void setTransformedBitIsBoolean(boolean bl) throws SQLException {
        this.setBooleanProperty("transformedBitIsBoolean", bl);
    }

    public String getServerAffinityOrder() throws SQLException {
        return this.getStringProperty("serverAffinityOrder");
    }

    public void setServerAffinityOrder(String string) throws SQLException {
        this.setStringProperty("serverAffinityOrder", string);
    }

    public boolean getAutoReconnectForPools() throws SQLException {
        return this.getBooleanProperty("autoReconnectForPools");
    }

    public void setAutoReconnectForPools(boolean bl) throws SQLException {
        this.setBooleanProperty("autoReconnectForPools", bl);
    }

    public boolean getUseCursorFetch() throws SQLException {
        return this.getBooleanProperty("useCursorFetch");
    }

    public void setUseCursorFetch(boolean bl) throws SQLException {
        this.setBooleanProperty("useCursorFetch", bl);
    }

    public boolean getEmptyStringsConvertToZero() throws SQLException {
        return this.getBooleanProperty("emptyStringsConvertToZero");
    }

    public void setEmptyStringsConvertToZero(boolean bl) throws SQLException {
        this.setBooleanProperty("emptyStringsConvertToZero", bl);
    }

    public long getSlowQueryThresholdNanos() throws SQLException {
        return this.getLongProperty("slowQueryThresholdNanos");
    }

    public void setSlowQueryThresholdNanos(long l) throws SQLException {
        this.setLongProperty("slowQueryThresholdNanos", l);
    }

    public boolean getUseNanosForElapsedTime() throws SQLException {
        return this.getBooleanProperty("useNanosForElapsedTime");
    }

    public void setUseNanosForElapsedTime(boolean bl) throws SQLException {
        this.setBooleanProperty("useNanosForElapsedTime", bl);
    }

    public int getLoadBalanceHostRemovalGracePeriod() throws SQLException {
        return this.getIntegerProperty("loadBalanceHostRemovalGracePeriod");
    }

    public void setLoadBalanceHostRemovalGracePeriod(int n) throws SQLException {
        this.setIntegerProperty("loadBalanceHostRemovalGracePeriod", n);
    }

    public int getSlowQueryThresholdMillis() throws SQLException {
        return this.getIntegerProperty("slowQueryThresholdMillis");
    }

    public void setSlowQueryThresholdMillis(int n) throws SQLException {
        this.setIntegerProperty("slowQueryThresholdMillis", n);
    }

    public int getTcpTrafficClass() throws SQLException {
        return this.getIntegerProperty("tcpTrafficClass");
    }

    public void setTcpTrafficClass(int n) throws SQLException {
        this.setIntegerProperty("tcpTrafficClass", n);
    }

    public int getLoadBalancePingTimeout() throws SQLException {
        return this.getIntegerProperty("loadBalancePingTimeout");
    }

    public void setLoadBalancePingTimeout(int n) throws SQLException {
        this.setIntegerProperty("loadBalancePingTimeout", n);
    }

    public boolean getIncludeInnodbStatusInDeadlockExceptions() throws SQLException {
        return this.getBooleanProperty("includeInnodbStatusInDeadlockExceptions");
    }

    public void setIncludeInnodbStatusInDeadlockExceptions(boolean bl) throws SQLException {
        this.setBooleanProperty("includeInnodbStatusInDeadlockExceptions", bl);
    }

    public boolean getUseCompression() throws SQLException {
        return this.getBooleanProperty("useCompression");
    }

    public void setUseCompression(boolean bl) throws SQLException {
        this.setBooleanProperty("useCompression", bl);
    }

    public boolean getUseOnlyServerErrorMessages() throws SQLException {
        return this.getBooleanProperty("useOnlyServerErrorMessages");
    }

    public void setUseOnlyServerErrorMessages(boolean bl) throws SQLException {
        this.setBooleanProperty("useOnlyServerErrorMessages", bl);
    }

    public String getEnabledSSLCipherSuites() throws SQLException {
        return this.getStringProperty("enabledSSLCipherSuites");
    }

    public void setEnabledSSLCipherSuites(String string) throws SQLException {
        this.setStringProperty("enabledSSLCipherSuites", string);
    }

    public boolean getUseServerPrepStmts() throws SQLException {
        return this.getBooleanProperty("useServerPrepStmts");
    }

    public void setUseServerPrepStmts(boolean bl) throws SQLException {
        this.setBooleanProperty("useServerPrepStmts", bl);
    }

    public String getLoadBalanceSQLStateFailover() throws SQLException {
        return this.getStringProperty("loadBalanceSQLStateFailover");
    }

    public void setLoadBalanceSQLStateFailover(String string) throws SQLException {
        this.setStringProperty("loadBalanceSQLStateFailover", string);
    }

    public int getNetTimeoutForStreamingResults() throws SQLException {
        return this.getIntegerProperty("netTimeoutForStreamingResults");
    }

    public void setNetTimeoutForStreamingResults(int n) throws SQLException {
        this.setIntegerProperty("netTimeoutForStreamingResults", n);
    }

    public boolean getUseUsageAdvisor() throws SQLException {
        return this.getBooleanProperty("useUsageAdvisor");
    }

    public void setUseUsageAdvisor(boolean bl) throws SQLException {
        this.setBooleanProperty("useUsageAdvisor", bl);
    }

    public String getPasswordCharacterEncoding() throws SQLException {
        return this.getStringProperty("passwordCharacterEncoding");
    }

    public void setPasswordCharacterEncoding(String string) throws SQLException {
        this.setStringProperty("passwordCharacterEncoding", string);
    }

    public int getRetriesAllDown() throws SQLException {
        return this.getIntegerProperty("retriesAllDown");
    }

    public void setRetriesAllDown(int n) throws SQLException {
        this.setIntegerProperty("retriesAllDown", n);
    }

    public boolean getUseReadAheadInput() throws SQLException {
        return this.getBooleanProperty("useReadAheadInput");
    }

    public void setUseReadAheadInput(boolean bl) throws SQLException {
        this.setBooleanProperty("useReadAheadInput", bl);
    }

    public boolean getPinGlobalTxToPhysicalConnection() throws SQLException {
        return this.getBooleanProperty("pinGlobalTxToPhysicalConnection");
    }

    public void setPinGlobalTxToPhysicalConnection(boolean bl) throws SQLException {
        this.setBooleanProperty("pinGlobalTxToPhysicalConnection", bl);
    }

    public boolean getAutoClosePStmtStreams() throws SQLException {
        return this.getBooleanProperty("autoClosePStmtStreams");
    }

    public void setAutoClosePStmtStreams(boolean bl) throws SQLException {
        this.setBooleanProperty("autoClosePStmtStreams", bl);
    }

    public boolean getGatherPerfMetrics() throws SQLException {
        return this.getBooleanProperty("gatherPerfMetrics");
    }

    public void setGatherPerfMetrics(boolean bl) throws SQLException {
        this.setBooleanProperty("gatherPerfMetrics", bl);
    }

    public boolean getEmulateLocators() throws SQLException {
        return this.getBooleanProperty("emulateLocators");
    }

    public void setEmulateLocators(boolean bl) throws SQLException {
        this.setBooleanProperty("emulateLocators", bl);
    }

    public String getXdevapiSSLTruststorePassword() throws SQLException {
        return this.getStringProperty("xdevapiSSLTruststorePassword");
    }

    public void setXdevapiSSLTruststorePassword(String string) throws SQLException {
        this.setStringProperty("xdevapiSSLTruststorePassword", string);
    }

    public boolean getGetProceduresReturnsFunctions() throws SQLException {
        return this.getBooleanProperty("getProceduresReturnsFunctions");
    }

    public void setGetProceduresReturnsFunctions(boolean bl) throws SQLException {
        this.setBooleanProperty("getProceduresReturnsFunctions", bl);
    }

    public boolean getMaintainTimeStats() throws SQLException {
        return this.getBooleanProperty("maintainTimeStats");
    }

    public void setMaintainTimeStats(boolean bl) throws SQLException {
        this.setBooleanProperty("maintainTimeStats", bl);
    }

    public String getClientCertificateKeyStoreType() throws SQLException {
        return this.getStringProperty("clientCertificateKeyStoreType");
    }

    public void setClientCertificateKeyStoreType(String string) throws SQLException {
        this.setStringProperty("clientCertificateKeyStoreType", string);
    }

    public boolean getRewriteBatchedStatements() throws SQLException {
        return this.getBooleanProperty("rewriteBatchedStatements");
    }

    public void setRewriteBatchedStatements(boolean bl) throws SQLException {
        this.setBooleanProperty("rewriteBatchedStatements", bl);
    }

    public boolean getUseOldAliasMetadataBehavior() throws SQLException {
        return this.getBooleanProperty("useOldAliasMetadataBehavior");
    }

    public void setUseOldAliasMetadataBehavior(boolean bl) throws SQLException {
        this.setBooleanProperty("useOldAliasMetadataBehavior", bl);
    }

    public String getXdevapiSSLMode() throws SQLException {
        return this.getEnumProperty("xdevapiSSLMode");
    }

    public void setXdevapiSSLMode(String string) throws SQLException {
        this.setEnumProperty("xdevapiSSLMode", string);
    }

    public boolean getCreateDatabaseIfNotExist() throws SQLException {
        return this.getBooleanProperty("createDatabaseIfNotExist");
    }

    public void setCreateDatabaseIfNotExist(boolean bl) throws SQLException {
        this.setBooleanProperty("createDatabaseIfNotExist", bl);
    }

    public int getQueriesBeforeRetryMaster() throws SQLException {
        return this.getIntegerProperty("queriesBeforeRetryMaster");
    }

    public void setQueriesBeforeRetryMaster(int n) throws SQLException {
        this.setIntegerProperty("queriesBeforeRetryMaster", n);
    }

    public String getLoadBalanceSQLExceptionSubclassFailover() throws SQLException {
        return this.getStringProperty("loadBalanceSQLExceptionSubclassFailover");
    }

    public void setLoadBalanceSQLExceptionSubclassFailover(String string) throws SQLException {
        this.setStringProperty("loadBalanceSQLExceptionSubclassFailover", string);
    }

    public int getTcpRcvBuf() throws SQLException {
        return this.getIntegerProperty("tcpRcvBuf");
    }

    public void setTcpRcvBuf(int n) throws SQLException {
        this.setIntegerProperty("tcpRcvBuf", n);
    }

    public boolean getDontCheckOnDuplicateKeyUpdateInSQL() throws SQLException {
        return this.getBooleanProperty("dontCheckOnDuplicateKeyUpdateInSQL");
    }

    public void setDontCheckOnDuplicateKeyUpdateInSQL(boolean bl) throws SQLException {
        this.setBooleanProperty("dontCheckOnDuplicateKeyUpdateInSQL", bl);
    }

    public int getSocksProxyPort() throws SQLException {
        return this.getIntegerProperty("socksProxyPort");
    }

    public void setSocksProxyPort(int n) throws SQLException {
        this.setIntegerProperty("socksProxyPort", n);
    }

    public boolean getUltraDevHack() throws SQLException {
        return this.getBooleanProperty("ultraDevHack");
    }

    public void setUltraDevHack(boolean bl) throws SQLException {
        this.setBooleanProperty("ultraDevHack", bl);
    }

    public boolean getAlwaysSendSetIsolation() throws SQLException {
        return this.getBooleanProperty("alwaysSendSetIsolation");
    }

    public void setAlwaysSendSetIsolation(boolean bl) throws SQLException {
        this.setBooleanProperty("alwaysSendSetIsolation", bl);
    }

    public int getReportMetricsIntervalMillis() throws SQLException {
        return this.getIntegerProperty("reportMetricsIntervalMillis");
    }

    public void setReportMetricsIntervalMillis(int n) throws SQLException {
        this.setIntegerProperty("reportMetricsIntervalMillis", n);
    }

    public boolean getAllowUrlInLocalInfile() throws SQLException {
        return this.getBooleanProperty("allowUrlInLocalInfile");
    }

    public void setAllowUrlInLocalInfile(boolean bl) throws SQLException {
        this.setBooleanProperty("allowUrlInLocalInfile", bl);
    }

    public int getMaxQuerySizeToLog() throws SQLException {
        return this.getIntegerProperty("maxQuerySizeToLog");
    }

    public void setMaxQuerySizeToLog(int n) throws SQLException {
        this.setIntegerProperty("maxQuerySizeToLog", n);
    }

    public boolean getCachePrepStmts() throws SQLException {
        return this.getBooleanProperty("cachePrepStmts");
    }

    public void setCachePrepStmts(boolean bl) throws SQLException {
        this.setBooleanProperty("cachePrepStmts", bl);
    }

    public boolean getFunctionsNeverReturnBlobs() throws SQLException {
        return this.getBooleanProperty("functionsNeverReturnBlobs");
    }

    public void setFunctionsNeverReturnBlobs(boolean bl) throws SQLException {
        this.setBooleanProperty("functionsNeverReturnBlobs", bl);
    }

    public boolean getEnableQueryTimeouts() throws SQLException {
        return this.getBooleanProperty("enableQueryTimeouts");
    }

    public void setEnableQueryTimeouts(boolean bl) throws SQLException {
        this.setBooleanProperty("enableQueryTimeouts", bl);
    }

    public int getSelfDestructOnPingSecondsLifetime() throws SQLException {
        return this.getIntegerProperty("selfDestructOnPingSecondsLifetime");
    }

    public void setSelfDestructOnPingSecondsLifetime(int n) throws SQLException {
        this.setIntegerProperty("selfDestructOnPingSecondsLifetime", n);
    }

    public String getXdevapiSSLTruststore() throws SQLException {
        return this.getStringProperty("xdevapiSSLTruststore");
    }

    public void setXdevapiSSLTruststore(String string) throws SQLException {
        this.setStringProperty("xdevapiSSLTruststore", string);
    }

    public int getPrepStmtCacheSize() throws SQLException {
        return this.getIntegerProperty("prepStmtCacheSize");
    }

    public void setPrepStmtCacheSize(int n) throws SQLException {
        this.setIntegerProperty("prepStmtCacheSize", n);
    }

    public boolean getYearIsDateType() throws SQLException {
        return this.getBooleanProperty("yearIsDateType");
    }

    public void setYearIsDateType(boolean bl) throws SQLException {
        this.setBooleanProperty("yearIsDateType", bl);
    }

    public boolean getCacheServerConfiguration() throws SQLException {
        return this.getBooleanProperty("cacheServerConfiguration");
    }

    public void setCacheServerConfiguration(boolean bl) throws SQLException {
        this.setBooleanProperty("cacheServerConfiguration", bl);
    }

    public boolean getBlobsAreStrings() throws SQLException {
        return this.getBooleanProperty("blobsAreStrings");
    }

    public void setBlobsAreStrings(boolean bl) throws SQLException {
        this.setBooleanProperty("blobsAreStrings", bl);
    }

    public boolean getEnablePacketDebug() throws SQLException {
        return this.getBooleanProperty("enablePacketDebug");
    }

    public void setEnablePacketDebug(boolean bl) throws SQLException {
        this.setBooleanProperty("enablePacketDebug", bl);
    }

    public boolean getReconnectAtTxEnd() throws SQLException {
        return this.getBooleanProperty("reconnectAtTxEnd");
    }

    public void setReconnectAtTxEnd(boolean bl) throws SQLException {
        this.setBooleanProperty("reconnectAtTxEnd", bl);
    }

    public String getTrustCertificateKeyStorePassword() throws SQLException {
        return this.getStringProperty("trustCertificateKeyStorePassword");
    }

    public void setTrustCertificateKeyStorePassword(String string) throws SQLException {
        this.setStringProperty("trustCertificateKeyStorePassword", string);
    }

    public String getAuthenticationPlugins() throws SQLException {
        return this.getStringProperty("authenticationPlugins");
    }

    public void setAuthenticationPlugins(String string) throws SQLException {
        this.setStringProperty("authenticationPlugins", string);
    }

    public String getPropertiesTransform() throws SQLException {
        return this.getStringProperty("propertiesTransform");
    }

    public void setPropertiesTransform(String string) throws SQLException {
        this.setStringProperty("propertiesTransform", string);
    }

    public boolean getClobberStreamingResults() throws SQLException {
        return this.getBooleanProperty("clobberStreamingResults");
    }

    public void setClobberStreamingResults(boolean bl) throws SQLException {
        this.setBooleanProperty("clobberStreamingResults", bl);
    }

    public int getMetadataCacheSize() throws SQLException {
        return this.getIntegerProperty("metadataCacheSize");
    }

    public void setMetadataCacheSize(int n) throws SQLException {
        this.setIntegerProperty("metadataCacheSize", n);
    }

    public boolean getTraceProtocol() throws SQLException {
        return this.getBooleanProperty("traceProtocol");
    }

    public void setTraceProtocol(boolean bl) throws SQLException {
        this.setBooleanProperty("traceProtocol", bl);
    }

    public boolean getNoDatetimeStringSync() throws SQLException {
        return this.getBooleanProperty("noDatetimeStringSync");
    }

    public void setNoDatetimeStringSync(boolean bl) throws SQLException {
        this.setBooleanProperty("noDatetimeStringSync", bl);
    }

    public boolean getRequireSSL() throws SQLException {
        return this.getBooleanProperty("requireSSL");
    }

    public void setRequireSSL(boolean bl) throws SQLException {
        this.setBooleanProperty("requireSSL", bl);
    }

    public String getXdevapiAuth() throws SQLException {
        return this.getStringProperty("xdevapiAuth");
    }

    public void setXdevapiAuth(String string) throws SQLException {
        this.setStringProperty("xdevapiAuth", string);
    }

    public int getConnectTimeout() throws SQLException {
        return this.getIntegerProperty("connectTimeout");
    }

    public void setConnectTimeout(int n) throws SQLException {
        this.setIntegerProperty("connectTimeout", n);
    }

    public int getSocketTimeout() throws SQLException {
        return this.getIntegerProperty("socketTimeout");
    }

    public void setSocketTimeout(int n) throws SQLException {
        this.setIntegerProperty("socketTimeout", n);
    }

    public String getZeroDateTimeBehavior() throws SQLException {
        return this.getEnumProperty("zeroDateTimeBehavior");
    }

    public void setZeroDateTimeBehavior(String string) throws SQLException {
        this.setEnumProperty("zeroDateTimeBehavior", string);
    }

    public String getLocalSocketAddress() throws SQLException {
        return this.getStringProperty("localSocketAddress");
    }

    public void setLocalSocketAddress(String string) throws SQLException {
        this.setStringProperty("localSocketAddress", string);
    }

    public boolean getLogXaCommands() throws SQLException {
        return this.getBooleanProperty("logXaCommands");
    }

    public void setLogXaCommands(boolean bl) throws SQLException {
        this.setBooleanProperty("logXaCommands", bl);
    }

    public int getResultSetSizeThreshold() throws SQLException {
        return this.getIntegerProperty("resultSetSizeThreshold");
    }

    public void setResultSetSizeThreshold(int n) throws SQLException {
        this.setIntegerProperty("resultSetSizeThreshold", n);
    }

    public boolean getInteractiveClient() throws SQLException {
        return this.getBooleanProperty("interactiveClient");
    }

    public void setInteractiveClient(boolean bl) throws SQLException {
        this.setBooleanProperty("interactiveClient", bl);
    }

    public boolean getTcpNoDelay() throws SQLException {
        return this.getBooleanProperty("tcpNoDelay");
    }

    public void setTcpNoDelay(boolean bl) throws SQLException {
        this.setBooleanProperty("tcpNoDelay", bl);
    }

    public boolean getHoldResultsOpenOverStatementClose() throws SQLException {
        return this.getBooleanProperty("holdResultsOpenOverStatementClose");
    }

    public void setHoldResultsOpenOverStatementClose(boolean bl) throws SQLException {
        this.setBooleanProperty("holdResultsOpenOverStatementClose", bl);
    }

    public boolean getDetectCustomCollations() throws SQLException {
        return this.getBooleanProperty("detectCustomCollations");
    }

    public void setDetectCustomCollations(boolean bl) throws SQLException {
        this.setBooleanProperty("detectCustomCollations", bl);
    }

    public int getPacketDebugBufferSize() throws SQLException {
        return this.getIntegerProperty("packetDebugBufferSize");
    }

    public void setPacketDebugBufferSize(int n) throws SQLException {
        this.setIntegerProperty("packetDebugBufferSize", n);
    }

    public boolean getCompensateOnDuplicateKeyUpdateCounts() throws SQLException {
        return this.getBooleanProperty("compensateOnDuplicateKeyUpdateCounts");
    }

    public void setCompensateOnDuplicateKeyUpdateCounts(boolean bl) throws SQLException {
        this.setBooleanProperty("compensateOnDuplicateKeyUpdateCounts", bl);
    }

    public boolean getIncludeThreadNamesAsStatementComment() throws SQLException {
        return this.getBooleanProperty("includeThreadNamesAsStatementComment");
    }

    public void setIncludeThreadNamesAsStatementComment(boolean bl) throws SQLException {
        this.setBooleanProperty("includeThreadNamesAsStatementComment", bl);
    }

    public boolean getNoAccessToProcedureBodies() throws SQLException {
        return this.getBooleanProperty("noAccessToProcedureBodies");
    }

    public void setNoAccessToProcedureBodies(boolean bl) throws SQLException {
        this.setBooleanProperty("noAccessToProcedureBodies", bl);
    }

    public boolean getUseHostsInPrivileges() throws SQLException {
        return this.getBooleanProperty("useHostsInPrivileges");
    }

    public void setUseHostsInPrivileges(boolean bl) throws SQLException {
        this.setBooleanProperty("useHostsInPrivileges", bl);
    }

    public int getDefaultFetchSize() throws SQLException {
        return this.getIntegerProperty("defaultFetchSize");
    }

    public void setDefaultFetchSize(int n) throws SQLException {
        this.setIntegerProperty("defaultFetchSize", n);
    }

    public boolean getAutoReconnect() throws SQLException {
        return this.getBooleanProperty("autoReconnect");
    }

    public void setAutoReconnect(boolean bl) throws SQLException {
        this.setBooleanProperty("autoReconnect", bl);
    }

    public boolean getDisconnectOnExpiredPasswords() throws SQLException {
        return this.getBooleanProperty("disconnectOnExpiredPasswords");
    }

    public void setDisconnectOnExpiredPasswords(boolean bl) throws SQLException {
        this.setBooleanProperty("disconnectOnExpiredPasswords", bl);
    }

    public boolean getContinueBatchOnError() throws SQLException {
        return this.getBooleanProperty("continueBatchOnError");
    }

    public void setContinueBatchOnError(boolean bl) throws SQLException {
        this.setBooleanProperty("continueBatchOnError", bl);
    }

    public boolean getParanoid() throws SQLException {
        return this.getBooleanProperty("paranoid");
    }

    public void setParanoid(boolean bl) throws SQLException {
        this.setBooleanProperty("paranoid", bl);
    }

    public boolean getUseInformationSchema() throws SQLException {
        return this.getBooleanProperty("useInformationSchema");
    }

    public void setUseInformationSchema(boolean bl) throws SQLException {
        this.setBooleanProperty("useInformationSchema", bl);
    }

    public boolean getRollbackOnPooledClose() throws SQLException {
        return this.getBooleanProperty("rollbackOnPooledClose");
    }

    public void setRollbackOnPooledClose(boolean bl) throws SQLException {
        this.setBooleanProperty("rollbackOnPooledClose", bl);
    }

    public boolean getReadOnlyPropagatesToServer() throws SQLException {
        return this.getBooleanProperty("readOnlyPropagatesToServer");
    }

    public void setReadOnlyPropagatesToServer(boolean bl) throws SQLException {
        this.setBooleanProperty("readOnlyPropagatesToServer", bl);
    }

    public int getBlobSendChunkSize() throws SQLException {
        return this.getIntegerProperty("blobSendChunkSize");
    }

    public void setBlobSendChunkSize(int n) throws SQLException {
        this.setIntegerProperty("blobSendChunkSize", n);
    }

    public String getTrustCertificateKeyStoreType() throws SQLException {
        return this.getStringProperty("trustCertificateKeyStoreType");
    }

    public void setTrustCertificateKeyStoreType(String string) throws SQLException {
        this.setStringProperty("trustCertificateKeyStoreType", string);
    }

    public int getXdevapiAsyncResponseTimeout() throws SQLException {
        return this.getIntegerProperty("xdevapiAsyncResponseTimeout");
    }

    public void setXdevapiAsyncResponseTimeout(int n) throws SQLException {
        this.setIntegerProperty("xdevapiAsyncResponseTimeout", n);
    }

    public String getCharacterEncoding() throws SQLException {
        return this.getStringProperty("characterEncoding");
    }

    public void setCharacterEncoding(String string) throws SQLException {
        this.setStringProperty("characterEncoding", string);
    }

    public boolean getVerifyServerCertificate() throws SQLException {
        return this.getBooleanProperty("verifyServerCertificate");
    }

    public void setVerifyServerCertificate(boolean bl) throws SQLException {
        this.setBooleanProperty("verifyServerCertificate", bl);
    }

    public boolean getAutoGenerateTestcaseScript() throws SQLException {
        return this.getBooleanProperty("autoGenerateTestcaseScript");
    }

    public void setAutoGenerateTestcaseScript(boolean bl) throws SQLException {
        this.setBooleanProperty("autoGenerateTestcaseScript", bl);
    }

    public String getConnectionAttributes() throws SQLException {
        return this.getStringProperty("connectionAttributes");
    }

    public void setConnectionAttributes(String string) throws SQLException {
        this.setStringProperty("connectionAttributes", string);
    }

    public boolean getExplainSlowQueries() throws SQLException {
        return this.getBooleanProperty("explainSlowQueries");
    }

    public void setExplainSlowQueries(boolean bl) throws SQLException {
        this.setBooleanProperty("explainSlowQueries", bl);
    }

    public String getParseInfoCacheFactory() throws SQLException {
        return this.getStringProperty("parseInfoCacheFactory");
    }

    public void setParseInfoCacheFactory(String string) throws SQLException {
        this.setStringProperty("parseInfoCacheFactory", string);
    }

    public boolean getEnableEscapeProcessing() throws SQLException {
        return this.getBooleanProperty("enableEscapeProcessing");
    }

    public void setEnableEscapeProcessing(boolean bl) throws SQLException {
        this.setBooleanProperty("enableEscapeProcessing", bl);
    }

    public boolean getFailOverReadOnly() throws SQLException {
        return this.getBooleanProperty("failOverReadOnly");
    }

    public void setFailOverReadOnly(boolean bl) throws SQLException {
        this.setBooleanProperty("failOverReadOnly", bl);
    }

    public int getLocatorFetchBufferSize() throws SQLException {
        return this.getIntegerProperty("locatorFetchBufferSize");
    }

    public void setLocatorFetchBufferSize(int n) throws SQLException {
        this.setIntegerProperty("locatorFetchBufferSize", n);
    }

    public boolean getNullCatalogMeansCurrent() throws SQLException {
        return this.getBooleanProperty("nullCatalogMeansCurrent");
    }

    public void setNullCatalogMeansCurrent(boolean bl) throws SQLException {
        this.setBooleanProperty("nullCatalogMeansCurrent", bl);
    }

    public boolean getTcpKeepAlive() throws SQLException {
        return this.getBooleanProperty("tcpKeepAlive");
    }

    public void setTcpKeepAlive(boolean bl) throws SQLException {
        this.setBooleanProperty("tcpKeepAlive", bl);
    }

    public boolean getUseUnbufferedInput() throws SQLException {
        return this.getBooleanProperty("useUnbufferedInput");
    }

    public void setUseUnbufferedInput(boolean bl) throws SQLException {
        this.setBooleanProperty("useUnbufferedInput", bl);
    }

    public boolean getAllowMultiQueries() throws SQLException {
        return this.getBooleanProperty("allowMultiQueries");
    }

    public void setAllowMultiQueries(boolean bl) throws SQLException {
        this.setBooleanProperty("allowMultiQueries", bl);
    }

    public int getInitialTimeout() throws SQLException {
        return this.getIntegerProperty("initialTimeout");
    }

    public void setInitialTimeout(int n) throws SQLException {
        this.setIntegerProperty("initialTimeout", n);
    }

    public String getProfilerEventHandler() throws SQLException {
        return this.getStringProperty("profilerEventHandler");
    }

    public void setProfilerEventHandler(String string) throws SQLException {
        this.setStringProperty("profilerEventHandler", string);
    }

    public boolean getStrictUpdates() throws SQLException {
        return this.getBooleanProperty("strictUpdates");
    }

    public void setStrictUpdates(boolean bl) throws SQLException {
        this.setBooleanProperty("strictUpdates", bl);
    }

    public boolean getTreatUtilDateAsTimestamp() throws SQLException {
        return this.getBooleanProperty("treatUtilDateAsTimestamp");
    }

    public void setTreatUtilDateAsTimestamp(boolean bl) throws SQLException {
        this.setBooleanProperty("treatUtilDateAsTimestamp", bl);
    }

    public String getServerConfigCacheFactory() throws SQLException {
        return this.getStringProperty("serverConfigCacheFactory");
    }

    public void setServerConfigCacheFactory(String string) throws SQLException {
        this.setStringProperty("serverConfigCacheFactory", string);
    }

    public String getClientCertificateKeyStoreUrl() throws SQLException {
        return this.getStringProperty("clientCertificateKeyStoreUrl");
    }

    public void setClientCertificateKeyStoreUrl(String string) throws SQLException {
        this.setStringProperty("clientCertificateKeyStoreUrl", string);
    }

    public int getPrepStmtCacheSqlLimit() throws SQLException {
        return this.getIntegerProperty("prepStmtCacheSqlLimit");
    }

    public void setPrepStmtCacheSqlLimit(int n) throws SQLException {
        this.setIntegerProperty("prepStmtCacheSqlLimit", n);
    }

    public String getClientInfoProvider() throws SQLException {
        return this.getStringProperty("clientInfoProvider");
    }

    public void setClientInfoProvider(String string) throws SQLException {
        this.setStringProperty("clientInfoProvider", string);
    }

    public String getConnectionCollation() throws SQLException {
        return this.getStringProperty("connectionCollation");
    }

    public void setConnectionCollation(String string) throws SQLException {
        this.setStringProperty("connectionCollation", string);
    }

    public String getLoadBalanceExceptionChecker() throws SQLException {
        return this.getStringProperty("loadBalanceExceptionChecker");
    }

    public void setLoadBalanceExceptionChecker(String string) throws SQLException {
        this.setStringProperty("loadBalanceExceptionChecker", string);
    }

    public String getReplicationConnectionGroup() throws SQLException {
        return this.getStringProperty("replicationConnectionGroup");
    }

    public void setReplicationConnectionGroup(String string) throws SQLException {
        this.setStringProperty("replicationConnectionGroup", string);
    }

    public boolean getGenerateSimpleParameterMetadata() throws SQLException {
        return this.getBooleanProperty("generateSimpleParameterMetadata");
    }

    public void setGenerateSimpleParameterMetadata(boolean bl) throws SQLException {
        this.setBooleanProperty("generateSimpleParameterMetadata", bl);
    }

    public boolean getProcessEscapeCodesForPrepStmts() throws SQLException {
        return this.getBooleanProperty("processEscapeCodesForPrepStmts");
    }

    public void setProcessEscapeCodesForPrepStmts(boolean bl) throws SQLException {
        this.setBooleanProperty("processEscapeCodesForPrepStmts", bl);
    }

    public boolean getLogSlowQueries() throws SQLException {
        return this.getBooleanProperty("logSlowQueries");
    }

    public void setLogSlowQueries(boolean bl) throws SQLException {
        this.setBooleanProperty("logSlowQueries", bl);
    }

    public boolean getUseOldUTF8Behavior() throws SQLException {
        return this.getBooleanProperty("useOldUTF8Behavior");
    }

    public void setUseOldUTF8Behavior(boolean bl) throws SQLException {
        this.setBooleanProperty("useOldUTF8Behavior", bl);
    }

    public int getCallableStmtCacheSize() throws SQLException {
        return this.getIntegerProperty("callableStmtCacheSize");
    }

    public void setCallableStmtCacheSize(int n) throws SQLException {
        this.setIntegerProperty("callableStmtCacheSize", n);
    }

    public String getUseConfigs() throws SQLException {
        return this.getStringProperty("useConfigs");
    }

    public void setUseConfigs(String string) throws SQLException {
        this.setStringProperty("useConfigs", string);
    }

    public boolean getIncludeThreadDumpInDeadlockExceptions() throws SQLException {
        return this.getBooleanProperty("includeThreadDumpInDeadlockExceptions");
    }

    public void setIncludeThreadDumpInDeadlockExceptions(boolean bl) throws SQLException {
        this.setBooleanProperty("includeThreadDumpInDeadlockExceptions", bl);
    }

    public boolean getUseStreamLengthsInPrepStmts() throws SQLException {
        return this.getBooleanProperty("useStreamLengthsInPrepStmts");
    }

    public void setUseStreamLengthsInPrepStmts(boolean bl) throws SQLException {
        this.setBooleanProperty("useStreamLengthsInPrepStmts", bl);
    }

    public String getDisabledAuthenticationPlugins() throws SQLException {
        return this.getStringProperty("disabledAuthenticationPlugins");
    }

    public void setDisabledAuthenticationPlugins(String string) throws SQLException {
        this.setStringProperty("disabledAuthenticationPlugins", string);
    }

    public boolean getTinyInt1isBit() throws SQLException {
        return this.getBooleanProperty("tinyInt1isBit");
    }

    public void setTinyInt1isBit(boolean bl) throws SQLException {
        this.setBooleanProperty("tinyInt1isBit", bl);
    }

    public String getLoadBalanceConnectionGroup() throws SQLException {
        return this.getStringProperty("loadBalanceConnectionGroup");
    }

    public void setLoadBalanceConnectionGroup(String string) throws SQLException {
        this.setStringProperty("loadBalanceConnectionGroup", string);
    }

    public boolean getReadFromMasterWhenNoSlaves() throws SQLException {
        return this.getBooleanProperty("readFromMasterWhenNoSlaves");
    }

    public void setReadFromMasterWhenNoSlaves(boolean bl) throws SQLException {
        this.setBooleanProperty("readFromMasterWhenNoSlaves", bl);
    }

    public String getClientCertificateKeyStorePassword() throws SQLException {
        return this.getStringProperty("clientCertificateKeyStorePassword");
    }

    public void setClientCertificateKeyStorePassword(String string) throws SQLException {
        this.setStringProperty("clientCertificateKeyStorePassword", string);
    }

    public boolean getSendFractionalSeconds() throws SQLException {
        return this.getBooleanProperty("sendFractionalSeconds");
    }

    public void setSendFractionalSeconds(boolean bl) throws SQLException {
        this.setBooleanProperty("sendFractionalSeconds", bl);
    }

    public boolean getAllowNanAndInf() throws SQLException {
        return this.getBooleanProperty("allowNanAndInf");
    }

    public void setAllowNanAndInf(boolean bl) throws SQLException {
        this.setBooleanProperty("allowNanAndInf", bl);
    }

    public String getQueryInterceptors() throws SQLException {
        return this.getStringProperty("queryInterceptors");
    }

    public void setQueryInterceptors(String string) throws SQLException {
        this.setStringProperty("queryInterceptors", string);
    }

    public boolean getAutoSlowLog() throws SQLException {
        return this.getBooleanProperty("autoSlowLog");
    }

    public void setAutoSlowLog(boolean bl) throws SQLException {
        this.setBooleanProperty("autoSlowLog", bl);
    }

    public String getXdevapiSSLTruststoreType() throws SQLException {
        return this.getStringProperty("xdevapiSSLTruststoreType");
    }

    public void setXdevapiSSLTruststoreType(String string) throws SQLException {
        this.setStringProperty("xdevapiSSLTruststoreType", string);
    }

    public int getSecondsBeforeRetryMaster() throws SQLException {
        return this.getIntegerProperty("secondsBeforeRetryMaster");
    }

    public void setSecondsBeforeRetryMaster(int n) throws SQLException {
        this.setIntegerProperty("secondsBeforeRetryMaster", n);
    }

    public boolean getUseLocalSessionState() throws SQLException {
        return this.getBooleanProperty("useLocalSessionState");
    }

    public void setUseLocalSessionState(boolean bl) throws SQLException {
        this.setBooleanProperty("useLocalSessionState", bl);
    }

    public String getConnectionLifecycleInterceptors() throws SQLException {
        return this.getStringProperty("connectionLifecycleInterceptors");
    }

    public void setConnectionLifecycleInterceptors(String string) throws SQLException {
        this.setStringProperty("connectionLifecycleInterceptors", string);
    }
}

