/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.conf.PropertyDefinition;
import com.mysql.cj.api.xdevapi.JsonValue;
import com.mysql.cj.api.xdevapi.PasswordHandler;
import com.mysql.cj.api.xdevapi.PersistenceHandler;
import com.mysql.cj.core.conf.PropertyDefinitions;
import com.mysql.cj.core.conf.url.ConnectionUrl;
import com.mysql.cj.core.exceptions.CJOperationNotSupportedException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.xdevapi.DbDoc;
import com.mysql.cj.xdevapi.DefaultPersistenceHandler;
import com.mysql.cj.xdevapi.JsonParser;
import com.mysql.cj.xdevapi.JsonString;
import com.mysql.cj.xdevapi.SessionConfig;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SessionConfigManager {
    private static PersistenceHandler persistenceHandler = new DefaultPersistenceHandler();
    private static PasswordHandler passwordHandler = new PasswordHandler(){};

    private SessionConfigManager() {
    }

    public static SessionConfig save(String name, String uri, String appDataJson) {
        try {
            return SessionConfigManager.save(name, uri, JsonParser.parseDoc(new StringReader(appDataJson)));
        }
        catch (IOException e) {
            throw ExceptionFactory.createException("Failed to parse the given application data.");
        }
    }

    public static SessionConfig save(String name, String uri, Properties appDataProps) {
        DbDoc appData = new DbDoc();
        for (String key : appDataProps.stringPropertyNames()) {
            appData.put(key, new JsonString().setValue(appDataProps.getProperty(key)));
        }
        return SessionConfigManager.save(name, uri, appData);
    }

    public static SessionConfig save(String name, String uri, Map<String, String> appDataMap) {
        DbDoc appData = appDataMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new JsonString().setValue((String)e.getValue()), (a, b) -> a, DbDoc::new));
        return SessionConfigManager.save(name, uri, appData);
    }

    public static SessionConfig save(String name, String uri, DbDoc appDataJson) {
        DbDoc configData = new DbDoc();
        configData.put(Attr.URI.getKey(), new JsonString().setValue(uri));
        configData.put(Attr.APPDATA.getKey(), appDataJson);
        return SessionConfigManager.save(name, configData);
    }

    public static SessionConfig save(String name, String uriOrJson) {
        DbDoc configData;
        if (uriOrJson.trim().startsWith("mysqlx://")) {
            configData = new DbDoc();
            configData.put(Attr.URI.getKey(), new JsonString().setValue(uriOrJson));
        } else {
            try {
                configData = JsonParser.parseDoc(new StringReader(uriOrJson));
            }
            catch (IOException e) {
                throw ExceptionFactory.createException("Failed to parse the given JSON structure.", e);
            }
        }
        return SessionConfigManager.save(name, configData);
    }

    public static SessionConfig save(String name, Properties data) {
        DbDoc configData = new DbDoc();
        DbDoc appData = new DbDoc();
        for (String key : data.stringPropertyNames()) {
            if (key.equals(Attr.APPDATA.getKey())) {
                try {
                    DbDoc tmpAppData = JsonParser.parseDoc(new StringReader(data.getProperty(key)));
                    appData.putAll(tmpAppData);
                    continue;
                }
                catch (IOException ex) {
                    throw ExceptionFactory.createException("Failed to parse the internal 'appdata' JSON structure.", ex);
                }
            }
            if (SessionConfigManager.isValidAttribute(key)) {
                configData.put(key, new JsonString().setValue(data.getProperty(key)));
                continue;
            }
            appData.put(key, new JsonString().setValue(data.getProperty(key)));
        }
        if (appData.size() > 0) {
            configData.put(Attr.APPDATA.getKey(), appData);
        }
        return SessionConfigManager.save(name, configData);
    }

    public static SessionConfig save(String name, Map<String, String> data) {
        DbDoc configData = new DbDoc();
        DbDoc appData = new DbDoc();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            if (entry.getKey().equals(Attr.APPDATA.getKey())) {
                try {
                    DbDoc tmpAppData = JsonParser.parseDoc(new StringReader(entry.getValue()));
                    appData.putAll(tmpAppData);
                    continue;
                }
                catch (IOException ex) {
                    throw ExceptionFactory.createException("Failed to parse the internal 'appdata' JSON structure.", ex);
                }
            }
            if (SessionConfigManager.isValidAttribute(entry.getKey())) {
                configData.put(entry.getKey(), new JsonString().setValue(entry.getValue()));
                continue;
            }
            appData.put(entry.getKey(), new JsonString().setValue(entry.getValue()));
        }
        if (appData.size() > 0) {
            configData.put(Attr.APPDATA.getKey(), appData);
        }
        return SessionConfigManager.save(name, configData);
    }

    public static SessionConfig save(String name, DbDoc data) {
        DbDoc appData;
        Map<String, String> connProps;
        String schema;
        String port;
        String host;
        String password;
        boolean hasPassword;
        String user;
        String uri;
        DbDoc configData = new DbDoc();
        if (data.containsKey(Attr.URI.getKey())) {
            if (data.size() > 2 || data.size() == 2 && !data.containsKey(Attr.APPDATA.getKey())) {
                throw ExceptionFactory.createException("Invalid JSON document. Only the keys '" + Attr.URI.getKey() + "' and '" + Attr.APPDATA.getKey() + "' are allowed together.");
            }
            uri = SessionConfigManager.jsonToString((JsonValue)data.get(Attr.URI.getKey()));
        } else {
            if (!data.keySet().stream().allMatch(SessionConfigManager::isValidAttribute)) {
                throw ExceptionFactory.createException("Invalid JSON document. Only the URI component keys '" + Attr.USER.getKey() + ", " + Attr.PASSWORD.getKey() + ", " + Attr.HOST.getKey() + ", " + Attr.PORT.getKey() + " and " + Attr.SCHEMA.getKey() + "', valid connection properties and '" + Attr.APPDATA.getKey() + "' are allowed together.");
            }
            user = data.containsKey(Attr.USER.getKey()) ? SessionConfigManager.jsonToString((JsonValue)data.get(Attr.USER.getKey())) : "";
            hasPassword = data.containsKey(Attr.PASSWORD.getKey());
            password = hasPassword ? SessionConfigManager.jsonToString((JsonValue)data.get(Attr.PASSWORD.getKey())) : null;
            host = data.containsKey(Attr.HOST.getKey()) ? SessionConfigManager.jsonToString((JsonValue)data.get(Attr.HOST.getKey())) : "";
            port = data.containsKey(Attr.PORT.getKey()) ? SessionConfigManager.jsonToString((JsonValue)data.get(Attr.PORT.getKey())) : "";
            schema = data.containsKey(Attr.SCHEMA.getKey()) ? SessionConfigManager.jsonToString((JsonValue)data.get(Attr.SCHEMA.getKey())) : "";
            connProps = data.entrySet().stream().filter(e -> !Attr.contains((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> SessionConfigManager.jsonToString((JsonValue)e.getValue())));
            uri = SessionConfigManager.buildUri(user, hasPassword, password, host, port, schema, connProps);
        }
        ConnectionUrl connUrl = ConnectionUrl.getConnectionUrlInstance(uri, null);
        user = connUrl.getMainHost().getUser();
        hasPassword = !connUrl.getMainHost().isPasswordless();
        password = hasPassword ? connUrl.getMainHost().getPassword() : null;
        host = connUrl.getMainHost().getHost();
        port = String.valueOf(connUrl.getMainHost().getPort());
        schema = connUrl.getMainHost().getDatabase();
        connProps = connUrl.getOriginalProperties().entrySet().stream().filter(e -> !Attr.contains((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String rebuiltUri = SessionConfigManager.buildUri(user, hasPassword, password, host, port, schema, connProps);
        String passwordlessUri = SessionConfigManager.buildPasswordlessUri(user, hasPassword, host, port, schema, connProps);
        configData.put(Attr.URI.getKey(), new JsonString().setValue(passwordlessUri));
        DbDoc dbDoc = appData = data.containsKey(Attr.APPDATA.getKey()) ? (DbDoc)data.get(Attr.APPDATA.getKey()) : null;
        if (appData != null && !appData.isEmpty()) {
            configData.put(Attr.APPDATA.getKey(), appData);
        }
        try {
            persistenceHandler.save(name, configData);
            if (hasPassword) {
                String key = user;
                String service = host + ":" + port;
                try {
                    passwordHandler.save(key, service, password);
                }
                catch (CJOperationNotSupportedException cJOperationNotSupportedException) {}
            }
        }
        catch (Exception e2) {
            throw ExceptionFactory.createException("Failed to save the session configuration '" + name + "'.", e2);
        }
        return SessionConfigManager.makeSessionConfig(name, rebuiltUri, appData);
    }

    public static SessionConfig save(SessionConfig sessionConfig) {
        DbDoc appData = sessionConfig.getAppData().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new JsonString().setValue((String)e.getValue()), (a, b) -> a, DbDoc::new));
        return SessionConfigManager.save(sessionConfig.getName(), sessionConfig.getUri(), appData);
    }

    public static SessionConfig get(String name) {
        try {
            DbDoc configData = persistenceHandler.load(name);
            if (!configData.containsKey(Attr.URI.getKey())) {
                ExceptionFactory.createException("URI missing from session configuration '" + name + "'.");
            }
            String uri = SessionConfigManager.jsonToString((JsonValue)configData.get(Attr.URI.getKey()));
            DbDoc appData = (DbDoc)configData.get(Attr.APPDATA.getKey());
            ConnectionUrl connUrl = ConnectionUrl.getConnectionUrlInstance(uri, null);
            String user = connUrl.getMainHost().getUser();
            boolean hasPassword = !connUrl.getMainHost().isPasswordless();
            String password = null;
            String host = connUrl.getMainHost().getHost();
            String port = String.valueOf(connUrl.getMainHost().getPort());
            String schema = connUrl.getMainHost().getDatabase();
            Map<String, String> connProps = connUrl.getOriginalProperties().entrySet().stream().filter(e -> !Attr.contains((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            String key = user;
            String service = host + ":" + port;
            try {
                password = passwordHandler.load(key, service);
            }
            catch (CJOperationNotSupportedException cJOperationNotSupportedException) {
                // empty catch block
            }
            hasPassword = hasPassword || password != null;
            String rebuiltUri = SessionConfigManager.buildUri(user, hasPassword, password, host, port, schema, connProps);
            return SessionConfigManager.makeSessionConfig(name, rebuiltUri, appData);
        }
        catch (Exception e2) {
            throw ExceptionFactory.createException("Failed to get the session configuration '" + name + "'.", e2);
        }
    }

    public static boolean delete(String name) {
        try {
            return persistenceHandler.delete(name);
        }
        catch (Exception e) {
            throw ExceptionFactory.createException("Failed to delete the session configuration '" + name + "'.", e);
        }
    }

    public static List<String> list() {
        try {
            return persistenceHandler.list();
        }
        catch (Exception e) {
            throw ExceptionFactory.createException("Failed to get the session configurations list.", e);
        }
    }

    public static synchronized void setPersistenceHandler(PersistenceHandler persistenceHandler) {
        SessionConfigManager.persistenceHandler = persistenceHandler == null ? new PersistenceHandler(){} : persistenceHandler;
    }

    public static synchronized void setPasswordHandler(PasswordHandler passwordHandler) {
        SessionConfigManager.passwordHandler = passwordHandler == null ? new PasswordHandler(){} : passwordHandler;
    }

    private static boolean isValidAttribute(String key) {
        PropertyDefinition<?> pDef;
        return Attr.contains(key) || (pDef = PropertyDefinitions.getPropertyDefinition(key)) != null && pDef.getCategory().equals(PropertyDefinitions.CATEGORY_XDEVAPI);
    }

    private static String jsonToString(JsonValue jsonValue) {
        if (jsonValue instanceof JsonString) {
            return ((JsonString)jsonValue).getString();
        }
        return jsonValue.toString();
    }

    private static String buildUri(String user, boolean hasPassword, String password, String host, String port, String schema, Map<String, String> connProps) {
        StringBuilder uri = new StringBuilder(ConnectionUrl.Type.XDEVAPI_SESSION.getProtocol());
        uri.append("//");
        if (!StringUtils.isEmptyOrWhitespaceOnly(user)) {
            uri.append(user);
            if (hasPassword) {
                uri.append(':');
                if (password != null) {
                    uri.append(password);
                }
            }
            uri.append('@');
        }
        if (!StringUtils.isEmptyOrWhitespaceOnly(host)) {
            uri.append(host);
        }
        if (!StringUtils.isEmptyOrWhitespaceOnly(port)) {
            uri.append(':');
            uri.append(port);
        }
        uri.append('/');
        if (!StringUtils.isEmptyOrWhitespaceOnly(schema)) {
            uri.append(schema);
        }
        if (!connProps.isEmpty()) {
            uri.append('?');
            String connPropsStr = connProps.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
            uri.append(connPropsStr);
        }
        return uri.toString();
    }

    private static String buildPasswordlessUri(String user, boolean hasPassword, String host, String port, String schema, Map<String, String> connProps) {
        return SessionConfigManager.buildUri(user, hasPassword, null, host, port, schema, connProps);
    }

    private static SessionConfig makeSessionConfig(String name, String uri, DbDoc appData) {
        SessionConfig sessionConfig = new SessionConfig(name, uri);
        if (appData != null && !appData.isEmpty()) {
            appData.entrySet().forEach(e -> sessionConfig.setAppData((String)e.getKey(), SessionConfigManager.jsonToString((JsonValue)e.getValue())));
        }
        return sessionConfig;
    }

    public static enum Attr {
        URI("uri"),
        APPDATA("appdata"),
        USER("user"),
        PASSWORD("password"),
        HOST("host"),
        PORT("port"),
        SCHEMA("schema");

        private String key;

        private Attr(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static boolean contains(String key) {
            return Stream.of(Attr.values()).filter(a -> a.getKey().equals(key)).findFirst().isPresent();
        }
    }
}

