/*
 * Decompiled with CFR 0.152.
 */
package eleme.openapi.sdk.oauth;

import eleme.openapi.sdk.config.Config;
import eleme.openapi.sdk.oauth.IOAuthClient;
import eleme.openapi.sdk.oauth.impl.DefaultIOAuthClient;
import eleme.openapi.sdk.oauth.impl.ServerOAuthCodeImpl;
import eleme.openapi.sdk.oauth.request.ClientTokenRequest;
import eleme.openapi.sdk.oauth.request.ServerRefreshTokenRequest;
import eleme.openapi.sdk.oauth.request.ServerTokenRequest;
import eleme.openapi.sdk.oauth.response.Token;

public class OAuthClient {
    private Config config;
    private IOAuthClient ioAuthClient = null;

    public OAuthClient(Config config) {
        this.config = config;
    }

    public Token getTokenInClientCredentials() {
        this.ioAuthClient = new DefaultIOAuthClient(this.config);
        ClientTokenRequest oAuthRequest = new ClientTokenRequest(this.config);
        Token token = this.ioAuthClient.execute(oAuthRequest);
        return token;
    }

    public String getAuthUrl(String redirect_uri, String scope, String state) {
        ServerOAuthCodeImpl serverOAuthCode = new ServerOAuthCodeImpl(this.config.getOauthCodeUrl(), this.config.getApp_key());
        return serverOAuthCode.getAuthUrl(redirect_uri, scope, state);
    }

    public Token getTokenByCode(String authCode, String redirect_uri) {
        this.ioAuthClient = new DefaultIOAuthClient(this.config);
        ServerTokenRequest serverTokenRequest = new ServerTokenRequest(this.config);
        serverTokenRequest.setCode(authCode);
        serverTokenRequest.setRedirectUri(redirect_uri);
        Token token = this.ioAuthClient.execute(serverTokenRequest);
        return token;
    }

    public Token getTokenByRefreshToken(String refreshToken) {
        this.ioAuthClient = new DefaultIOAuthClient(this.config);
        ServerRefreshTokenRequest refreshTokenRequest = new ServerRefreshTokenRequest(this.config);
        refreshTokenRequest.setRefreshToken(refreshToken);
        Token token = this.ioAuthClient.execute(refreshTokenRequest);
        return token;
    }
}

